/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.BufferedLineReader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.SamAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;

public class BAMWebserviceReader
implements AlignmentReader {
    Logger log = Logger.getLogger(BAMWebserviceReader.class);
    String serverURL;
    String file;
    SAMFileHeader header;
    List<String> sequenceNames;

    public BAMWebserviceReader(ResourceLocator locator) {
        this.serverURL = locator.getServerURL();
        this.file = locator.getPath();
        this.loadHeader();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public CloseableIterator<Alignment> query(String chr, int start, int end, boolean contained) {
        try {
            URL url = new URL(this.serverURL + "?method=samQuery&samFile=" + this.file + "&chr=" + chr + "&start=" + start + "&end=" + end + "&contained=" + contained);
            InputStream is = HttpUtils.getInstance().openConnectionStream(url);
            return new RemoteQueryIterator(new GZIPInputStream(is, 8192));
        }
        catch (IOException ex) {
            this.log.error("Error opening file", ex);
            throw new RuntimeException(ex);
        }
    }

    public SAMFileHeader getHeader() {
        if (this.header == null) {
            this.loadHeader();
        }
        return this.header;
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            SAMFileHeader header = this.getHeader();
            if (header == null) {
                return null;
            }
            this.sequenceNames = new ArrayList<String>();
            List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
            if (records.size() > 0) {
                boolean ensembleChrConventions = true;
                for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                    String chr = rec.getSequenceName();
                    this.sequenceNames.add(chr);
                }
            }
        }
        return this.sequenceNames;
    }

    private void loadHeader() {
        InputStream is = null;
        try {
            URL url = new URL(this.serverURL + "?method=samHeader&samFile=" + this.file);
            is = HttpUtils.getInstance().openConnectionStream(url);
            BufferedLineReader reader = new BufferedLineReader(is);
            SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
            this.header = codec.decode(reader, null);
        }
        catch (IOException ex) {
            this.log.error("Error opening file", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.log.error("Error closing url stream", ex);
                }
            }
        }
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class RemoteQueryIterator
    implements CloseableIterator<Alignment> {
        InputStream inputStream;
        SAMRecord nextRecord;
        BAMRecordCodec codec;

        public RemoteQueryIterator(InputStream is) {
            this.inputStream = is;
            this.codec = new BAMRecordCodec(BAMWebserviceReader.this.header);
            this.codec.setInputStream(is);
            this.advance();
        }

        private void advance() {
            this.nextRecord = this.codec.decode();
        }

        @Override
        public void close() {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException ex) {
                    BAMWebserviceReader.this.log.error("Error closing sam record stream", ex);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public SamAlignment next() {
            SamAlignment ret = new SamAlignment(this.nextRecord);
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }
}

