/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.MessageUtils;

public class LongRunningTask
implements Callable {
    private static Logger log = Logger.getLogger(LongRunningTask.class);
    private static ExecutorService threadExecutor = Executors.newFixedThreadPool(10);
    private static ScheduledExecutorService schedule = Executors.newScheduledThreadPool(1);
    Runnable runnable;

    public static Future submit(Runnable runnable) {
        if (Globals.isBatch() || !IGV.getInstance().isStartupComplete()) {
            runnable.run();
            return null;
        }
        return threadExecutor.submit(new LongRunningTask(runnable));
    }

    public static Future schedule(Runnable runnable, long time) {
        return schedule.schedule(new LongRunningTask(runnable), time, TimeUnit.MILLISECONDS);
    }

    public LongRunningTask(Runnable runnable) {
        this.runnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            this.runnable.run();
            Object var2_2 = null;
            return var2_2;
        }
        catch (Exception e) {
            MessageUtils.showMessage("<html>Unexpected error: " + e.getMessage() + ".<br>See igv.log for more details");
            log.error("Exception running task", e);
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
        }
    }
}

