/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.vcf;

import org.broad.tribble.util.variantcontext.VariantContext;
import org.broad.tribble.vcf.SortingVCFWriterBase;
import org.broad.tribble.vcf.VCFWriter;

public class SortingVCFWriter
extends SortingVCFWriterBase {
    private int maxCachingStartDistance;

    public SortingVCFWriter(VCFWriter innerWriter, int maxCachingStartDistance, boolean takeOwnershipOfInner) {
        super(innerWriter, takeOwnershipOfInner);
        this.maxCachingStartDistance = maxCachingStartDistance;
    }

    public SortingVCFWriter(VCFWriter innerWriter, int maxCachingStartDistance) {
        this(innerWriter, maxCachingStartDistance, false);
    }

    @Override
    protected void noteCurrentRecord(VariantContext vc) {
        super.noteCurrentRecord(vc);
        int mostUpstreamWritableIndex = vc.getStart() - this.maxCachingStartDistance;
        this.mostUpstreamWritableLoc = Math.max(0, mostUpstreamWritableIndex);
    }
}

