/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;

public class TrackGroup {
    private String name;
    private boolean drawBorder = true;
    private List<Track> tracks;
    private boolean selected;

    public TrackGroup() {
        this("");
    }

    public TrackGroup(String name) {
        this.name = name;
        this.tracks = new ArrayList<Track>();
    }

    public boolean contains(Track track) {
        return this.tracks.contains(track);
    }

    public int getPreferredHeight() {
        int height = 0;
        for (Track track : this.tracks) {
            if (track == null || !track.isVisible()) continue;
            height += track.getPreferredHeight();
        }
        return height;
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public int indexOf(Track track) {
        return this.tracks.indexOf(track);
    }

    public int size() {
        return this.tracks.size();
    }

    public void add(Track track) {
        this.tracks.add(track);
    }

    public void add(int pos, Track track) {
        this.tracks.add(pos, track);
    }

    public void addAll(Collection<Track> trackList) {
        this.tracks.addAll(trackList);
    }

    public void addAll(int index, Collection<Track> trackList) {
        this.tracks.addAll(index, trackList);
    }

    public void remove(Track track) {
        this.tracks.remove(track);
    }

    public void clear() {
        this.tracks.clear();
    }

    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, ReferenceFrame frame) {
        float score = -3.4028235E38f;
        for (Track track : this.tracks) {
            if (!track.isVisible()) continue;
            score = Math.max(score, track.getRegionScore(chr, start, end, zoom, type, frame));
        }
        return score;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public boolean isVisible() {
        for (Track t : this.tracks) {
            if (t == null || !t.isVisible()) continue;
            return true;
        }
        return false;
    }

    public int getHeight() {
        int h2 = 0;
        for (Track track : this.tracks) {
            if (!track.isVisible()) continue;
            h2 += track.getHeight();
        }
        return h2;
    }

    public void renderName(Graphics2D g2D, Rectangle rect, boolean isSelected) {
        int fontSize = PreferenceManager.getInstance().getAsInt("DEFAULT_FONT_SIZE");
        Font font = FontManager.getFont(1, fontSize);
        g2D.setFont(font);
        GraphicUtils.drawWrappedText(this.getName(), rect, g2D, true);
    }

    public void sortByAttributes(final String[] attributeNames, final boolean[] ascending) {
        if (this.tracks != null && !this.tracks.isEmpty()) {
            Comparator comparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Track t1 = (Track)arg0;
                    Track t2 = (Track)arg1;
                    for (int i2 = 0; i2 < attributeNames.length; ++i2) {
                        int k2;
                        String attName = attributeNames[i2];
                        if (attName == null) continue;
                        String value1 = t1.getAttributeValue(attName);
                        if (value1 == null) {
                            value1 = "";
                        }
                        value1 = value1.toLowerCase();
                        String value2 = t2.getAttributeValue(attName);
                        if (value2 == null) {
                            value2 = "";
                        }
                        value2 = value2.toLowerCase();
                        int c2 = 0;
                        if (value1.matches("[^0-9]") || value2.matches("[^0-9]")) {
                            c2 = value1.compareTo(value2);
                        } else {
                            boolean numeric = false;
                            for (k2 = 0; k2 < value1.length() && k2 < value2.length(); ++k2) {
                                while (k2 < value1.length() && k2 < value2.length() && Character.isDigit(value1.charAt(k2)) && Character.isDigit(value2.charAt(k2))) {
                                    int num1 = Character.getNumericValue(value1.charAt(k2));
                                    int num2 = Character.getNumericValue(value2.charAt(k2));
                                    if (c2 == 0) {
                                        if (num1 < num2) {
                                            c2 = -1;
                                        }
                                        if (num1 > num2) {
                                            c2 = 1;
                                        }
                                    }
                                    ++k2;
                                    numeric = true;
                                }
                                if (numeric && k2 < value1.length() && Character.isDigit(value1.charAt(k2))) {
                                    c2 = 1;
                                    numeric = false;
                                } else if (numeric && k2 < value2.length() && Character.isDigit(value2.charAt(k2))) {
                                    c2 = -1;
                                    numeric = false;
                                }
                                if (k2 < value1.length() && k2 < value2.length() && c2 == 0) {
                                    c2 = Character.valueOf(value1.charAt(k2)).compareTo(Character.valueOf(value2.charAt(k2)));
                                }
                                if (c2 != 0) break;
                            }
                        }
                        if (c2 == 0 && k2 < value1.length()) {
                            c2 = 1;
                        }
                        if (c2 == 0 && k2 < value2.length()) {
                            c2 = -1;
                        }
                        if (c2 == 0) continue;
                        return ascending[i2] ? c2 : -c2;
                    }
                    return 0;
                }
            };
            ArrayList<Track> unsortableTracks = new ArrayList<Track>();
            HashMap<Track, Integer> trackIndeces = new HashMap<Track, Integer>();
            for (int i2 = this.tracks.size() - 1; i2 >= 0; --i2) {
                if (this.tracks.get(i2).isSortable()) continue;
                Track t = this.tracks.remove(i2);
                unsortableTracks.add(t);
                trackIndeces.put(t, i2);
            }
            Collections.sort(this.tracks, comparator);
            if (unsortableTracks.size() > 0) {
                for (Track t : unsortableTracks) {
                    int index = (Integer)trackIndeces.get(t);
                    if (index < this.tracks.size()) {
                        this.tracks.add(index, t);
                        continue;
                    }
                    this.tracks.add(t);
                }
            }
        }
    }

    public void sortGroup(RegionOfInterest region, String linkingAtt, RegionScoreType type, ReferenceFrame frame) {
        ArrayList<Track> unsortableTracks = new ArrayList<Track>();
        HashMap<Track, Integer> trackIndeces = new HashMap<Track, Integer>();
        for (int i2 = this.tracks.size() - 1; i2 >= 0; --i2) {
            if (this.tracks.get(i2).isSortable()) continue;
            Track t = this.tracks.remove(i2);
            unsortableTracks.add(t);
            trackIndeces.put(t, i2);
        }
        ArrayList<Track> tracksWithScore = new ArrayList<Track>(this.getTracks().size());
        ArrayList<Track> otherTracks = new ArrayList<Track>(this.getTracks().size());
        for (Track t : this.getTracks()) {
            if (t.isRegionScoreType(type)) {
                tracksWithScore.add(t);
                continue;
            }
            otherTracks.add(t);
        }
        this.sortByRegionScore(tracksWithScore, region, type, frame);
        ArrayList<String> sortedAttributes = new ArrayList<String>();
        for (Track t : tracksWithScore) {
            String att = t.getAttributeValue(linkingAtt);
            if (att == null) continue;
            sortedAttributes.add(att);
        }
        this.sortByAttributeOrder(otherTracks, sortedAttributes, linkingAtt);
        this.tracks.clear();
        this.tracks.addAll(tracksWithScore);
        this.tracks.addAll(otherTracks);
        if (unsortableTracks.size() > 0) {
            for (Track t : unsortableTracks) {
                int index = (Integer)trackIndeces.get(t);
                this.tracks.add(index, t);
            }
        }
    }

    public void sortByRegionScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        this.sortByRegionScore(this.tracks, region, type, frame);
    }

    private void sortByRegionScore(List<Track> tracks, RegionOfInterest region, final RegionScoreType type, final ReferenceFrame frame) {
        if (tracks != null && region != null && !tracks.isEmpty()) {
            final int zoom = Math.max(0, frame.getZoom());
            final String chr = region.getChr();
            final int start = region.getStart();
            final int end = region.getEnd();
            Comparator<Track> c2 = new Comparator<Track>(){

                @Override
                public int compare(Track t1, Track t2) {
                    if (t1 == null && t2 == null) {
                        return 0;
                    }
                    if (t1 == null) {
                        return 1;
                    }
                    if (t2 == null) {
                        return -1;
                    }
                    float s1 = t1.getRegionScore(chr, start, end, zoom, type, frame);
                    float s2 = t2.getRegionScore(chr, start, end, zoom, type, frame);
                    if (s2 > s1) {
                        return 1;
                    }
                    if (s1 < s2) {
                        return -1;
                    }
                    return 0;
                }
            };
            Collections.sort(tracks, c2);
        }
    }

    private void sortByAttributeOrder(List<Track> tracks, List<String> sortedAttributes, final String attributeId) {
        if (tracks != null && sortedAttributes != null && !tracks.isEmpty()) {
            final HashMap<String, Integer> rankMap = new HashMap<String, Integer>(sortedAttributes.size() * 2);
            for (int i2 = sortedAttributes.size() - 1; i2 >= 0; --i2) {
                rankMap.put(sortedAttributes.get(i2), i2);
            }
            Comparator<Track> c2 = new Comparator<Track>(){

                @Override
                public int compare(Track t1, Track t2) {
                    Integer r2;
                    String a1 = t1.getAttributeValue(attributeId);
                    String a2 = t2.getAttributeValue(attributeId);
                    Integer r1 = a1 == null ? null : (Integer)rankMap.get(a1);
                    Integer n2 = r2 = a2 == null ? null : (Integer)rankMap.get(a2);
                    if (r1 == null && r2 == null) {
                        return 0;
                    }
                    if (r1 == null) {
                        return 1;
                    }
                    if (r2 == null) {
                        return -1;
                    }
                    return r1 - r2;
                }
            };
            Collections.sort(tracks, c2);
        }
    }

    public void sortByList(List<String> trackIds) {
        final HashMap<String, Integer> trackPositions = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < trackIds.size(); ++i2) {
            trackPositions.put(trackIds.get(i2), i2);
        }
        Comparator<Track> c2 = new Comparator<Track>(){

            @Override
            public int compare(Track t1, Track t2) {
                String id1 = t1.getId();
                int p1 = trackPositions.containsKey(id1) ? (Integer)trackPositions.get(id1) : Integer.MAX_VALUE;
                String id2 = t2.getId();
                int p2 = trackPositions.containsKey(id2) ? (Integer)trackPositions.get(id2) : Integer.MAX_VALUE;
                return p1 - p2;
            }
        };
        Collections.sort(this.tracks, c2);
    }

    public void removeTracks(Collection<Track> tracksToRemove) {
        this.tracks.removeAll(tracksToRemove);
    }

    public boolean moveSelectedTracksTo(Collection<Track> selectedTracks, Track targetTrack, boolean before) {
        int index;
        int n2 = index = targetTrack == null ? this.tracks.size() : this.tracks.indexOf(targetTrack);
        if (index < 0) {
            return false;
        }
        if (!before) {
            ++index;
        }
        ArrayList<Track> beforeList = new ArrayList<Track>(this.tracks.subList(0, index));
        ArrayList<Track> afterList = new ArrayList<Track>(this.tracks.subList(index, this.tracks.size()));
        beforeList.removeAll(selectedTracks);
        afterList.removeAll(selectedTracks);
        this.tracks.clear();
        this.tracks.addAll(beforeList);
        this.tracks.addAll(selectedTracks);
        this.tracks.addAll(afterList);
        return true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        TrackManager tm = IGV.getInstance().getTrackManager();
        tm.clearSelections();
        tm.setTrackSelections(new HashSet<Track>(this.tracks));
    }
}

