/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.lists.GeneList;
import org.broad.igv.lists.GeneListManager;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.session.Session;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterElement;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.FilterElement;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SessionReader {
    private static Logger log = Logger.getLogger(SessionReader.class);
    private static String INPUT_FILE_KEY = "INPUT_FILE_KEY";
    private Collection<ResourceLocator> dataFiles;
    private Collection<ResourceLocator> missingDataFiles;
    private static Map<String, String> attributeSynonymMap = new HashMap<String, String>();
    private boolean panelElementPresent = false;
    private int version;
    private IGV igv;
    Map<String, List<Track>> trackDictionary = new LinkedHashMap<String, List<Track>>();
    private Track geneTrack = null;
    private Track seqTrack = null;
    private int panelCounter = 1;

    public SessionReader(IGV igv) {
        this.igv = igv;
    }

    public void loadSession(InputStream inputStream, Session session, String sessionName) throws RuntimeException {
        log.debug("Load session");
        Document document = null;
        try {
            document = this.createDOMDocumentFromXmlFile(inputStream);
        }
        catch (Exception e2) {
            log.error("Session Management Error", e2);
            throw new RuntimeException(e2);
        }
        HashMap<String, String> additionalInformation = new HashMap<String, String>();
        additionalInformation.put(INPUT_FILE_KEY, sessionName);
        NodeList nodes = document.getElementsByTagName(SessionElement.GLOBAL.getText());
        if (nodes == null || nodes.getLength() == 0) {
            nodes = document.getElementsByTagName(SessionElement.SESSION.getText());
        }
        this.processRootNode(session, nodes.item(0), additionalInformation);
        this.addLeftoverTracks(this.trackDictionary.values());
        if (session.getGroupTracksBy() != null && session.getGroupTracksBy().length() > 0) {
            IGV.getInstance().getTrackManager().setGroupByAttribute(session.getGroupTracksBy());
        }
        if (session.isRemoveEmptyTracks()) {
            IGV.getInstance().getMainPanel().removeEmptyDataPanels();
        }
        IGV.getInstance().getTrackManager().resetOverlayTracks();
    }

    private void processRootNode(Session session, Node node, HashMap additionalInformation) {
        if (node == null || session == null) {
            MessageUtils.showMessage("Invalid session file: root node not found");
            return;
        }
        String nodeName = node.getNodeName();
        if (!nodeName.equalsIgnoreCase(SessionElement.GLOBAL.getText()) && !nodeName.equalsIgnoreCase(SessionElement.SESSION.getText())) {
            MessageUtils.showMessage("Session files must begin with a \"Global\" or \"Session\" element.  Found: " + nodeName);
        }
        this.process(session, node, additionalInformation);
        Element element = (Element)node;
        IGV.getInstance().selectGenomeFromList(this.getAttribute(element, SessionAttribute.GENOME.getText()));
        session.setLocus(this.getAttribute(element, SessionAttribute.LOCUS.getText()));
        session.setGroupTracksBy(this.getAttribute(element, SessionAttribute.GROUP_TRACKS_BY.getText()));
        String removeEmptyTracks = this.getAttribute(element, "removeEmptyTracks");
        if (removeEmptyTracks != null) {
            try {
                Boolean b2 = Boolean.parseBoolean(removeEmptyTracks);
                session.setRemoveEmptyTracks(b2);
            }
            catch (Exception e2) {
                log.error("Error parsing removeEmptyTracks string: " + removeEmptyTracks, e2);
            }
        }
        String versionString = this.getAttribute(element, SessionAttribute.VERSION.getText());
        try {
            this.version = Integer.parseInt(versionString);
        }
        catch (NumberFormatException e3) {
            log.error("Non integer version number in session file: " + versionString);
        }
        session.setVersion(this.version);
        this.geneTrack = IGV.getInstance().getTrackManager().getGeneTrack();
        if (this.geneTrack != null) {
            this.trackDictionary.put(this.geneTrack.getId(), Arrays.asList(this.geneTrack));
        }
        this.seqTrack = IGV.getInstance().getTrackManager().getSequenceTrack();
        if (this.seqTrack != null) {
            this.trackDictionary.put(this.seqTrack.getId(), Arrays.asList(this.seqTrack));
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void addLeftoverTracks(Collection<List<Track>> tmp) {
        if (this.version < 3 || !this.panelElementPresent) {
            for (List<Track> tracks : tmp) {
                for (Track track : tracks) {
                    if (track == this.geneTrack || track == this.seqTrack || track.getResourceLocator() == null) continue;
                    TrackPanel group = IGV.getInstance().getTrackManager().getPanelFor(track.getResourceLocator());
                    group.addTrack(track);
                }
            }
        }
    }

    private void process(Session session, Node element, HashMap additionalInformation) {
        if (element == null || session == null) {
            return;
        }
        String nodeName = element.getNodeName();
        if (nodeName.equalsIgnoreCase(SessionElement.FILES.getText())) {
            this.processFiles(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.DATA_FILE.getText())) {
            this.processDataFile(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.RESOURCES.getText())) {
            this.processResources(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.RESOURCE.getText())) {
            this.processResource(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.REGIONS.getText())) {
            this.processRegions(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.REGION.getText())) {
            this.processRegion(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.GENE_LIST.getText())) {
            this.processGeneList(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.FILTER.getText())) {
            this.processFilter(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.FILTER_ELEMENT.getText())) {
            this.processFilterElement(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.COLOR_SCALES.getText())) {
            this.processColorScales(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.COLOR_SCALE.getText())) {
            this.processColorScale(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.PREFERENCES.getText())) {
            this.processPreferences(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.DATA_TRACKS.getText()) || nodeName.equalsIgnoreCase(SessionElement.FEATURE_TRACKS.getText()) || nodeName.equalsIgnoreCase(SessionElement.PANEL.getText())) {
            this.processPanel(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.PANEL_LAYOUT.getText())) {
            this.processPanelLayout(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.HIDDEN_ATTRIBUTES.getText())) {
            this.processHiddenAttributes(session, (Element)element, additionalInformation);
        }
    }

    private void processFiles(Session session, Element element, HashMap additionalInformation) {
        this.dataFiles = new ArrayList<ResourceLocator>();
        this.missingDataFiles = new ArrayList<ResourceLocator>();
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
        if (this.missingDataFiles.size() > 0) {
            StringBuffer message = new StringBuffer();
            message.append("<html>The following data file(s) could not be located.<ul>");
            for (ResourceLocator file : this.missingDataFiles) {
                if (file.isLocal()) {
                    message.append("<li>");
                    message.append(file.getPath());
                    message.append("</li>");
                    continue;
                }
                message.append("<li>Server: ");
                message.append(file.getServerURL());
                message.append("  Path: ");
                message.append(file.getPath());
                message.append("</li>");
            }
            message.append("</ul>");
            message.append("Common reasons for this include: ");
            message.append("<ul><li>The session or data files have been moved.</li> ");
            message.append("<li>The data files are located on a drive that is not currently accessible.</li></ul>");
            message.append("</html>");
            MessageUtils.showMessage(message.toString());
        }
        if (this.dataFiles.size() > 0) {
            for (ResourceLocator locator : this.dataFiles) {
                List<Track> tracks = this.igv.getTrackManager().load(locator);
                for (Track track : tracks) {
                    String id = track.getId();
                    List<Track> trackList = this.trackDictionary.get(id);
                    if (trackList == null) {
                        trackList = new ArrayList<Track>();
                        this.trackDictionary.put(id, trackList);
                    }
                    trackList.add(track);
                }
            }
        }
        this.dataFiles = null;
    }

    private void processDataFile(Session session, Element element, HashMap additionalInformation) {
        ResourceLocator resourceLocator = null;
        String serverURL = this.getAttribute(element, SessionAttribute.SERVER_URL.getText());
        String filePath = this.getAttribute(element, SessionAttribute.NAME.getText());
        String resourceType = this.getAttribute(element, SessionAttribute.RESOURCE_TYPE.getText());
        if ((serverURL == null || serverURL.trim().equals("")) && !IGVHttpUtils.isURL(filePath.toLowerCase())) {
            String relPathValue = this.getAttribute(element, SessionAttribute.RELATIVE_PATH.getText());
            boolean relativePaths = relPathValue != null && relPathValue.equalsIgnoreCase("true");
            File parent = relativePaths ? new File(session.getPath()).getParentFile() : null;
            File file = new File(parent, filePath);
            resourceLocator = new ResourceLocator(file.getAbsolutePath());
        } else {
            resourceLocator = new ResourceLocator(serverURL, filePath);
        }
        if (resourceType != null) {
            resourceLocator.setType(resourceType);
        }
        if (resourceLocator.exists()) {
            this.dataFiles.add(resourceLocator);
        } else {
            this.missingDataFiles.add(resourceLocator);
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processResources(Session session, Element element, HashMap additionalInformation) {
        this.processFiles(session, element, additionalInformation);
    }

    private void processResource(Session session, Element element, HashMap additionalInformation) {
        String url;
        String label = this.getAttribute(element, SessionAttribute.LABEL.getText());
        String name = this.getAttribute(element, SessionAttribute.NAME.getText());
        String sampleId = this.getAttribute(element, SessionAttribute.SAMPLE_ID.getText());
        String description = this.getAttribute(element, SessionAttribute.DESCRIPTION.getText());
        String type = this.getAttribute(element, SessionAttribute.TYPE.getText());
        String coverage = this.getAttribute(element, SessionAttribute.COVERAGE.getText());
        String trackLine = this.getAttribute(element, SessionAttribute.TRACK_LINE.getText());
        String colorString = this.getAttribute(element, SessionAttribute.COLOR.getText());
        String relPathValue = this.getAttribute(element, SessionAttribute.RELATIVE_PATH.getText());
        boolean relativePaths = relPathValue != null && relPathValue.equalsIgnoreCase("true");
        String serverURL = this.getAttribute(element, SessionAttribute.SERVER_URL.getText());
        String path = this.getAttribute(element, SessionAttribute.PATH.getText());
        ResourceLocator resourceLocator = new ResourceLocator(serverURL, path);
        if (relativePaths) {
            if (FileUtils.isRemote(session.getPath())) {
                int idx = session.getPath().lastIndexOf("/");
                String basePath = session.getPath().substring(0, idx);
                String resPath = basePath + "/" + path;
                resourceLocator = new ResourceLocator(serverURL, resPath);
            } else {
                File parent = relativePaths ? new File(session.getPath()).getParentFile() : null;
                File file = new File(parent, path);
                resourceLocator = new ResourceLocator(serverURL, file.getAbsolutePath());
            }
        }
        if ((url = this.getAttribute(element, SessionAttribute.URL.getText())) == null) {
            url = this.getAttribute(element, SessionAttribute.FEATURE_URL.getText());
        }
        resourceLocator.setUrl(url);
        String infolink = this.getAttribute(element, SessionAttribute.HYPERLINK.getText());
        if (infolink == null) {
            infolink = this.getAttribute(element, SessionAttribute.INFOLINK.getText());
        }
        resourceLocator.setInfolink(infolink);
        if (name != null) {
            resourceLocator.setName(name);
        } else {
            resourceLocator.setName(label);
        }
        resourceLocator.setSampleId(sampleId);
        resourceLocator.setDescription(description);
        if (type != null && !type.equals("local")) {
            resourceLocator.setType(type);
        }
        resourceLocator.setCoverage(coverage);
        resourceLocator.setTrackLine(trackLine);
        if (colorString != null) {
            try {
                Color c2 = ColorUtilities.stringToColor(colorString);
                resourceLocator.setColor(c2);
            }
            catch (Exception e2) {
                log.error("Error setting color: ", e2);
            }
        }
        if (resourceLocator.exists()) {
            this.dataFiles.add(resourceLocator);
        } else {
            this.missingDataFiles.add(resourceLocator);
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processRegions(Session session, Element element, HashMap additionalInformation) {
        session.clearRegionsOfInterest();
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processRegion(Session session, Element element, HashMap additionalInformation) {
        String chromosome = this.getAttribute(element, SessionAttribute.CHROMOSOME.getText());
        String start = this.getAttribute(element, SessionAttribute.START_INDEX.getText());
        String end = this.getAttribute(element, SessionAttribute.END_INDEX.getText());
        String description = this.getAttribute(element, SessionAttribute.DESCRIPTION.getText());
        RegionOfInterest region = new RegionOfInterest(chromosome, new Integer(start), new Integer(end), description);
        IGV.getInstance().addRegionOfInterest(region);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processHiddenAttributes(Session session, Element element, HashMap additionalInformation) {
        NodeList elements = element.getChildNodes();
        if (elements.getLength() > 0) {
            HashSet<String> attributes = new HashSet<String>();
            for (int i2 = 0; i2 < elements.getLength(); ++i2) {
                Node childNode = elements.item(i2);
                if (!childNode.getNodeName().equals(SessionElement.ATTRIBUTE.getText())) continue;
                attributes.add(((Element)childNode).getAttribute(SessionAttribute.NAME.getText()));
            }
            session.setHiddenAttributes(attributes);
        }
    }

    private void processGeneList(Session session, Element element, HashMap additionalInformation) {
        String name = this.getAttribute(element, SessionAttribute.NAME.getText());
        String txt = element.getTextContent();
        String[] genes = txt.trim().split("\\s+");
        GeneList gl = new GeneList(name, Arrays.asList(genes));
        GeneListManager.getInstance().addGeneList(gl);
        session.setCurrentGeneList(gl);
        this.processFrames(element);
    }

    private void processFrames(Element element) {
        NodeList elements = element.getChildNodes();
        if (elements.getLength() > 0) {
            HashMap<String, ReferenceFrame> frames = new HashMap<String, ReferenceFrame>();
            for (ReferenceFrame f2 : FrameManager.getFrames()) {
                frames.put(f2.getName(), f2);
            }
            ArrayList<ReferenceFrame> reorderedFrames = new ArrayList<ReferenceFrame>();
            for (int i2 = 0; i2 < elements.getLength(); ++i2) {
                String frameName;
                ReferenceFrame f3;
                Node childNode = elements.item(i2);
                if (!childNode.getNodeName().equalsIgnoreCase(SessionElement.FRAME.getText()) || (f3 = (ReferenceFrame)frames.get(frameName = this.getAttribute((Element)childNode, SessionAttribute.NAME.getText()))) == null) continue;
                reorderedFrames.add(f3);
                try {
                    String chr = this.getAttribute((Element)childNode, SessionAttribute.CHR.getText());
                    int start = (int)Double.parseDouble(this.getAttribute((Element)childNode, SessionAttribute.START.getText()));
                    int end = (int)Double.parseDouble(this.getAttribute((Element)childNode, SessionAttribute.END.getText()));
                    f3.setInterval(chr, start, end);
                    continue;
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
            if (reorderedFrames.size() > 0) {
                FrameManager.setFrames(reorderedFrames);
            }
        }
        IGV.getInstance().resetFrames();
    }

    private void processFilter(Session session, Element element, HashMap additionalInformation) {
        String match = this.getAttribute(element, SessionAttribute.FILTER_MATCH.getText());
        String showAllTracks = this.getAttribute(element, SessionAttribute.FILTER_SHOW_ALL_TRACKS.getText());
        String filterName = this.getAttribute(element, SessionAttribute.NAME.getText());
        TrackFilter filter = new TrackFilter(filterName, null);
        additionalInformation.put(SessionElement.FILTER, filter);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
        session.setFilter(filter);
        if ("all".equalsIgnoreCase(match)) {
            IGV.getInstance().setFilterMatchAll(true);
        } else if ("any".equalsIgnoreCase(match)) {
            IGV.getInstance().setFilterMatchAll(false);
        }
        if ("true".equalsIgnoreCase(showAllTracks)) {
            IGV.getInstance().setFilterShowAllTracks(true);
        } else {
            IGV.getInstance().setFilterShowAllTracks(false);
        }
    }

    private void processFilterElement(Session session, Element element, HashMap additionalInformation) {
        TrackFilter filter = (TrackFilter)additionalInformation.get((Object)SessionElement.FILTER);
        String item = this.getAttribute(element, SessionAttribute.ITEM.getText());
        String operator = this.getAttribute(element, SessionAttribute.OPERATOR.getText());
        String value = this.getAttribute(element, SessionAttribute.VALUE.getText());
        String booleanOperator = this.getAttribute(element, SessionAttribute.BOOLEAN_OPERATOR.getText());
        TrackFilterElement trackFilterElement = new TrackFilterElement(filter, item, FilterElement.Operator.findEnum(operator), value, FilterElement.BooleanOperator.findEnum(booleanOperator));
        filter.add(trackFilterElement);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processPanel(Session session, Element element, HashMap additionalInformation) {
        this.panelElementPresent = true;
        String panelName = element.getAttribute("name");
        if (panelName == null) {
            panelName = "Panel" + this.panelCounter++;
        }
        ArrayList<Track> panelTracks = new ArrayList<Track>();
        NodeList elements = element.getChildNodes();
        for (int i2 = 0; i2 < elements.getLength(); ++i2) {
            Node childNode = elements.item(i2);
            if (childNode.getNodeName().equalsIgnoreCase(SessionElement.DATA_TRACK.getText()) || childNode.getNodeName().equalsIgnoreCase(SessionElement.TRACK.getText())) {
                List<Track> tracks = this.processTrack(session, (Element)childNode, additionalInformation);
                if (tracks == null) continue;
                panelTracks.addAll(tracks);
                continue;
            }
            this.process(session, childNode, additionalInformation);
        }
        TrackPanel panel = IGV.getInstance().getDataPanel(panelName);
        panel.addTracks(panelTracks);
    }

    private void processPanelLayout(Session session, Element element, HashMap additionalInformation) {
        String nodeName;
        String panelName = nodeName = element.getNodeName();
        NamedNodeMap tNodeMap = element.getAttributes();
        for (int i2 = 0; i2 < tNodeMap.getLength(); ++i2) {
            Node node = tNodeMap.item(i2);
            String name = node.getNodeName();
            if (!name.equals("dividerFractions")) continue;
            String value = node.getNodeValue();
            String[] tokens = value.split(",");
            double[] divs = new double[tokens.length];
            try {
                for (int j2 = 0; j2 < tokens.length; ++j2) {
                    divs[j2] = Double.parseDouble(tokens[j2]);
                }
                session.setDividerFractions(divs);
                continue;
            }
            catch (NumberFormatException e2) {
                log.error("Error parsing divider locations", e2);
            }
        }
    }

    private List<Track> processTrack(Session session, Element element, HashMap additionalInformation) {
        List<Track> matchedTracks;
        String id = this.getAttribute(element, SessionAttribute.ID.getText());
        HashMap<String, String> tAttributes = new HashMap<String, String>();
        HashMap<String, String> drAttributes = null;
        NamedNodeMap tNodeMap = element.getAttributes();
        for (int i2 = 0; i2 < tNodeMap.getLength(); ++i2) {
            Node node = tNodeMap.item(i2);
            String value = node.getNodeValue();
            if (value == null || value.length() <= 0) continue;
            tAttributes.put(node.getNodeName(), value);
        }
        if (element.hasChildNodes()) {
            drAttributes = new HashMap<String, String>();
            Node childNode = element.getFirstChild();
            Node sibNode = childNode.getNextSibling();
            String sibName = sibNode.getNodeName();
            if (sibName.equals(SessionElement.DATA_RANGE.getText())) {
                NamedNodeMap drNodeMap = sibNode.getAttributes();
                for (int i3 = 0; i3 < drNodeMap.getLength(); ++i3) {
                    Node node = drNodeMap.item(i3);
                    String value = node.getNodeValue();
                    if (value == null || value.length() <= 0) continue;
                    drAttributes.put(node.getNodeName(), value);
                }
            }
        }
        if ((matchedTracks = this.trackDictionary.get(id)) == null) {
            log.info("Warning.  No tracks were found with id: " + id + " in session file");
        } else {
            for (Track track : matchedTracks) {
                if (this.version >= 4 && track == this.geneTrack || track == this.seqTrack) {
                    IGV.getInstance().getTrackManager().removeTracks(Arrays.asList(track));
                }
                track.restorePersistentState(tAttributes);
                if (drAttributes == null) continue;
                DataRange dr = track.getDataRange();
                dr.restorePersistentState(drAttributes);
                track.setDataRange(dr);
            }
            this.trackDictionary.remove(id);
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
        return matchedTracks;
    }

    private void processColorScales(Session session, Element element, HashMap additionalInformation) {
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processColorScale(Session session, Element element, HashMap additionalInformation) {
        String trackType = this.getAttribute(element, SessionAttribute.TYPE.getText());
        String value = this.getAttribute(element, SessionAttribute.VALUE.getText());
        this.setColorScaleSet(session, trackType, value);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processPreferences(Session session, Element element, HashMap additionalInformation) {
        NodeList elements = element.getChildNodes();
        for (int i2 = 0; i2 < elements.getLength(); ++i2) {
            Node child = elements.item(i2);
            if (!child.getNodeName().equalsIgnoreCase(SessionElement.PROPERTY.getText())) continue;
            Element childNode = (Element)child;
            String name = this.getAttribute(childNode, SessionAttribute.NAME.getText());
            String value = this.getAttribute(childNode, SessionAttribute.VALUE.getText());
            session.setPreference(name, value);
        }
    }

    private void process(Session session, NodeList elements, HashMap additionalInformation) {
        for (int i2 = 0; i2 < elements.getLength(); ++i2) {
            Node childNode = elements.item(i2);
            this.process(session, childNode, additionalInformation);
        }
    }

    private Document createDOMDocumentFromXmlFile(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xmlDocument = documentBuilder.parse(inputStream);
        return xmlDocument;
    }

    public void setColorScaleSet(Session session, String type, String value) {
        if (type == null | value == null) {
            return;
        }
        TrackType trackType = TrackType.OTHER;
        if (TrackType.ALLELE_SPECIFIC_COPY_NUMBER.name().equalsIgnoreCase(type)) {
            trackType = TrackType.ALLELE_SPECIFIC_COPY_NUMBER;
        } else if (TrackType.CHIP.name().equalsIgnoreCase(type)) {
            trackType = TrackType.CHIP;
        } else if (TrackType.COPY_NUMBER.name().equalsIgnoreCase(type)) {
            trackType = TrackType.COPY_NUMBER;
        } else if (TrackType.DNA_METHYLATION.name().equalsIgnoreCase(type)) {
            trackType = TrackType.DNA_METHYLATION;
        } else if (TrackType.OTHER.name().equalsIgnoreCase(type)) {
            trackType = TrackType.OTHER;
        } else if (TrackType.GENE_EXPRESSION.name().equalsIgnoreCase(type)) {
            trackType = TrackType.GENE_EXPRESSION;
        } else if (TrackType.LOH.name().equalsIgnoreCase(type)) {
            trackType = TrackType.LOH;
        } else if (TrackType.MUTATION.name().equalsIgnoreCase(type)) {
            trackType = TrackType.MUTATION;
        } else if (TrackType.PHASTCON.name().equalsIgnoreCase(type)) {
            trackType = TrackType.PHASTCON;
        } else if (TrackType.TILING_ARRAY.name().equalsIgnoreCase(type)) {
            trackType = TrackType.TILING_ARRAY;
        }
        ColorScale colorScale = ColorScaleFactory.getScaleFromString(value);
        if (colorScale instanceof ContinuousColorScale) {
            session.setColorScale(trackType, (ContinuousColorScale)colorScale);
        }
    }

    private String getAttribute(Element element, String key) {
        String value = element.getAttribute(key);
        if (value != null && value.trim().equals("")) {
            value = null;
        }
        return value;
    }

    static {
        attributeSynonymMap.put("DATA FILE", "DATA SET");
        attributeSynonymMap.put("TRACK NAME", "NAME");
    }

    public static enum SessionAttribute {
        BOOLEAN_OPERATOR("booleanOperator"),
        COLOR("color"),
        ALT_COLOR("altColor"),
        COLOR_MODE("colorMode"),
        CHROMOSOME("chromosome"),
        END_INDEX("end"),
        EXPAND("expand"),
        SQUISH("squish"),
        DISPLAY_MODE("displayMode"),
        FILTER_MATCH("match"),
        FILTER_SHOW_ALL_TRACKS("showTracks"),
        GENOME("genome"),
        GROUP_TRACKS_BY("groupTracksBy"),
        HEIGHT("height"),
        ID("id"),
        ITEM("item"),
        LOCUS("locus"),
        NAME("name"),
        SAMPLE_ID("sampleID"),
        RESOURCE_TYPE("resourceType"),
        OPERATOR("operator"),
        RELATIVE_PATH("relativePath"),
        RENDERER("renderer"),
        SCALE("scale"),
        START_INDEX("start"),
        VALUE("value"),
        VERSION("version"),
        VISIBLE("visible"),
        WINDOW_FUNCTION("windowFunction"),
        RENDER_NAME("renderName"),
        GENOTYPE_HEIGHT("genotypeHeight"),
        VARIANT_HEIGHT("variantHeight"),
        PREVIOUS_HEIGHT("previousHeight"),
        FEATURE_WINDOW("featureVisibilityWindow"),
        DISPLAY_NAME("displayName"),
        COLOR_SCALE("colorScale"),
        PATH("path"),
        LABEL("label"),
        SERVER_URL("serverURL"),
        HYPERLINK("hyperlink"),
        INFOLINK("infolink"),
        URL("url"),
        FEATURE_URL("featureURL"),
        DESCRIPTION("description"),
        TYPE("type"),
        COVERAGE("coverage"),
        TRACK_LINE("trackLine"),
        CHR("chr"),
        START("start"),
        END("end");

        private String name;

        private SessionAttribute(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }

        public static SessionAttribute findEnum(String value) {
            if (value == null) {
                return null;
            }
            return SessionAttribute.valueOf(value);
        }
    }

    public static enum SessionElement {
        PANEL("Panel"),
        PANEL_LAYOUT("PanelLayout"),
        TRACK("Track"),
        COLOR_SCALE("ColorScale"),
        COLOR_SCALES("ColorScales"),
        DATA_TRACK("DataTrack"),
        DATA_TRACKS("DataTracks"),
        FEATURE_TRACKS("FeatureTracks"),
        DATA_FILE("DataFile"),
        RESOURCE("Resource"),
        RESOURCES("Resources"),
        FILES("Files"),
        FILTER_ELEMENT("FilterElement"),
        FILTER("Filter"),
        SESSION("Session"),
        GLOBAL("Global"),
        REGION("Region"),
        REGIONS("Regions"),
        DATA_RANGE("DataRange"),
        PREFERENCES("Preferences"),
        PROPERTY("Property"),
        GENE_LIST("GeneList"),
        HIDDEN_ATTRIBUTES("HiddenAttributes"),
        ATTRIBUTE("Attribute"),
        FRAME("Frame");

        private String name;

        private SessionElement(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }

        public static SessionElement findEnum(String value) {
            if (value == null) {
                return null;
            }
            return SessionElement.valueOf(value);
        }
    }
}

