/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;

public class MergedAlignmentReader
implements AlignmentQueryReader {
    Collection<AlignmentQueryReader> readers;

    public MergedAlignmentReader(Collection<AlignmentQueryReader> readers) {
        this.readers = readers;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return new MergedFileIterator();
    }

    @Override
    public CloseableIterator<Alignment> query(String chr, int start, int end, boolean contained) throws IOException {
        return new MergedFileIterator(chr, start, end, contained);
    }

    @Override
    public void close() throws IOException {
        for (AlignmentQueryReader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public SAMFileHeader getHeader() throws IOException {
        return this.readers.iterator().next().getHeader();
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.readers.iterator().next().getSequenceNames();
    }

    @Override
    public boolean hasIndex() {
        return this.readers.iterator().next().hasIndex();
    }

    public class MergedFileIterator
    implements CloseableIterator<Alignment> {
        PriorityQueue<RecordIterWrapper> iterators;

        public MergedFileIterator() {
            this.iterators = new PriorityQueue(MergedAlignmentReader.this.readers.size());
            for (AlignmentQueryReader reader : MergedAlignmentReader.this.readers) {
                CloseableIterator<Alignment> iter = reader.iterator();
                if (!iter.hasNext()) continue;
                this.iterators.add(new RecordIterWrapper(iter));
            }
        }

        public MergedFileIterator(String chr, int start, int end, boolean contained) throws IOException {
            this.iterators = new PriorityQueue<RecordIterWrapper>(MergedAlignmentReader.this.readers.size(), new FooComparator());
            for (AlignmentQueryReader reader : MergedAlignmentReader.this.readers) {
                CloseableIterator<Alignment> iter = reader.query(chr, start, end, contained);
                if (!iter.hasNext()) continue;
                this.iterators.add(new RecordIterWrapper(iter));
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterators.size() > 0;
        }

        @Override
        public Alignment next() {
            RecordIterWrapper wrapper = this.iterators.poll();
            Alignment next = wrapper.advance();
            if (wrapper.hasNext()) {
                this.iterators.add(wrapper);
            } else {
                wrapper.close();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not implemented");
        }

        @Override
        public void close() {
            for (RecordIterWrapper wrapper : this.iterators) {
                wrapper.close();
            }
        }

        class FooComparator
        implements Comparator<RecordIterWrapper> {
            FooComparator() {
            }

            @Override
            public int compare(RecordIterWrapper wrapper, RecordIterWrapper foo1) {
                return wrapper.nextRecord.getAlignmentStart() - foo1.nextRecord.getAlignmentStart();
            }
        }

        class RecordIterWrapper {
            Alignment nextRecord;
            CloseableIterator<Alignment> iterator;

            RecordIterWrapper(CloseableIterator<Alignment> iter) {
                this.iterator = iter;
                this.nextRecord = this.iterator.hasNext() ? (Alignment)this.iterator.next() : null;
            }

            Alignment advance() {
                Alignment tmp = this.nextRecord;
                this.nextRecord = this.iterator.hasNext() ? (Alignment)this.iterator.next() : null;
                return tmp;
            }

            boolean hasNext() {
                return this.nextRecord != null;
            }

            void close() {
                if (this.iterator != null) {
                    this.iterator.close();
                    this.iterator = null;
                }
            }
        }
    }
}

