/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.h5;

import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;

public class TestH5String {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        int fid = -1;
        int did = -1;
        int tid = -1;
        int sid = -1;
        long[] dims = new long[]{2L};
        int rank = 1;
        int strLength = 14;
        String[] strIn = new String[]{"test string 1 ", "test string 2 "};
        String[] strOut = null;
        byte[] byteBuff = null;
        try {
            fid = H5.H5Fcreate("testH5string.h5", HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            tid = H5.H5Tcopy(HDF5Constants.H5T_C_S1);
            H5.H5Tset_size(tid, strLength);
            sid = H5.H5Screate_simple(1, dims, null);
            did = H5.H5Dcreate(fid, "/string", tid, sid, HDF5Constants.H5P_DEFAULT);
            byteBuff = (strIn[0] + strIn[1]).getBytes();
            H5.H5Dwrite(did, tid, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, byteBuff);
            try {
                H5.H5Tclose(tid);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                H5.H5Sclose(sid);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                H5.H5Dclose(did);
            }
            catch (Exception ex) {
                // empty catch block
            }
            did = H5.H5Dopen(fid, "/string");
            tid = H5.H5Dget_type(did);
            sid = H5.H5Dget_space(did);
            int numberOfStrings = 1;
            for (int i2 = 0; i2 < rank; ++i2) {
                numberOfStrings *= (int)dims[i2];
            }
            int stringLength = H5.H5Tget_size(tid);
            int bufferSize = numberOfStrings * stringLength;
            byteBuff = new byte[bufferSize];
            int mspace = HDF5Constants.H5S_ALL;
            int fspace = HDF5Constants.H5S_ALL;
            int plist = HDF5Constants.H5P_DEFAULT;
            H5.H5Dread(did, tid, mspace, fspace, plist, byteBuff);
            strOut = new String[numberOfStrings];
            for (int i3 = 0; i3 < numberOfStrings; ++i3) {
                strOut[i3] = new String(byteBuff, i3 * stringLength, stringLength).trim();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        finally {
            try {
                H5.H5Tclose(tid);
            }
            catch (Exception ex) {}
            try {
                H5.H5Sclose(sid);
            }
            catch (Exception ex) {}
            try {
                H5.H5Dclose(did);
            }
            catch (Exception ex) {}
            try {
                H5.H5Fclose(fid);
            }
            catch (Exception ex) {}
        }
        if (strOut != null) {
            for (int i4 = 0; i4 < strOut.length; ++i4) {
                System.out.println((String)strOut[i4]);
            }
        }
    }
}

