/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import java.lang.reflect.Array;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class ArrayDescriptor {
    static String theType = "";
    static Class theClass = null;
    static int[] dimlen = null;
    static int[] dimstart = null;
    static int[] currentindex = null;
    static int[] bytetoindex = null;
    static int totalSize = 0;
    static Object[] objs = null;
    static char NT = (char)32;
    static int NTsize = 0;
    static int dims = 0;
    static String className;

    public ArrayDescriptor(Object object) throws HDF5Exception {
        int n2;
        Object object2;
        String string;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("ArrayDescriptor: not an array?: ");
            throw hDF5JavaException;
        }
        theClass = clazz;
        theType = string = clazz.toString();
        dims = 0;
        int n3 = 32;
        for (int i2 = 6; i2 < string.length(); ++i2) {
            n3 = string.charAt(i2);
            if (n3 != 91) continue;
            ++dims;
        }
        String string2 = string.substring(string.lastIndexOf(91) + 1);
        Class<?> clazz2 = clazz.getComponentType();
        String string3 = clazz2.toString();
        NT = (char)n3;
        if (NT == 'B') {
            NTsize = 1;
        } else if (NT == 'S') {
            NTsize = 2;
        } else if (NT == 'I' || NT == 'F') {
            NTsize = 4;
        } else if (NT == 'J' || NT == 'D') {
            NTsize = 8;
        } else if (string2.startsWith("Ljava.lang.Byte")) {
            NT = (char)76;
            className = "java.lang.Byte";
            NTsize = 1;
        } else if (string2.startsWith("Ljava.lang.Short")) {
            NT = (char)76;
            className = "java.lang.Short";
            NTsize = 2;
        } else if (string2.startsWith("Ljava.lang.Integer")) {
            NT = (char)76;
            className = "java.lang.Integer";
            NTsize = 4;
        } else if (string2.startsWith("Ljava.lang.Float")) {
            NT = (char)76;
            className = "java.lang.Float";
            NTsize = 4;
        } else if (string2.startsWith("Ljava.lang.Double")) {
            NT = (char)76;
            className = "java.lang.Double";
            NTsize = 8;
        } else if (string2.startsWith("Ljava.lang.Long")) {
            NT = (char)76;
            className = "java.lang.Long";
            NTsize = 8;
        } else {
            if (string2.startsWith("Ljava.lang.String")) {
                throw new HDF5JavaException(new String("ArrayDesciptor: Error:  String array not supported yet"));
            }
            throw new HDF5JavaException(new String("ArrayDesciptor: Error:  array is not numeric (type is " + string2 + ") ?"));
        }
        dimlen = new int[dims + 1];
        dimstart = new int[dims + 1];
        currentindex = new int[dims + 1];
        bytetoindex = new int[dims + 1];
        objs = new Object[dims + 1];
        ArrayDescriptor.objs[0] = object2 = object;
        ArrayDescriptor.dimlen[0] = 1;
        ArrayDescriptor.dimstart[0] = 0;
        ArrayDescriptor.currentindex[0] = 0;
        for (n2 = 1; n2 <= dims; ++n2) {
            ArrayDescriptor.dimlen[n2] = Array.getLength(object2);
            ArrayDescriptor.objs[n2] = object2 = Array.get(object2, 0);
            ArrayDescriptor.dimstart[n2] = 0;
            ArrayDescriptor.currentindex[n2] = 0;
        }
        ArrayDescriptor.bytetoindex[ArrayDescriptor.dims] = NTsize;
        for (n2 = dims; n2 >= 0; --n2) {
            int n4 = NTsize;
            for (int i3 = n2; i3 < dims; ++i3) {
                n4 *= dimlen[i3 + 1];
            }
            ArrayDescriptor.bytetoindex[n2] = n4;
        }
        totalSize = bytetoindex[0];
    }

    public void dumpInfo() {
        System.out.println("Type: " + theType);
        System.out.println("Class: " + theClass);
        System.out.println("NT: " + NT + " NTsize: " + NTsize);
        System.out.println("Array has " + dims + " dimensions (" + totalSize + " bytes)");
        for (int i2 = 0; i2 <= dims; ++i2) {
            Class<?> clazz = objs[i2].getClass();
            String string = clazz.toString();
            System.out.println(i2 + ":  start " + dimstart[i2] + ": len " + dimlen[i2] + " current " + currentindex[i2] + " bytetoindex " + bytetoindex[i2] + " object " + objs[i2] + " otype " + string);
        }
    }
}

