/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import java.io.Serializable;

public class ByteArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private ByteArrays() {
    }

    public static byte[] ensureCapacity(byte[] array, int length) {
        if (length > array.length) {
            byte[] t = new byte[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static byte[] ensureCapacity(byte[] array, int length, int preserve) {
        if (length > array.length) {
            byte[] t = new byte[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            byte[] t = new byte[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static byte[] trim(byte[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        byte[] t = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static byte[] setLength(byte[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ByteArrays.trim(array, length);
        }
        return ByteArrays.ensureCapacity(array, length);
    }

    public static byte[] copy(byte[] array, int offset, int length) {
        ByteArrays.ensureOffsetLength(array, offset, length);
        byte[] a2 = length == 0 ? EMPTY_ARRAY : new byte[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static byte[] copy(byte[] array) {
        return (byte[])array.clone();
    }

    public static void fill(byte[] array, byte value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static void fill(byte[] array, int from, int to, byte value) {
        ByteArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(byte[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(byte[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static void swap(byte[] x, int a2, int b2) {
        byte t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    private static void vecSwap(byte[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            ByteArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(byte[] x, int a2, int b2, int c2, ByteComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(byte[] x, int from, int to, ByteComparator comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && comp.compare(x[j2 - 1], x[j2]) > 0; --j2) {
                    ByteArrays.swap(x, j2, j2 - 1);
                }
            }
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 40) {
                int s = len / 8;
                l2 = ByteArrays.med3(x, l2, l2 + s, l2 + 2 * s, comp);
                m2 = ByteArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = ByteArrays.med3(x, n2 - 2 * s, n2 - s, n2, comp);
            }
            m2 = ByteArrays.med3(x, l2, m2, n2, comp);
        }
        byte v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ByteArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        ByteArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        ByteArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            ByteArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1) {
            ByteArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    public static void quickSort(byte[] x, ByteComparator comp) {
        ByteArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(byte[] x, int a2, int b2, int c2) {
        int bc;
        int ac;
        int ab;
        int n2 = x[a2] < x[b2] ? -1 : (ab = x[a2] == x[b2] ? 0 : 1);
        int n3 = x[a2] < x[c2] ? -1 : (ac = x[a2] == x[c2] ? 0 : 1);
        int n4 = x[b2] < x[c2] ? -1 : (bc = x[b2] == x[c2] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(byte[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && x[j2] < x[j2 - 1]; --j2) {
                    ByteArrays.swap(x, j2, j2 - 1);
                }
            }
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 40) {
                int s = len / 8;
                l2 = ByteArrays.med3(x, l2, l2 + s, l2 + 2 * s);
                m2 = ByteArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = ByteArrays.med3(x, n2 - 2 * s, n2 - s, n2);
            }
            m2 = ByteArrays.med3(x, l2, m2, n2);
        }
        byte v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (x[b2] < v ? -1 : (comparison = x[b2] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (x[c2] < v ? -1 : (comparison = x[c2] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ByteArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        ByteArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        ByteArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            ByteArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            ByteArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static void quickSort(byte[] x) {
        ByteArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(byte[] a2, int from, int to, byte[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && a2[j2] < a2[j2 - 1]; --j2) {
                    ByteArrays.swap(a2, j2, j2 - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ByteArrays.mergeSort(supp, from, mid, a2);
        ByteArrays.mergeSort(supp, mid, to, a2);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i3 = from; i3 < to; ++i3) {
            a2[i3] = q >= to || p2 < mid && supp[p2] <= supp[q] ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(byte[] a2, int from, int to) {
        ByteArrays.mergeSort(a2, from, to, (byte[])a2.clone());
    }

    public static void mergeSort(byte[] a2) {
        ByteArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(byte[] a2, int from, int to, ByteComparator comp, byte[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && comp.compare(a2[j2 - 1], a2[j2]) > 0; --j2) {
                    ByteArrays.swap(a2, j2, j2 - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ByteArrays.mergeSort(supp, from, mid, comp, a2);
        ByteArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i3 = from; i3 < to; ++i3) {
            a2[i3] = q >= to || p2 < mid && comp.compare(supp[p2], supp[q]) <= 0 ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(byte[] a2, int from, int to, ByteComparator comp) {
        ByteArrays.mergeSort(a2, from, to, comp, (byte[])a2.clone());
    }

    public static void mergeSort(byte[] a2, ByteComparator comp) {
        ByteArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(byte[] a2, int from, int to, byte key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            byte midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(byte[] a2, byte key) {
        return ByteArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(byte[] a2, int from, int to, byte key, ByteComparator c2) {
        while (from <= to) {
            int mid = from + to >>> 1;
            byte midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(byte[] a2, byte key, ByteComparator c2) {
        return ByteArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy
    implements Hash.Strategy<byte[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(byte[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(byte[] a2, byte[] b2) {
            return ByteArrays.equals(a2, b2);
        }
    }
}

