/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class TreeSetConverter
extends CollectionConverter {
    static /* synthetic */ Class class$java$util$TreeSet;

    public TreeSetConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type.equals(class$java$util$TreeSet == null ? (class$java$util$TreeSet = TreeSetConverter.class$("java.util.TreeSet")) : class$java$util$TreeSet);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TreeSet treeSet = (TreeSet)source;
        Comparator comparator = treeSet.comparator();
        if (comparator == null) {
            writer.startNode("no-comparator");
            writer.endNode();
        } else {
            writer.startNode("comparator");
            writer.addAttribute("class", this.mapper().serializedClass(comparator.getClass()));
            context.convertAnother(comparator);
            writer.endNode();
        }
        super.marshal(source, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeSet result;
        PresortedSet sortedSet;
        reader.moveDown();
        if (reader.getNodeName().equals("comparator")) {
            String comparatorClass = reader.getAttribute("class");
            Comparator comparator = (Comparator)context.convertAnother(null, this.mapper().realClass(comparatorClass));
            sortedSet = new PresortedSet(comparator);
            result = new TreeSet(comparator);
        } else if (reader.getNodeName().equals("no-comparator")) {
            sortedSet = new PresortedSet();
            result = new TreeSet();
        } else {
            throw new ConversionException("TreeSet does not contain <comparator> element");
        }
        reader.moveUp();
        super.populateCollection(reader, context, sortedSet);
        result.addAll(sortedSet);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PresortedSet
    implements SortedSet {
        private final List list = new ArrayList();
        private final Comparator comparator;

        PresortedSet() {
            this(null);
        }

        PresortedSet(Comparator comparator) {
            this.comparator = comparator;
        }

        public boolean add(Object e2) {
            return this.list.add(e2);
        }

        public boolean addAll(Collection c2) {
            return this.list.addAll(c2);
        }

        public void clear() {
            this.list.clear();
        }

        public boolean contains(Object o2) {
            return this.list.contains(o2);
        }

        public boolean containsAll(Collection c2) {
            return this.list.containsAll(c2);
        }

        public boolean equals(Object o2) {
            return ((Object)this.list).equals(o2);
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator iterator() {
            return this.list.iterator();
        }

        public boolean remove(Object o2) {
            return this.list.remove(o2);
        }

        public boolean removeAll(Collection c2) {
            return this.list.removeAll(c2);
        }

        public boolean retainAll(Collection c2) {
            return this.list.retainAll(c2);
        }

        public int size() {
            return this.list.size();
        }

        public List subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] a2) {
            return this.list.toArray(a2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Object first() {
            return this.list.isEmpty() ? null : this.list.get(0);
        }

        public SortedSet headSet(Object toElement) {
            throw new UnsupportedOperationException();
        }

        public Object last() {
            return this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            throw new UnsupportedOperationException();
        }

        public SortedSet tailSet(Object fromElement) {
            throw new UnsupportedOperationException();
        }
    }
}

