/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.track.WindowFunction;

public class TDFUtils {
    public static void main(String[] args) throws FileNotFoundException {
        TDFUtils.tdfToBedgraph("/Users/jrobinso/IGV/time_course/cebpb_0.merged.bam.tdf", "/Users/jrobinso/IGV/time_course/test.wig");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tdfToBedgraph(String tdfFile, String bedGraphFile) throws FileNotFoundException {
        TDFReader reader = null;
        PrintStream ps = null;
        try {
            reader = TDFReader.getReader(tdfFile);
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(bedGraphFile)));
            String trackLine = reader.getTrackLine();
            if (trackLine != null && trackLine.length() > 0) {
                ps.println(trackLine);
            }
            for (String dsName : reader.getDatasetNames()) {
                String[] tokens = dsName.split("/");
                String chrName = tokens[1];
                if (chrName.equals("All") || !dsName.contains("raw")) continue;
                TDFDataset ds = reader.getDataset(dsName);
                for (int i2 = 0; i2 < ds.nTiles; ++i2) {
                    TDFTile tile = ds.getTile(i2);
                    if (tile == null) continue;
                    TDFUtils.dumpTileData(reader, chrName, tile, ps);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static void dumpRootAttributes(String ibfFile) {
        TDFReader reader = TDFReader.getReader(ibfFile);
        System.out.println("Track line = " + reader.getTrackLine());
        TDFGroup group = reader.getGroup("/");
        for (Map.Entry entries : group.attributes.entrySet()) {
            System.out.println((String)entries.getKey() + " = " + (String)entries.getValue());
        }
        System.out.println(reader.getTrackLine());
    }

    public static void dumpDatasets(String ibfFile) {
        TDFReader reader = TDFReader.getReader(ibfFile);
        System.out.println("DATASETS");
        for (String dsName : reader.getDatasetNames()) {
            System.out.println(dsName);
            TDFDataset ds = reader.getDataset(dsName);
            System.out.println("Attributes");
            for (Map.Entry entry : ds.attributes.entrySet()) {
                System.out.println("\t" + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
            System.out.println();
            System.out.println("Tile Positions");
            for (int i2 = 0; i2 < ds.nTiles; ++i2) {
                System.out.print("\t" + ds.tilePositions[i2]);
            }
            System.out.println();
        }
    }

    public static void dumpAllTiles(String ibfFile) {
        TDFReader reader = TDFReader.getReader(ibfFile);
        System.out.println("DATASETS");
        for (String dsName : reader.getDatasetNames()) {
            System.out.println(dsName);
            TDFDataset ds = reader.getDataset(dsName);
            for (int i2 = 0; i2 < ds.nTiles; ++i2) {
                TDFTile tile = ds.getTile(i2);
                if (tile == null) continue;
                System.out.println("Tile: " + i2);
                TDFUtils.dumpTileData(reader, "", tile, System.out);
            }
        }
    }

    public static void dumpTile(String ibfFile, String dsName, int tileNumber) {
        TDFDataset ds;
        TDFReader reader = TDFReader.getReader(ibfFile);
        TDFTile tile = reader.readTile(ds = reader.getDataset(dsName), tileNumber);
        if (tile == null) {
            System.out.println("Null tile: " + dsName + " [" + tileNumber + "]");
        } else {
            TDFUtils.dumpTileData(reader, "", tile, System.out);
        }
    }

    private static void dumpTileData(TDFReader reader, String chrName, TDFTile tile, PrintStream ps) {
        int nTracks = reader.getTrackNames().length;
        int nBins = tile.getSize();
        if (nBins > 0) {
            for (int b2 = 0; b2 < nBins; ++b2) {
                ps.print(chrName);
                ps.print("\t" + tile.getStartPosition(b2));
                ps.print("\t" + tile.getEndPosition(b2));
                for (int t = 0; t < nTracks; ++t) {
                    ps.print("\t" + tile.getValue(t, b2));
                }
                ps.println();
            }
        }
    }

    public static void dumpRange(String ibfFile, String dsName, int startLocation, int endLocation) {
        TDFReader reader = TDFReader.getReader(ibfFile);
        TDFDataset ds = reader.getDataset(dsName);
        int tileWidth = ds.tileWidth;
        int startTile = startLocation / tileWidth;
        int endTile = endLocation / tileWidth;
        block0: for (int tileNumber = startTile; tileNumber <= endTile; ++tileNumber) {
            TDFTile tile = reader.readTile(ds, tileNumber);
            if (tile == null) {
                System.out.println("Null tile: " + dsName + " [" + tileNumber + "]");
                continue;
            }
            int nTracks = reader.getTrackNames().length;
            int nBins = tile.getSize();
            if (nBins <= 0) continue;
            for (int b2 = 0; b2 < nBins; ++b2) {
                int start = tile.getStartPosition(b2);
                int end = tile.getEndPosition(b2);
                if (start > endLocation) continue block0;
                if (end < startLocation) continue;
                System.out.print(tile.getStartPosition(b2));
                for (int t = 0; t < nTracks; ++t) {
                    System.out.print("\t" + tile.getValue(t, b2));
                }
                System.out.println();
            }
        }
    }

    public static void dumpSummary(String ibfFile) {
        String[] trackNames;
        TDFReader reader = TDFReader.getReader(ibfFile);
        System.out.println("Version: " + reader.getVersion());
        System.out.println("Window Functions");
        for (WindowFunction wf : reader.getWindowFunctions()) {
            System.out.println("\t" + wf.toString());
        }
        System.out.println("Tracks");
        for (String trackName : trackNames = reader.getTrackNames()) {
            System.out.println(trackName);
        }
        System.out.println();
        System.out.println("DATASETS");
        for (String dsName : reader.getDatasetNames()) {
            System.out.println(dsName);
            TDFDataset ds = reader.getDataset(dsName);
            System.out.println("Attributes");
            for (Map.Entry entry : ds.attributes.entrySet()) {
                System.out.println("\t" + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
            System.out.println();
            System.out.println("Tiles");
            int nTracks = trackNames.length;
            int tracksToShow = Math.min(4, nTracks);
            for (int i2 = 0; i2 < ds.nTiles; ++i2) {
                TDFTile tile = reader.readTile(ds, i2);
                if (tile == null) continue;
                System.out.print("  " + i2);
            }
            System.out.println();
            System.out.println();
        }
        System.out.println("GROUPS");
        for (String name : reader.getGroupNames()) {
            System.out.println(name);
            TDFGroup group = reader.getGroup(name);
            System.out.println("Attributes");
            for (Map.Entry entry : group.attributes.entrySet()) {
                System.out.println("\t" + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
            System.out.println();
        }
    }
}

