/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.swing.JOptionPane;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentPacker;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CachingQueryReader;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.reader.SamListReader;
import org.broad.igv.sam.reader.SamQueryReaderFactory;
import org.broad.igv.track.MultiFileWrapper;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ArrayHeapObjectSorter;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;

public class AlignmentDataManager {
    private static Logger log = Logger.getLogger(AlignmentDataManager.class);
    private static final int DEFAULT_DEPTH = 10;
    private HashMap<String, AlignmentInterval> loadedIntervalMap = new HashMap(50);
    HashMap<String, String> chrMappings = new HashMap();
    private boolean isLoading = false;
    private CachingQueryReader reader;
    private CoverageTrack coverageTrack;
    private int maxLevels;
    private boolean loadAsPairs = false;
    private static final int MAX_ROWS = 1000000;
    Map<String, PEStats> peStats;

    public AlignmentDataManager(ResourceLocator locator) throws IOException {
        PreferenceManager prefs = PreferenceManager.getInstance();
        this.maxLevels = prefs.getAsInt("SAM.MAX_LEVELS");
        if (locator.getPath().endsWith(".sam.list")) {
            MultiFileWrapper mfw = MultiFileWrapper.parse(locator);
            this.reader = new CachingQueryReader(new SamListReader(mfw.getLocators()));
        } else {
            this.reader = new CachingQueryReader(SamQueryReaderFactory.getReader(locator));
        }
        this.peStats = new HashMap<String, PEStats>();
        this.initChrMap();
    }

    private void initChrMap() {
        Set<String> seqNames;
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getChromosomeAlias(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    public CachingQueryReader getReader() {
        return this.reader;
    }

    public Map<String, PEStats> getPEStats() {
        return this.peStats;
    }

    public boolean isPairedEnd() {
        return this.reader.isPairedEnd();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public void setMaxLevels(int maxLevels) {
        this.clear();
        this.reader.clearCache();
        this.maxLevels = maxLevels;
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public AlignmentInterval getLoadedInterval(ReferenceFrame frame) {
        return this.loadedIntervalMap.get(frame.getName());
    }

    public AlignmentInterval getLoadedInterval(RenderContext context) {
        ReferenceFrame frame = context.getReferenceFrame();
        if (!this.loadedIntervalMap.containsKey(frame.getName()) && Globals.batch) {
            int start = Math.max(0, (int)context.getOrigin() - 100);
            int end = (int)context.getEndLocation() + 100;
            this.loadAlignments(context.getGenomeId(), context.getChr(), start, end, context);
        }
        return this.loadedIntervalMap.get(frame.getName());
    }

    public void sortRows(AlignmentTrack.SortOption option, ReferenceFrame referenceFrame) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
        if (loadedInterval != null) {
            loadedInterval.sortRows(option, referenceFrame);
        }
    }

    public void sortRows(AlignmentTrack.SortOption option, ReferenceFrame referenceFrame, double location) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
        if (loadedInterval != null) {
            loadedInterval.sortRows(option, location);
        }
    }

    public boolean isLoadAsPairs() {
        return this.loadAsPairs;
    }

    public void setLoadAsPairs(boolean loadAsPairs) {
        if (loadAsPairs == this.loadAsPairs) {
            return;
        }
        boolean currentPairState = this.loadAsPairs;
        this.loadAsPairs = loadAsPairs;
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            this.repackAlignments(frame, currentPairState);
        }
    }

    private void repackAlignments(ReferenceFrame referenceFrame, boolean currentPairState) {
        if (currentPairState) {
            AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
            if (loadedInterval == null) {
                return;
            }
            List<AlignmentInterval.Row> alignmentRows = loadedInterval.getAlignmentRows();
            ArrayList<Alignment> alignments = new ArrayList<Alignment>(Math.min(50000, alignmentRows.size() * 1000));
            for (AlignmentInterval.Row row : alignmentRows) {
                for (Alignment al : row.alignments) {
                    if (al instanceof PairedAlignment) {
                        PairedAlignment pair = (PairedAlignment)al;
                        alignments.add(pair.firstAlignment);
                        if (pair.secondAlignment == null) continue;
                        alignments.add(pair.secondAlignment);
                        continue;
                    }
                    alignments.add(al);
                }
            }
            ArrayHeapObjectSorter<Alignment> heapSorter = new ArrayHeapObjectSorter<Alignment>();
            heapSorter.sort(alignments, new Comparator<Alignment>(){

                @Override
                public int compare(Alignment alignment, Alignment alignment1) {
                    return alignment.getStart() - alignment1.getStart();
                }
            });
            int max = Integer.MAX_VALUE;
            List<AlignmentInterval.Row> tmp = new AlignmentPacker().packAlignments(alignments.iterator(), loadedInterval.getEnd(), this.loadAsPairs, null, 1000000);
            loadedInterval.setAlignmentRows(tmp);
        } else {
            this.repackAlignments(referenceFrame);
        }
    }

    public void repackAlignments(ReferenceFrame referenceFrame) {
        this.repackAlignments(referenceFrame, null);
    }

    public void repackAlignments(ReferenceFrame referenceFrame, AlignmentTrack.SortOption option) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
        if (loadedInterval == null) {
            return;
        }
        RowIterator iter = new RowIterator(referenceFrame);
        int max = Integer.MAX_VALUE;
        List<AlignmentInterval.Row> alignmentRows = new AlignmentPacker().packAlignments(iter, loadedInterval.getEnd(), this.loadAsPairs, option, 1000000);
        loadedInterval.setAlignmentRows(alignmentRows);
    }

    public synchronized List<AlignmentInterval.Row> getAlignmentRows(RenderContext context) {
        String genomeId = context.getGenomeId();
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(context.getReferenceFrame().getName());
        if (loadedInterval == null || !loadedInterval.contains(genomeId, chr, start, end)) {
            log.debug("Loading alignments: " + chr + ":" + start + "-" + end);
            this.loadAlignments(genomeId, chr, start, end, context);
        }
        if (loadedInterval != null && loadedInterval.overlaps(genomeId, chr, start, end)) {
            return loadedInterval.getAlignmentRows();
        }
        return null;
    }

    public void clear() {
        this.reader.clearCache();
        this.loadedIntervalMap.clear();
    }

    public void loadAlignments(final String genomeId, final String chr, final int start, final int end, final RenderContext context) {
        if (this.isLoading || chr.equals("All")) {
            return;
        }
        log.debug("Load alignments.  isLoading=" + this.isLoading);
        this.isLoading = true;
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public String getName() {
                return "loadAlignments";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int expandLength = AlignmentDataManager.this.reader.getTileSize(chr) / 2;
                int intervalStart = Math.max(0, start - expandLength);
                int intervalEnd = end + expandLength;
                CloseableIterator<Alignment> iter = null;
                try {
                    String sequence = AlignmentDataManager.this.chrMappings.containsKey(chr) ? AlignmentDataManager.this.chrMappings.get(chr) : chr;
                    ArrayList<AlignmentCounts> counts = new ArrayList<AlignmentCounts>();
                    iter = AlignmentDataManager.this.reader.query(sequence, intervalStart, intervalEnd, counts, AlignmentDataManager.this.maxLevels, AlignmentDataManager.this.peStats);
                    AlignmentPacker alignmentPacker = new AlignmentPacker();
                    List<AlignmentInterval.Row> alignmentRows = alignmentPacker.packAlignments(iter, intervalEnd, AlignmentDataManager.this.loadAsPairs, null, AlignmentDataManager.this.maxLevels);
                    AlignmentInterval loadedInterval = new AlignmentInterval(genomeId, chr, intervalStart, intervalEnd, alignmentRows, counts);
                    AlignmentDataManager.this.loadedIntervalMap.put(context.getReferenceFrame().getName(), loadedInterval);
                    if (AlignmentDataManager.this.coverageTrack != null) {
                        AlignmentDataManager.this.coverageTrack.rescale(context.getReferenceFrame());
                    }
                    if (context.getPanel() != null) {
                        context.getPanel().repaint();
                    }
                    IGV.getInstance().layoutMainPanel();
                }
                catch (Exception exception) {
                    log.error("Error loading alignments", exception);
                    JOptionPane.showMessageDialog(IGV.getMainFrame(), "Error reading file: " + exception.getMessage());
                }
                finally {
                    AlignmentDataManager.this.isLoading = false;
                    if (iter != null) {
                        iter.close();
                    }
                }
            }
        };
        LongRunningTask.submit(runnable);
    }

    private boolean isMitochondria(String chr) {
        return chr.equals("M") || chr.equals("chrM") || chr.equals("MT") || chr.equals("chrMT");
    }

    public List<AlignmentInterval.Row> getAlignmentRows(ReferenceFrame referenceFrame) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
        return loadedInterval == null ? null : loadedInterval.getAlignmentRows();
    }

    public int getNLevels() {
        int nLevels = 0;
        for (AlignmentInterval loadedInterval : this.loadedIntervalMap.values()) {
            nLevels = Math.max(nLevels, loadedInterval.getAlignmentRows().size());
        }
        return nLevels;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error("Error closing AlignmentQueryReader. ", ex);
            }
        }
    }

    public Collection<AlignmentInterval> getLoadedIntervals() {
        return this.loadedIntervalMap.values();
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void updatePEStats(AlignmentTrack.RenderOptions renderOptions) {
        if (this.peStats != null) {
            for (PEStats stats : this.peStats.values()) {
                stats.compute(renderOptions.getMinInsertSizePercentile(), renderOptions.getMaxInsertSizePercentile());
            }
        }
    }

    class RowIterator
    implements CloseableIterator<Alignment> {
        PriorityQueue<AlignmentInterval.Row> rows;
        Alignment nextAlignment;

        RowIterator(ReferenceFrame referenceFrame) {
            this.rows = new PriorityQueue<AlignmentInterval.Row>(5, new Comparator<AlignmentInterval.Row>(){

                @Override
                public int compare(AlignmentInterval.Row o1, AlignmentInterval.Row o2) {
                    return o1.getNextStartPos() - o2.getNextStartPos();
                }
            });
            for (AlignmentInterval.Row r : AlignmentDataManager.this.getAlignmentRows(referenceFrame)) {
                r.resetIdx();
                this.rows.add(r);
            }
            this.advance();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public Alignment next() {
            Alignment tmp = this.nextAlignment;
            if (tmp != null) {
                this.advance();
            }
            return tmp;
        }

        private void advance() {
            this.nextAlignment = null;
            AlignmentInterval.Row nextRow = null;
            block0: while (this.nextAlignment == null && !this.rows.isEmpty()) {
                while ((nextRow = this.rows.poll()) != null) {
                    if (!nextRow.hasNext()) continue;
                    this.nextAlignment = nextRow.nextAlignment();
                    continue block0;
                }
            }
            if (nextRow != null && this.nextAlignment != null) {
                this.rows.add(nextRow);
            }
        }

        @Override
        public void remove() {
        }
    }
}

