/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private ObjectArrays() {
    }

    private static <K> K[] newArray(K[] prototype, int length) {
        Class<?> componentType = prototype.getClass().getComponentType();
        if (length == 0 && componentType == Object.class) {
            return EMPTY_ARRAY;
        }
        return (Object[])Array.newInstance(prototype.getClass().getComponentType(), length);
    }

    public static <K> K[] ensureCapacity(K[] array, int length) {
        if (length > array.length) {
            K[] t = ObjectArrays.newArray(array, length);
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static <K> K[] ensureCapacity(K[] array, int length, int preserve) {
        if (length > array.length) {
            K[] t = ObjectArrays.newArray(array, length);
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static <K> K[] grow(K[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            K[] t = ObjectArrays.newArray(array, newLength);
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static <K> K[] grow(K[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            K[] t = ObjectArrays.newArray(array, newLength);
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static <K> K[] trim(K[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        K[] t = ObjectArrays.newArray(array, length);
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static <K> K[] setLength(K[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ObjectArrays.trim(array, length);
        }
        return ObjectArrays.ensureCapacity(array, length);
    }

    public static <K> K[] copy(K[] array, int offset, int length) {
        ObjectArrays.ensureOffsetLength(array, offset, length);
        K[] a2 = ObjectArrays.newArray(array, length);
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static <K> K[] copy(K[] array) {
        return (Object[])array.clone();
    }

    public static <K> void fill(K[] array, K value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static <K> void fill(K[] array, int from, int to, K value) {
        ObjectArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static <K> boolean equals(K[] a1, K[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] != null ? a1[i2].equals(a2[i2]) : a2[i2] == null) continue;
            return false;
        }
        return true;
    }

    public static <K> void ensureFromTo(K[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static <K> void ensureOffsetLength(K[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static <K> void swap(K[] x, int a2, int b2) {
        K t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    private static <K> void vecSwap(K[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            ObjectArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static <K> int med3(K[] x, int a2, int b2, int c2, Comparator<K> comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static <K> void quickSort(K[] x, int from, int to, Comparator<K> comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && comp.compare(x[j2 - 1], x[j2]) > 0; --j2) {
                    ObjectArrays.swap(x, j2, j2 - 1);
                }
            }
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 40) {
                int s = len / 8;
                l2 = ObjectArrays.med3(x, l2, l2 + s, l2 + 2 * s, comp);
                m2 = ObjectArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = ObjectArrays.med3(x, n2 - 2 * s, n2 - s, n2, comp);
            }
            m2 = ObjectArrays.med3(x, l2, m2, n2, comp);
        }
        K v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ObjectArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        ObjectArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        ObjectArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            ObjectArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1) {
            ObjectArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    public static <K> void quickSort(K[] x, Comparator<K> comp) {
        ObjectArrays.quickSort(x, 0, x.length, comp);
    }

    private static <K> int med3(K[] x, int a2, int b2, int c2) {
        int ab = ((Comparable)x[a2]).compareTo(x[b2]);
        int ac = ((Comparable)x[a2]).compareTo(x[c2]);
        int bc = ((Comparable)x[b2]).compareTo(x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static <K> void quickSort(K[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && ((Comparable)x[j2]).compareTo(x[j2 - 1]) < 0; --j2) {
                    ObjectArrays.swap(x, j2, j2 - 1);
                }
            }
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 40) {
                int s = len / 8;
                l2 = ObjectArrays.med3(x, l2, l2 + s, l2 + 2 * s);
                m2 = ObjectArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = ObjectArrays.med3(x, n2 - 2 * s, n2 - s, n2);
            }
            m2 = ObjectArrays.med3(x, l2, m2, n2);
        }
        K v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = ((Comparable)x[b2]).compareTo(v)) <= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = ((Comparable)x[c2]).compareTo(v)) >= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ObjectArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        ObjectArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        ObjectArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            ObjectArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            ObjectArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static <K> void quickSort(K[] x) {
        ObjectArrays.quickSort(x, 0, x.length);
    }

    public static <K> void mergeSort(K[] a2, int from, int to, K[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && ((Comparable)a2[j2]).compareTo(a2[j2 - 1]) < 0; --j2) {
                    ObjectArrays.swap(a2, j2, j2 - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ObjectArrays.mergeSort(supp, from, mid, a2);
        ObjectArrays.mergeSort(supp, mid, to, a2);
        if (((Comparable)supp[mid - 1]).compareTo(supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i3 = from; i3 < to; ++i3) {
            a2[i3] = q >= to || p2 < mid && ((Comparable)supp[p2]).compareTo(supp[q]) <= 0 ? supp[p2++] : supp[q++];
        }
    }

    public static <K> void mergeSort(K[] a2, int from, int to) {
        ObjectArrays.mergeSort(a2, from, to, (Object[])a2.clone());
    }

    public static <K> void mergeSort(K[] a2) {
        ObjectArrays.mergeSort(a2, 0, a2.length);
    }

    public static <K> void mergeSort(K[] a2, int from, int to, Comparator<K> comp, K[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && comp.compare(a2[j2 - 1], a2[j2]) > 0; --j2) {
                    ObjectArrays.swap(a2, j2, j2 - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ObjectArrays.mergeSort(supp, from, mid, comp, a2);
        ObjectArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i3 = from; i3 < to; ++i3) {
            a2[i3] = q >= to || p2 < mid && comp.compare(supp[p2], supp[q]) <= 0 ? supp[p2++] : supp[q++];
        }
    }

    public static <K> void mergeSort(K[] a2, int from, int to, Comparator<K> comp) {
        ObjectArrays.mergeSort(a2, from, to, comp, (Object[])a2.clone());
    }

    public static <K> void mergeSort(K[] a2, Comparator<K> comp) {
        ObjectArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static <K> int binarySearch(K[] a2, int from, int to, K key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            K midVal = a2[mid];
            int cmp = ((Comparable)midVal).compareTo(key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static <K> int binarySearch(K[] a2, K key) {
        return ObjectArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static <K> int binarySearch(K[] a2, int from, int to, K key, Comparator<K> c2) {
        while (from <= to) {
            int mid = from + to >>> 1;
            K midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static <K> int binarySearch(K[] a2, K key, Comparator<K> c2) {
        return ObjectArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy<K>
    implements Hash.Strategy<K[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(K[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(K[] a2, K[] b2) {
            return ObjectArrays.equals(a2, b2);
        }
    }
}

