/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.io.Serializable;

public class LongArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final long[] EMPTY_ARRAY = new long[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private LongArrays() {
    }

    public static long[] ensureCapacity(long[] array, int length) {
        if (length > array.length) {
            long[] t = new long[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static long[] ensureCapacity(long[] array, int length, int preserve) {
        if (length > array.length) {
            long[] t = new long[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static long[] grow(long[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            long[] t = new long[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static long[] grow(long[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            long[] t = new long[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static long[] trim(long[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        long[] t = length == 0 ? EMPTY_ARRAY : new long[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static long[] setLength(long[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return LongArrays.trim(array, length);
        }
        return LongArrays.ensureCapacity(array, length);
    }

    public static long[] copy(long[] array, int offset, int length) {
        LongArrays.ensureOffsetLength(array, offset, length);
        long[] a2 = length == 0 ? EMPTY_ARRAY : new long[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static long[] copy(long[] array) {
        return (long[])array.clone();
    }

    public static void fill(long[] array, long value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static void fill(long[] array, int from, int to, long value) {
        LongArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static boolean equals(long[] a1, long[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(long[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(long[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static void swap(long[] x, int a2, int b2) {
        long t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    private static void vecSwap(long[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            LongArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(long[] x, int a2, int b2, int c2, LongComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(long[] x, int from, int to, LongComparator comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && comp.compare(x[j2 - 1], x[j2]) > 0; --j2) {
                    LongArrays.swap(x, j2, j2 - 1);
                }
            }
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 40) {
                int s = len / 8;
                l2 = LongArrays.med3(x, l2, l2 + s, l2 + 2 * s, comp);
                m2 = LongArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = LongArrays.med3(x, n2 - 2 * s, n2 - s, n2, comp);
            }
            m2 = LongArrays.med3(x, l2, m2, n2, comp);
        }
        long v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            LongArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        LongArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        LongArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            LongArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1) {
            LongArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    public static void quickSort(long[] x, LongComparator comp) {
        LongArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(long[] x, int a2, int b2, int c2) {
        int bc;
        int ac;
        int ab;
        int n2 = x[a2] < x[b2] ? -1 : (ab = x[a2] == x[b2] ? 0 : 1);
        int n3 = x[a2] < x[c2] ? -1 : (ac = x[a2] == x[c2] ? 0 : 1);
        int n4 = x[b2] < x[c2] ? -1 : (bc = x[b2] == x[c2] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(long[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && x[j2] < x[j2 - 1]; --j2) {
                    LongArrays.swap(x, j2, j2 - 1);
                }
            }
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 40) {
                int s = len / 8;
                l2 = LongArrays.med3(x, l2, l2 + s, l2 + 2 * s);
                m2 = LongArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = LongArrays.med3(x, n2 - 2 * s, n2 - s, n2);
            }
            m2 = LongArrays.med3(x, l2, m2, n2);
        }
        long v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (x[b2] < v ? -1 : (comparison = x[b2] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (x[c2] < v ? -1 : (comparison = x[c2] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            LongArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        LongArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        LongArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            LongArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            LongArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static void quickSort(long[] x) {
        LongArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(long[] a2, int from, int to, long[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && a2[j2] < a2[j2 - 1]; --j2) {
                    LongArrays.swap(a2, j2, j2 - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        LongArrays.mergeSort(supp, from, mid, a2);
        LongArrays.mergeSort(supp, mid, to, a2);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i3 = from; i3 < to; ++i3) {
            a2[i3] = q >= to || p2 < mid && supp[p2] <= supp[q] ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(long[] a2, int from, int to) {
        LongArrays.mergeSort(a2, from, to, (long[])a2.clone());
    }

    public static void mergeSort(long[] a2) {
        LongArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(long[] a2, int from, int to, LongComparator comp, long[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i2 = from; i2 < to; ++i2) {
                for (int j2 = i2; j2 > from && comp.compare(a2[j2 - 1], a2[j2]) > 0; --j2) {
                    LongArrays.swap(a2, j2, j2 - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        LongArrays.mergeSort(supp, from, mid, comp, a2);
        LongArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i3 = from; i3 < to; ++i3) {
            a2[i3] = q >= to || p2 < mid && comp.compare(supp[p2], supp[q]) <= 0 ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(long[] a2, int from, int to, LongComparator comp) {
        LongArrays.mergeSort(a2, from, to, comp, (long[])a2.clone());
    }

    public static void mergeSort(long[] a2, LongComparator comp) {
        LongArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(long[] a2, int from, int to, long key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            long midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(long[] a2, long key) {
        return LongArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(long[] a2, int from, int to, long key, LongComparator c2) {
        while (from <= to) {
            int mid = from + to >>> 1;
            long midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(long[] a2, long key, LongComparator c2) {
        return LongArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy
    implements Hash.Strategy<long[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(long[] a2, long[] b2) {
            return LongArrays.equals(a2, b2);
        }
    }
}

