/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import com.google.protobuf.CodedInputStream;
import edu.cornell.med.icb.goby.alignments.AbstractAlignmentReader;
import edu.cornell.med.icb.goby.alignments.AlignmentReader;
import edu.cornell.med.icb.goby.alignments.Alignments;
import edu.cornell.med.icb.goby.alignments.ReferenceLocation;
import edu.cornell.med.icb.goby.exception.GobyRuntimeException;
import edu.cornell.med.icb.goby.reads.FastBufferedMessageChunksReader;
import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.lang.MutableString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlignmentReaderImpl
extends AbstractAlignmentReader
implements AlignmentReader {
    private static final Log LOG = LogFactory.getLog(AlignmentReaderImpl.class);
    private InputStream headerStream;
    private int numberOfAlignedReads;
    private final FastBufferedMessageChunksReader alignmentEntryReader;
    private Alignments.AlignmentCollection collection;
    private Properties stats;
    private String basename;
    private boolean indexLoaded;
    private long[] targetPositionOffsets;
    private int endReferenceIndex;
    private int endPosition;
    private int startPosition;
    private int startReferenceIndex;
    public static final String[] COMPACT_ALIGNMENT_FILE_REQUIRED_EXTS = new String[]{".entries", ".header"};
    private Alignments.AlignmentEntry nextEntry;
    private Alignments.AlignmentEntry nextEntryNoFilter;
    private boolean queryLengthStoredInEntries;
    private String alignerName;
    private String alignerVersion;
    private String gobyVersion;
    private boolean sorted;
    private boolean indexed;
    private IndexedIdentifier identifiers;
    private DoubleIndexedIdentifier back;
    private LongArrayList indexOffsets = new LongArrayList();
    private LongArrayList indexAbsolutePositions = new LongArrayList();

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    public static boolean canRead(String filename) {
        String filenameNoExtension = FilenameUtils.removeExtension(filename);
        int count = 0;
        for (String extension : COMPACT_ALIGNMENT_FILE_REQUIRED_EXTS) {
            File fileComponent = new File(filenameNoExtension + extension);
            if (!fileComponent.canRead()) continue;
            ++count;
        }
        return count == COMPACT_ALIGNMENT_FILE_REQUIRED_EXTS.length;
    }

    public AlignmentReaderImpl(String basename, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) throws IOException {
        super(true, AlignmentReaderImpl.getBasename(basename));
        this.basename = AlignmentReaderImpl.getBasename(basename);
        try {
            this.headerStream = new GZIPInputStream(new FileInputStream(this.basename + ".header"));
        }
        catch (IOException e2) {
            LOG.trace("falling back to legacy 1.4- uncompressed header.");
            this.headerStream = new FileInputStream(this.basename + ".header");
        }
        this.readHeader();
        if (!this.indexed) {
            throw new UnsupportedOperationException("The alignment must be sorted and indexed to read slices of data by reference position.");
        }
        this.readIndex();
        FileInputStream stream = new FileInputStream(this.basename + ".entries");
        long startOffset = this.getByteOffset(startReferenceIndex, startPosition, 0);
        long endOffset = this.getByteOffset(endReferenceIndex, endPosition + 1, 1);
        this.endPosition = endPosition;
        this.endReferenceIndex = endReferenceIndex;
        this.startPosition = startPosition;
        this.startReferenceIndex = startReferenceIndex;
        this.alignmentEntryReader = new FastBufferedMessageChunksReader(startOffset > 0L ? startOffset : 0L, endOffset > 0L ? endOffset : Long.MAX_VALUE, new FastBufferedInputStream(stream));
        LOG.trace("start offset :" + startOffset + " end offset " + endOffset);
        this.stats = new Properties();
        File statsFile = new File(basename + ".stats");
        if (statsFile.exists()) {
            FileReader statsFileReader = null;
            try {
                statsFileReader = new FileReader(statsFile);
                this.stats.load(statsFileReader);
            }
            catch (IOException e3) {
                try {
                    LOG.warn("cannot load properties for basename: " + basename, e3);
                    throw e3;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(statsFileReader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(statsFileReader);
        }
    }

    public AlignmentReaderImpl(long startOffset, long endOffset, String basename) throws IOException {
        this(startOffset, endOffset, basename, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlignmentReaderImpl(long startOffset, long endOffset, String basename, boolean upgrade) throws IOException {
        super(upgrade, AlignmentReaderImpl.getBasename(basename));
        this.basename = AlignmentReaderImpl.getBasename(basename);
        FileInputStream stream = new FileInputStream(basename + ".entries");
        this.alignmentEntryReader = new FastBufferedMessageChunksReader(startOffset, endOffset, new FastBufferedInputStream(stream));
        LOG.trace("start offset :" + startOffset + " end offset " + endOffset);
        try {
            this.headerStream = new GZIPInputStream(new FileInputStream(this.basename + ".header"));
        }
        catch (IOException e2) {
            LOG.trace("falling back to legacy 1.4- uncompressed header.");
            this.headerStream = new FileInputStream(this.basename + ".header");
        }
        this.stats = new Properties();
        File statsFile = new File(this.basename + ".stats");
        if (statsFile.exists()) {
            FileReader statsFileReader = null;
            try {
                statsFileReader = new FileReader(statsFile);
                this.stats.load(statsFileReader);
            }
            catch (IOException e3) {
                try {
                    LOG.warn("cannot load properties for basename: " + this.basename, e3);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(statsFileReader);
                    throw throwable;
                }
                IOUtils.closeQuietly(statsFileReader);
            }
            IOUtils.closeQuietly(statsFileReader);
        }
        this.startReferenceIndex = 0;
        this.startPosition = 0;
        this.endReferenceIndex = Integer.MAX_VALUE;
        this.endPosition = Integer.MAX_VALUE;
    }

    public AlignmentReaderImpl(String basename) throws IOException {
        this(0L, Long.MAX_VALUE, AlignmentReaderImpl.getBasename(basename), true);
    }

    public AlignmentReaderImpl(String basename, boolean upgrade) throws IOException {
        this(0L, Long.MAX_VALUE, AlignmentReaderImpl.getBasename(basename), upgrade);
    }

    @Override
    public String basename() {
        return this.basename;
    }

    public AlignmentReaderImpl(InputStream entriesStream) throws IOException {
        super(true, null);
        this.alignmentEntryReader = new FastBufferedMessageChunksReader(0L, Long.MAX_VALUE, new FastBufferedInputStream(entriesStream));
    }

    public AlignmentReaderImpl(long start, long end, FastBufferedInputStream stream) throws IOException {
        super(true, null);
        this.alignmentEntryReader = new FastBufferedMessageChunksReader(start, end, stream);
    }

    private int numberOfEntries() {
        return this.collection != null ? this.collection.getAlignmentEntriesCount() : 0;
    }

    @Override
    public boolean hasNext() {
        int position;
        int entryTargetIndex;
        if (this.nextEntry != null) {
            return true;
        }
        do {
            if (!this.hasNextEntry()) {
                this.nextEntry = null;
                return false;
            }
            this.nextEntry = this.nextEntry();
            entryTargetIndex = this.nextEntry.getTargetIndex();
            position = this.nextEntry.getPosition();
            if (entryTargetIndex <= this.endReferenceIndex && (entryTargetIndex != this.endReferenceIndex || position <= this.endPosition)) continue;
            this.nextEntry = null;
            this.nextEntryNoFilter = null;
            this.collection = null;
            return false;
        } while (entryTargetIndex < this.startReferenceIndex || entryTargetIndex == this.startReferenceIndex && position < this.startPosition);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Alignments.AlignmentEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            int position = this.nextEntry.getPosition();
            int targetIndex = this.nextEntry.getTargetIndex();
            if (LOG.isTraceEnabled()) {
                if (this.back == null) {
                    this.identifiers = this.getTargetIdentifiers();
                    this.back = new DoubleIndexedIdentifier(this.identifiers);
                }
                LOG.trace(String.format("Returning next entry at position %s/%d", this.back.getId(this.nextEntry.getTargetIndex()), this.nextEntry.getPosition()));
            }
            Alignments.AlignmentEntry alignmentEntry = this.nextEntry;
            return alignmentEntry;
        }
        finally {
            this.nextEntry = null;
        }
    }

    private boolean hasNextEntry() {
        if (this.nextEntryNoFilter != null) {
            return true;
        }
        if (this.collection != null && this.alignmentEntryReader.getEntryIndex() < this.collection.getAlignmentEntriesCount()) {
            this.nextEntryNoFilter = this.collection.getAlignmentEntries(this.alignmentEntryReader.getEntryIndex());
            this.alignmentEntryReader.incrementEntryIndex();
            return true;
        }
        this.collection = null;
        boolean hasNext = this.alignmentEntryReader.hasNext(this.collection, this.numberOfEntries());
        GZIPInputStream uncompressStream = this.alignmentEntryReader.getUncompressStream();
        try {
            if (uncompressStream != null) {
                this.collection = Alignments.AlignmentCollection.parseFrom(uncompressStream);
                if (this.collection.getAlignmentEntriesCount() == 0) {
                    return false;
                }
            }
        }
        catch (IOException e2) {
            throw new GobyRuntimeException(e2);
        }
        if (hasNext) {
            this.nextEntryNoFilter = this.collection.getAlignmentEntries(this.alignmentEntryReader.getEntryIndex());
            this.alignmentEntryReader.incrementEntryIndex();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alignments.AlignmentEntry nextEntry() {
        if (!this.hasNextEntry()) {
            throw new NoSuchElementException();
        }
        try {
            Alignments.AlignmentEntry alignmentEntry = this.nextEntryNoFilter;
            return alignmentEntry;
        }
        finally {
            this.nextEntryNoFilter = null;
        }
    }

    @Override
    public final Alignments.AlignmentEntry skipTo(int targetIndex, int position) throws IOException {
        if (targetIndex < this.startReferenceIndex || targetIndex > this.endReferenceIndex) {
            return null;
        }
        int positionChanged = position;
        if (targetIndex == this.startReferenceIndex) {
            positionChanged = Math.max(this.startPosition, position);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("skipTo %d/%d%n", targetIndex, positionChanged));
        }
        this.repositionInternal(targetIndex, positionChanged, false);
        Alignments.AlignmentEntry entry = null;
        boolean hasNext = false;
        while ((hasNext = this.hasNext()) && (entry = this.next()) != null && (entry.getTargetIndex() < targetIndex || entry.getTargetIndex() == targetIndex && entry.getPosition() < positionChanged)) {
        }
        if (!hasNext) {
            return null;
        }
        return entry;
    }

    @Override
    public final void reposition(int targetIndex, int position) throws IOException {
        this.readHeader();
        if (!this.sorted) {
            throw new UnsupportedOperationException("reposition cannot be used with unsorted alignments.");
        }
        this.readIndex();
        this.repositionInternal(targetIndex, position, true);
    }

    private void repositionInternal(int targetIndex, int position, boolean goBack) throws IOException {
        long currentPosition;
        if (!this.indexLoaded) {
            return;
        }
        long absolutePosition = this.recodePosition(targetIndex, position);
        int offsetIndex = Arrays.binarySearch(this.indexAbsolutePositions.elements(), absolutePosition);
        offsetIndex = offsetIndex < 0 ? -1 - offsetIndex : offsetIndex;
        int n2 = offsetIndex = offsetIndex >= this.indexOffsets.size() ? this.indexOffsets.size() - 1 : Math.max(offsetIndex - 1, 0);
        if (offsetIndex < 0) {
            return;
        }
        long newPosition = this.indexOffsets.getLong(offsetIndex);
        if (newPosition >= (currentPosition = this.alignmentEntryReader.position())) {
            this.seek(newPosition);
        } else if (goBack) {
            this.seek(newPosition);
        }
    }

    protected void seek(long byteOffset) throws IOException {
        this.alignmentEntryReader.seek(byteOffset);
        this.nextEntry = null;
        this.nextEntryNoFilter = null;
        this.collection = null;
    }

    protected long getByteOffset(int targetIndex, int position, int chunkOffset) {
        if (targetIndex >= this.targetPositionOffsets.length) {
            return Long.MAX_VALUE;
        }
        long absolutePosition = this.recodePosition(targetIndex, position);
        int offsetIndex = Arrays.binarySearch(this.indexAbsolutePositions.elements(), absolutePosition);
        offsetIndex = offsetIndex < 0 ? -1 - offsetIndex : offsetIndex;
        int n2 = offsetIndex = offsetIndex >= this.indexOffsets.size() ? this.indexOffsets.size() - 1 : offsetIndex - 1;
        if (offsetIndex < 0) {
            return Long.MIN_VALUE;
        }
        if (offsetIndex + chunkOffset < this.indexOffsets.size()) {
            long byteOffset = this.indexOffsets.getLong(offsetIndex + chunkOffset);
            return byteOffset;
        }
        return this.indexOffsets.getLong(offsetIndex) + 10L;
    }

    protected long recodePosition(int firstTargetIndexInChunk, int firstPositionInChunk) {
        return this.targetPositionOffsets[firstTargetIndexInChunk] + (long)firstPositionInChunk;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a reader.");
    }

    @Override
    public void readHeader() throws IOException {
        if (!this.isHeaderLoaded()) {
            CodedInputStream codedInput = CodedInputStream.newInstance(this.headerStream);
            codedInput.setSizeLimit(Integer.MAX_VALUE);
            Alignments.AlignmentHeader header = Alignments.AlignmentHeader.parseFrom(codedInput);
            this.alignerName = header.getAlignerName();
            this.alignerVersion = header.getAlignerVersion();
            this.smallestQueryIndex = header.getSmallestSplitQueryIndex();
            this.largestQueryIndex = header.getLargestSplitQueryIndex();
            this.queryIdentifiers = this.parseIdentifiers(header.getQueryNameMapping());
            this.targetIdentifiers = this.parseIdentifiers(header.getTargetNameMapping());
            if (header.hasConstantQueryLength()) {
                this.constantQueryLengths = true;
                this.constantLength = header.getConstantQueryLength();
            }
            this.queryLengthStoredInEntries = header.getQueryLengthsStoredInEntries();
            assert (this.queryLengthStoredInEntries) : "This version of Goby requires that query lengths are stored in entries. You can upgrade old alignment files by transfering data with the concat mode of a previous version.";
            if (header.getTargetLengthCount() > 0) {
                this.targetLengths = new IntArrayList(header.getTargetLengthList()).toIntArray();
            }
            this.numberOfQueries = header.getNumberOfQueries();
            this.numberOfTargets = header.getNumberOfTargets();
            this.setHeaderLoaded(true);
            this.numberOfAlignedReads = header.getNumberOfAlignedReads();
            this.sorted = header.getSorted() && this.indexExists(this.basename);
            this.indexed = header.getIndexed() && this.indexExists(this.basename);
            this.gobyVersion = header.getVersion();
        }
    }

    private boolean indexExists(String basename) {
        return new File(basename + ".index").exists();
    }

    @Override
    public final void readIndex() throws IOException {
        if (this.indexed && !this.indexLoaded) {
            this.readHeader();
            GZIPInputStream indexStream = new GZIPInputStream(new FileInputStream(this.basename + ".index"));
            CodedInputStream codedInput = CodedInputStream.newInstance(indexStream);
            codedInput.setSizeLimit(Integer.MAX_VALUE);
            Alignments.AlignmentIndex index = Alignments.AlignmentIndex.parseFrom(codedInput);
            this.indexOffsets.clear();
            this.indexAbsolutePositions.clear();
            for (long offset : index.getOffsetsList()) {
                this.indexOffsets.add(offset);
            }
            for (long absolutePosition : index.getAbsolutePositionsList()) {
                this.indexAbsolutePositions.add(absolutePosition);
            }
            this.indexAbsolutePositions.trim();
            this.indexOffsets.trim();
            this.targetPositionOffsets = new long[this.targetLengths.length];
            this.targetPositionOffsets[0] = 0L;
            for (int targetIndex = 1; targetIndex < this.targetLengths.length; ++targetIndex) {
                this.targetPositionOffsets[targetIndex] = (long)this.targetLengths[targetIndex - 1] + this.targetPositionOffsets[targetIndex - 1];
            }
            this.indexLoaded = true;
        }
    }

    private IndexedIdentifier parseIdentifiers(Alignments.IdentifierMapping nameMapping) {
        IndexedIdentifier result = new IndexedIdentifier();
        for (Alignments.IdentifierInfo info : nameMapping.getMappingsList()) {
            result.put(new MutableString(info.getName()), info.getIndex());
        }
        return result;
    }

    @Override
    public void close() {
        if (this.alignmentEntryReader != null) {
            this.alignmentEntryReader.close();
        }
    }

    @Override
    public Iterator<Alignments.AlignmentEntry> iterator() {
        return this;
    }

    @Override
    public Properties getStatistics() {
        return this.stats;
    }

    @Override
    public int getNumberOfAlignedReads() {
        return this.numberOfAlignedReads;
    }

    @Override
    public ObjectList<ReferenceLocation> getLocations(int modulo) throws IOException {
        assert (this.isHeaderLoaded()) : "header must be loaded to query locations.";
        if (!this.isIndexed()) {
            throw new RuntimeException("Alignment must be sorted and indexed to obtain locations.");
        }
        this.readIndex();
        ObjectArrayList<ReferenceLocation> result = new ObjectArrayList<ReferenceLocation>();
        Iterator i$ = this.indexAbsolutePositions.iterator();
        while (i$.hasNext()) {
            long absoluteLocation = (Long)i$.next();
            ReferenceLocation location = this.decodeAbsoluteLocation(absoluteLocation - absoluteLocation % (long)modulo);
            result.add(location);
        }
        return result;
    }

    private ReferenceLocation decodeAbsoluteLocation(long absoluteLocation) {
        int referenceIndex;
        for (referenceIndex = this.targetPositionOffsets.length - 1; referenceIndex >= 0; --referenceIndex) {
            long offset = this.targetPositionOffsets[referenceIndex];
            if (absoluteLocation <= offset - 1L) continue;
            absoluteLocation -= offset;
            break;
        }
        return new ReferenceLocation(referenceIndex, (int)absoluteLocation);
    }

    @Override
    public boolean isQueryLengthStoredInEntries() {
        return this.queryLengthStoredInEntries;
    }

    @Override
    public String getAlignerName() {
        return this.alignerName;
    }

    @Override
    public String getAlignerVersion() {
        return this.alignerVersion;
    }

    @Override
    public int getConstantQueryLength() {
        return this.constantLength;
    }

    public String getGobyVersion() {
        assert (this.isHeaderLoaded()) : "header must be loaded to query Goby version.";
        return this.gobyVersion == null || "".equals(this.gobyVersion) ? "1.9.5-" : this.gobyVersion;
    }
}

