/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class XmlFriendlyReplacer {
    private String dollarReplacement;
    private String underscoreReplacement;
    private transient Map escapeCache;
    private transient Map unescapeCache;

    public XmlFriendlyReplacer() {
        this("_-", "__");
    }

    public XmlFriendlyReplacer(String dollarReplacement, String underscoreReplacement) {
        this.dollarReplacement = dollarReplacement;
        this.underscoreReplacement = underscoreReplacement;
        this.escapeCache = new WeakHashMap();
        this.unescapeCache = new WeakHashMap();
    }

    public String escapeName(String name) {
        WeakReference ref = (WeakReference)this.escapeCache.get(name);
        String s = ref == null ? null : ref.get();
        if (s == null) {
            char c2;
            int i2;
            int length = name.length();
            for (i2 = 0; i2 < length && (c2 = name.charAt(i2)) != '$' && c2 != '_'; ++i2) {
            }
            if (i2 == length) {
                return name;
            }
            StringBuffer result = new StringBuffer(length + 8);
            if (i2 > 0) {
                result.append(name.substring(0, i2));
            }
            while (i2 < length) {
                char c3 = name.charAt(i2);
                if (c3 == '$') {
                    result.append(this.dollarReplacement);
                } else if (c3 == '_') {
                    result.append(this.underscoreReplacement);
                } else {
                    result.append(c3);
                }
                ++i2;
            }
            s = result.toString();
            this.escapeCache.put(name, new WeakReference<String>(s));
        }
        return s;
    }

    public String unescapeName(String name) {
        WeakReference ref = (WeakReference)this.unescapeCache.get(name);
        String s = ref == null ? null : ref.get();
        if (s == null) {
            char c2;
            int i2;
            char dollarReplacementFirstChar = this.dollarReplacement.charAt(0);
            char underscoreReplacementFirstChar = this.underscoreReplacement.charAt(0);
            int length = name.length();
            for (i2 = 0; i2 < length && (c2 = name.charAt(i2)) != dollarReplacementFirstChar && c2 != underscoreReplacementFirstChar; ++i2) {
            }
            if (i2 == length) {
                return name;
            }
            StringBuffer result = new StringBuffer(length + 8);
            if (i2 > 0) {
                result.append(name.substring(0, i2));
            }
            while (i2 < length) {
                char c3 = name.charAt(i2);
                if (c3 == dollarReplacementFirstChar && name.startsWith(this.dollarReplacement, i2)) {
                    i2 += this.dollarReplacement.length() - 1;
                    result.append('$');
                } else if (c3 == underscoreReplacementFirstChar && name.startsWith(this.underscoreReplacement, i2)) {
                    i2 += this.underscoreReplacement.length() - 1;
                    result.append('_');
                } else {
                    result.append(c3);
                }
                ++i2;
            }
            s = result.toString();
            this.unescapeCache.put(name, new WeakReference<String>(s));
        }
        return s;
    }

    private Object readResolve() {
        this.escapeCache = new WeakHashMap();
        this.unescapeCache = new WeakHashMap();
        return this;
    }
}

