/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.HttpResponseException;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.ftp.FTPClient;
import org.broad.igv.util.ftp.FTPStream;
import org.broad.igv.util.ftp.FTPUtils;
import org.broad.igv.util.stream.ApacheURLHelper;
import org.broad.tribble.util.SeekableHTTPStream;

public class IGVHttpClientUtils {
    private static Logger log = Logger.getLogger(IGVHttpClientUtils.class);
    public static boolean byteRangeTested = false;
    public static boolean useByteRange = true;
    private static DefaultHttpClient client = IGVHttpClientUtils.createClient();
    private static IdleConnectionMonitorThread monitorThread;

    private static DefaultHttpClient createClient() {
        try {
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager();
            cm.setMaxTotal(100);
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = IGVHttpClientUtils.getDefaultTrustManager();
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry sr = cm.getSchemeRegistry();
            sr.register(new Scheme("https", ssf, 443));
            monitorThread = new IdleConnectionMonitorThread(cm);
            monitorThread.start();
            client = new DefaultHttpClient(cm);
            client.getParams().setParameter("http.protocol.allow-circular-redirects", true);
            client.getParams().setParameter("http.useragent", Globals.applicationString());
            boolean includeKerbeos = new File(System.getenv("windir") + "\\krb5.ini").exists();
            ArrayList<String> authpref = new ArrayList<String>();
            authpref.add("Basic");
            authpref.add("Digest");
            if (includeKerbeos) {
                authpref.add("negotiate");
            }
            authpref.add("NTLM");
            client.getParams().setParameter("http.auth.proxy-scheme-pref", authpref);
            client.getParams().setParameter("http.auth.target-scheme-pref", authpref);
            return client;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static X509TrustManager getDefaultTrustManager() {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        return tm;
    }

    public static void shutdown() {
        client.getConnectionManager().shutdown();
        monitorThread.shutdown();
    }

    public static String getContentsAsString(URL url) throws IOException {
        HttpResponse response = IGVHttpClientUtils.executeGet(url);
        return EntityUtils.toString(response.getEntity());
    }

    public static String getContentsAsString(URL url, Map<String, String> headers) throws IOException {
        HttpResponse response = IGVHttpClientUtils.executeGet(url, headers);
        return EntityUtils.toString(response.getEntity());
    }

    public static InputStream openConnectionStream(URL url) throws IOException {
        return IGVHttpClientUtils.openConnectionStream(url, false);
    }

    public static InputStream openConnectionStream(URL url, boolean abortOnClose) throws IOException {
        return IGVHttpClientUtils.openConnectionStream(url, abortOnClose, null);
    }

    public static InputStream openConnectionStream(URL url, boolean abortOnClose, Map<String, String> headers) throws IOException {
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            String userInfo = url.getUserInfo();
            String host = url.getHost();
            String file = url.getPath();
            FTPClient ftp = FTPUtils.connect(host, userInfo);
            ftp.pasv();
            ftp.retr(file);
            return new FTPStream(ftp);
        }
        HttpGet getMethod = new HttpGet(url.toExternalForm());
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                getMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
        HttpResponse response = IGVHttpClientUtils.execute(getMethod, url);
        InputStream is = response.getEntity().getContent();
        return abortOnClose ? new ResponseInputStream(getMethod, is) : is;
    }

    public static boolean resourceAvailable(URL url) {
        try {
            if (GSUtils.isGenomeSpace(url.toExternalForm())) {
                HttpGet getMethod = new HttpGet(url.toExternalForm());
                HttpResponse response = IGVHttpClientUtils.execute(getMethod, url);
                int statusCode = response.getStatusLine().getStatusCode();
                getMethod.abort();
                return statusCode == 200;
            }
            HttpHead headMethod = new HttpHead(url.toExternalForm());
            HttpResponse response = IGVHttpClientUtils.execute(headMethod, url);
            int statusCode = response.getStatusLine().getStatusCode();
            return statusCode == 200;
        }
        catch (FileNotFoundException e2) {
            return false;
        }
        catch (Exception e3) {
            log.error("Error checking resoruce availability", e3);
            return false;
        }
    }

    public static String getHeaderField(URL url, String key) throws IOException {
        if (GSUtils.isGenomeSpace(url.toExternalForm())) {
            HttpGet getMethod = new HttpGet(url.toExternalForm());
            HttpResponse response = IGVHttpClientUtils.execute(getMethod, url);
            String value = null;
            Header header = response.getFirstHeader(key);
            if (header != null) {
                value = header.getValue();
            }
            getMethod.abort();
            return value;
        }
        HttpHead headMethod = new HttpHead(url.toExternalForm());
        HttpResponse response = IGVHttpClientUtils.execute(headMethod, url);
        String value = null;
        Header header = response.getFirstHeader(key);
        if (header != null) {
            value = header.getValue();
        }
        return value;
    }

    public static HttpResponse executeGet(URL url) throws IOException {
        HttpGet get = new HttpGet(url.toExternalForm());
        return IGVHttpClientUtils.execute(get, url);
    }

    public static HttpResponse executeGet(URL url, Map<String, String> headers) throws IOException {
        HttpGet get = new HttpGet(url.toExternalForm());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            get.setHeader(entry.getKey(), entry.getValue());
        }
        return IGVHttpClientUtils.execute(get, url);
    }

    public static String createDirectory(URL url, String body) throws IOException {
        HttpPut put = new HttpPut(url.toExternalForm());
        put.setHeader("Content-Type", "application/json");
        StringEntity se = new StringEntity(body);
        put.setEntity(se);
        HttpResponse response = IGVHttpClientUtils.execute(put, url);
        String responseString = EntityUtils.toString(response.getEntity());
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IOException("Error creating directory: " + code);
        }
        return responseString;
    }

    public static void uploadFile(URI uri, File file, Map<String, String> headers) throws IOException {
        HttpPut put = new HttpPut(uri);
        try {
            FileEntity entity = new FileEntity(file, "text");
            put.setEntity(entity);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    put.addHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpResponse response = client.execute(put);
            EntityUtils.consume(response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                client.getCredentialsProvider().clear();
                IGVHttpClientUtils.login(uri.getHost());
                IGVHttpClientUtils.uploadFile(uri, file, headers);
            } else {
                if (statusCode == 404 || statusCode == 410) {
                    put.abort();
                    throw new FileNotFoundException();
                }
                if (statusCode >= 400) {
                    put.abort();
                    throw new HttpResponseException(statusCode);
                }
            }
        }
        catch (RuntimeException e2) {
            if (put != null) {
                put.abort();
            }
            throw e2;
        }
    }

    public static HttpResponse execute(HttpRequestBase method, URL url) throws IOException {
        try {
            HttpResponse response;
            int statusCode;
            if (GSUtils.isGenomeSpace(url.toString())) {
                GSUtils.checkForCookie(client, url.getHost());
            }
            if ((statusCode = (response = client.execute(method)).getStatusLine().getStatusCode()) == 401) {
                client.getCredentialsProvider().clear();
                IGVHttpClientUtils.login(url.getHost());
                return IGVHttpClientUtils.execute(method, url);
            }
            if (statusCode == 404 || statusCode == 410) {
                method.abort();
                throw new FileNotFoundException();
            }
            if (statusCode >= 400) {
                method.abort();
                throw new HttpResponseException(statusCode);
            }
            return response;
        }
        catch (RuntimeException e2) {
            if (method != null) {
                method.abort();
            }
            throw e2;
        }
    }

    private static void login(String server) {
        Frame owner = IGV.hasInstance() ? IGV.getMainFrame() : null;
        String userpass = IGVHttpClientUtils.getUserPass(owner);
        if (userpass == null) {
            throw new RuntimeException("Access denied:  " + server);
        }
        UsernamePasswordCredentials GENOME_SPACE_CREDS = new UsernamePasswordCredentials(userpass);
        String host = GSUtils.isGenomeSpace(server) ? "identitytest.genomespace.org" : server;
        client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM), GENOME_SPACE_CREDS);
        if (GSUtils.isGenomeSpace(host)) {
            try {
                HttpGet httpget = new HttpGet("https://identitytest.genomespace.org:8443/identityServer/basic");
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String responseBody = client.execute((HttpUriRequest)httpget, responseHandler);
                if (responseBody != null && responseBody.length() > 0) {
                    String[] tokens = userpass.split(":");
                    String user = tokens[0];
                    GSUtils.saveLoginForSSO(responseBody, user);
                }
            }
            catch (IOException e2) {
                log.error("Error fetching GS token", e2);
            }
        }
    }

    public static String getUserPass(Frame owner) {
        LoginDialog dlg = new LoginDialog(owner);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return null;
        }
        String userString = dlg.getUsername();
        String userPass = new String(dlg.getPassword());
        return userString + ":" + userPass;
    }

    public static long getContentLength(URL url) throws IOException {
        String contentLengthString = "";
        contentLengthString = IGVHttpClientUtils.getHeaderField(url, "Content-Length");
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public static long getContentLength(HttpResponse response) {
        String contentLengthString = "";
        contentLengthString = response.getFirstHeader("Content-Length").getValue();
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public static boolean isURL(String string) {
        String lcString = string.toLowerCase();
        return lcString.startsWith("http://") || lcString.startsWith("https://") || lcString.startsWith("ftp://") || lcString.startsWith("file://");
    }

    public static boolean testByteRange() {
        try {
            String testURL = "http://www.broadinstitute.org/igvdata/byteRangeTest.txt";
            byte[] expectedBytes = new byte[]{107, 108, 109, 110, 111};
            SeekableHTTPStream str = new SeekableHTTPStream(new ApacheURLHelper(new URL(testURL)));
            str.seek(10L);
            byte[] buffer = new byte[5];
            str.read(buffer, 0, 5);
            for (int i2 = 0; i2 < buffer.length; ++i2) {
                if (buffer[i2] == expectedBytes[i2]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e2) {
            log.error("Error while testing byte range ", e2);
            return false;
        }
    }

    public static boolean useByteRange() {
        useByteRange = PreferenceManager.getInstance().getAsBoolean("UseHttpByteRange");
        if (useByteRange && !byteRangeTested) {
            useByteRange = IGVHttpClientUtils.testByteRange();
            byteRangeTested = true;
        }
        return useByteRange;
    }

    public static void updateProxySettings() {
        int proxyPort;
        String pw = null;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean useProxy = prefMgr.getAsBoolean("PROXY.USE");
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e2) {
            proxyPort = -1;
        }
        boolean auth = prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        String user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        if (useProxy) {
            if (proxyHost != null) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                client.getParams().setParameter("http.route.default-proxy", proxy);
                log.info("Proxy settings: " + proxyHost + ":" + proxyPort);
            }
            if (auth && pw != null) {
                Credentials creds;
                boolean ntlm = prefMgr.getAsBoolean("PROXY.NTLM");
                if (ntlm) {
                    String[] tmp;
                    int nTokens;
                    log.info("Using NTLM authentication");
                    String domain = "";
                    if (user.contains("\\") && (nTokens = ParsingUtils.split(user, tmp = new String[2], '\\')) == 2) {
                        domain = tmp[0];
                        user = tmp[1];
                    }
                    log.info("Domain=" + domain);
                    log.info("User=" + user);
                    String hostName = "127.0.0.1";
                    try {
                        InetAddress i2 = InetAddress.getLocalHost();
                        hostName = i2.getHostName();
                    }
                    catch (Exception e3) {
                        log.error("Error getting host name", e3);
                    }
                    log.info("Workstation=" + hostName);
                    creds = new NTCredentials(user, pw, hostName, domain);
                } else {
                    creds = new UsernamePasswordCredentials(user, pw);
                }
                client.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), creds);
            }
        } else {
            client.getParams().removeParameter("http.route.default-proxy");
        }
    }

    public static boolean downloadFile(String url, File outputFile) throws IOException {
        log.info("Downloading " + url + " to " + outputFile.getAbsolutePath());
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = client.execute(httpget);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            long contentLength = entity.getContentLength();
            log.info("Content length = " + contentLength);
            InputStream is = null;
            FileOutputStream out = null;
            try {
                is = entity.getContent();
                out = new FileOutputStream(outputFile);
                byte[] buf = new byte[65536];
                int downloaded = 0;
                int bytesRead = 0;
                while ((bytesRead = is.read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, bytesRead);
                    downloaded += bytesRead;
                }
                log.info("Download complete.  Total bytes downloaded = " + downloaded);
            }
            catch (IOException e2) {
                httpget.abort();
                throw e2;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
            long fileLength = outputFile.length();
            return contentLength <= 0L || contentLength == fileLength;
        }
        return false;
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final ClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(ClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(60000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(300L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    public static class ResponseInputStream
    extends FilterInputStream {
        HttpGet getMethod;

        public ResponseInputStream(HttpGet getMethod, InputStream content) {
            super(content);
            this.getMethod = getMethod;
        }

        @Override
        public void close() throws IOException {
            this.getMethod.abort();
        }
    }
}

