/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideToggleButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.GenomeServerException;
import org.broad.igv.session.History;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.FitDataToWindowMenuAction;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.ZoomSliderPanel;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;

public class IGVCommandBar
extends JPanel {
    private static Logger log = Logger.getLogger(IGVCommandBar.class);
    static final String DISABLE_POPUP_TOOLTIP = "Disable popup text in data panels.";
    static final String ENABLE_POPUP_TOOLTIP = "Enable popup text in data panels.";
    private List<GenomeManager.GenomeListItem> userDefinedGenomeItemList;
    private List<GenomeManager.GenomeListItem> serverGenomeItemList;
    private List<GenomeManager.GenomeListItem> cachedGenomeItemList;
    private JComboBox chromosomeComboBox;
    private JComboBox genomeComboBox;
    private JideButton goButton;
    private JideButton homeButton;
    private JPanel locationPanel;
    private JideButton refreshButton;
    private JideToggleButton roiToggleButton;
    private JideButton supressTooltipButton;
    private JTextField searchTextField;
    private JPanel toolPanel;
    private JPanel zoomControl;
    private final int DEFAULT_CHROMOSOME_DROPDOWN_WIDTH = 120;
    private JideButton backButton;
    private JideButton forwardButton;
    private JideButton fitToWindowButton;
    private boolean suppressTooltip = false;

    public IGVCommandBar() {
        this.initComponents();
        String currentChr = this.getDefaultReferenceFrame().getChrName();
        boolean isWholeGenome = currentChr.equals("All");
        this.chromosomeComboBox.setSelectedItem(currentChr);
        this.roiToggleButton.setEnabled(!isWholeGenome);
        this.zoomControl.setEnabled(!isWholeGenome);
    }

    public boolean isGenomeCached(String genome) {
        boolean isCached = false;
        if (this.cachedGenomeItemList != null && !this.cachedGenomeItemList.isEmpty()) {
            for (GenomeManager.GenomeListItem item : this.cachedGenomeItemList) {
                if (!item.getId().equalsIgnoreCase(genome)) continue;
                isCached = true;
            }
        }
        return isCached;
    }

    public void initializeGenomeList(ProgressMonitor monitor) throws FileNotFoundException, NoRouteToHostException {
        if (log.isDebugEnabled()) {
            log.debug("Enter initializeGenomeList");
        }
        if (monitor != null) {
            monitor.fireProgressChange(1);
        }
        this.genomeComboBox.removeAllItems();
        this.genomeComboBox.setRenderer(new ComboBoxRenderer());
        this.genomeComboBox.setToolTipText("Switch the current genome");
        this.rebuildGenomeItemList(null);
        if (monitor != null) {
            monitor.fireProgressChange(50);
        }
        this.genomeComboBox.addActionListener(new GenomeBoxActionListener());
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                IGVCommandBar.this.goButtonActionPerformed(actionevent);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Exit initializeGenomeList");
        }
    }

    public void addToUserDefinedGenomeItemList(GenomeManager.GenomeListItem newItem) {
        if (this.userDefinedGenomeItemList == null) {
            this.userDefinedGenomeItemList = new LinkedList<GenomeManager.GenomeListItem>();
            this.userDefinedGenomeItemList.add(newItem);
        } else {
            LinkedList<GenomeManager.GenomeListItem> tempItemList = new LinkedList<GenomeManager.GenomeListItem>();
            tempItemList.add(newItem);
            for (GenomeManager.GenomeListItem item : this.userDefinedGenomeItemList) {
                tempItemList.add(item);
            }
            this.userDefinedGenomeItemList = tempItemList;
        }
        this.setGenomeItemListModel();
    }

    public void rebuildGenomeItemList(Set excludedArchivesUrls) {
        try {
            List<GenomeManager.GenomeListItem> serverSideItemList = null;
            try {
                serverSideItemList = IGV.getInstance().getGenomeManager().getServerGenomeArchiveList(excludedArchivesUrls);
            }
            catch (Exception e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(IGV.getMainFrame(), "The Genome server is currently inaccessible.");
                    }
                });
            }
            List<GenomeManager.GenomeListItem> cacheGenomeItemList = null;
            if (serverSideItemList == null || serverSideItemList.isEmpty()) {
                cacheGenomeItemList = IGV.getInstance().getGenomeManager().getCachedGenomeArchiveList();
            }
            List<GenomeManager.GenomeListItem> clientSideItemList = IGV.getInstance().getGenomeManager().getUserDefinedGenomeArchiveList();
            this.setGenomeItemList(clientSideItemList, serverSideItemList, cacheGenomeItemList);
            this.setGenomeItemListModel();
        }
        catch (Exception e3) {
            log.error("Failed to get genome archive list information from the server!", e3);
        }
    }

    void updateChromosomeDropdown() {
        String homeChr;
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        if (genome == null) {
            return;
        }
        LinkedList<String> tmp = new LinkedList<String>(genome.getChromosomeNames());
        if (tmp.size() > 1 && (homeChr = genome.getHomeChromosome()).equals("All")) {
            tmp.add("All");
        }
        Graphics2D graphics2D = (Graphics2D)this.chromosomeComboBox.getGraphics();
        Font font = this.chromosomeComboBox.getFont();
        FontMetrics fontMetrics = this.chromosomeComboBox.getFontMetrics(font);
        int w = 120;
        for (String chromosomeName : tmp) {
            int width;
            Rectangle2D textBounds = fontMetrics.getStringBounds(chromosomeName, graphics2D);
            if (textBounds == null || (width = textBounds.getBounds().width + 50) <= w) continue;
            w = width;
        }
        Object[] chomosomeNames = tmp.toArray();
        DefaultComboBoxModel<Object> defaultModel = new DefaultComboBoxModel<Object>(chomosomeNames);
        final int dropdownWidth = w;
        this.chromosomeComboBox.setModel(defaultModel);
        this.chromosomeComboBox.setSelectedItem(genome.getHomeChromosome());
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGVCommandBar.this.adjustChromosomeDropdownWidth(dropdownWidth);
            }
        });
    }

    protected void chromosomeChanged(String chrName) {
        this.roiToggleButton.setEnabled(!chrName.equals("All"));
        this.zoomControl.setEnabled(!chrName.equals("All"));
        if (this.chromosomeComboBox.getSelectedItem() != null && !this.chromosomeComboBox.getSelectedItem().equals(chrName)) {
            this.chromosomeComboBox.setSelectedItem(chrName);
        }
    }

    public void updateCurrentCoordinates() {
        this.searchTextField.setText("");
        String chrName = this.getDefaultReferenceFrame().getChrName();
        if (!chrName.equals(this.chromosomeComboBox.getSelectedItem())) {
            this.chromosomeChanged(chrName);
            this.chromosomeComboBox.setSelectedItem(chrName);
            IGV.getInstance().chromosomeChangeEvent(chrName, false);
        }
        String p2 = "";
        if (!chrName.equals("All")) {
            p2 = this.getDefaultReferenceFrame().getFormattedLocusString();
        }
        final String position = p2;
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGVCommandBar.this.searchTextField.setText(position);
            }
        });
        History history = IGV.getInstance().getSession().getHistory();
        this.forwardButton.setEnabled(history.canGoForward());
        this.backButton.setEnabled(history.canGoBack());
    }

    private ReferenceFrame getDefaultReferenceFrame() {
        return FrameManager.getDefaultFrame();
    }

    public void setGeneListMode(boolean geneListMode) {
        this.genomeComboBox.setEnabled(!geneListMode);
        this.locationPanel.setEnabled(!geneListMode);
        this.chromosomeComboBox.setEnabled(!geneListMode);
        this.searchTextField.setEnabled(!geneListMode);
        this.goButton.setEnabled(!geneListMode);
        this.zoomControl.setEnabled(!geneListMode);
        this.homeButton.setEnabled(!geneListMode);
        this.roiToggleButton.setEnabled(!geneListMode);
    }

    public boolean isSuppressTooltip() {
        return this.suppressTooltip;
    }

    public Collection<String> getGenomeDisplayNames() {
        HashSet<String> displayNames = new HashSet<String>();
        int itemCount = this.genomeComboBox.getItemCount();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            Object object = this.genomeComboBox.getItemAt(i2);
            if (!(object instanceof GenomeManager.GenomeListItem)) continue;
            GenomeManager.GenomeListItem genomeListItem = (GenomeManager.GenomeListItem)object;
            displayNames.add(genomeListItem.getDisplayableName());
        }
        return displayNames;
    }

    public Collection<String> getGenomeIds() {
        HashSet<String> ids = new HashSet<String>();
        int itemCount = this.genomeComboBox.getItemCount();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            Object object = this.genomeComboBox.getItemAt(i2);
            if (!(object instanceof GenomeManager.GenomeListItem)) continue;
            GenomeManager.GenomeListItem genomeListItem = (GenomeManager.GenomeListItem)object;
            ids.add(genomeListItem.getId());
        }
        return ids;
    }

    public void selectGenomeFromListWithNoImport(String genomeId) {
        int itemCount = this.genomeComboBox.getItemCount();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            GenomeManager.GenomeListItem genomeListItem;
            String id;
            Object object = this.genomeComboBox.getItemAt(i2);
            if (!(object instanceof GenomeManager.GenomeListItem) || (id = (genomeListItem = (GenomeManager.GenomeListItem)object).getId()) == null || !id.trim().equalsIgnoreCase(genomeId)) continue;
            this.genomeComboBox.setSelectedIndex(i2);
            break;
        }
    }

    public void selectGenomeFromList(String genomeId) throws FileNotFoundException, NoRouteToHostException {
        Object object;
        int i2;
        String currentGenomeId = IGV.getInstance().getGenomeManager().getGenomeId();
        if (currentGenomeId != null && genomeId != null && genomeId.equalsIgnoreCase(currentGenomeId)) {
            return;
        }
        log.debug("Run selectGenomeFromList");
        boolean wasFound = false;
        if (genomeId != null) {
            int itemCount = this.genomeComboBox.getItemCount();
            for (i2 = 0; i2 < itemCount; ++i2) {
                GenomeManager.GenomeListItem genomeListItem;
                String id;
                object = this.genomeComboBox.getItemAt(i2);
                if (!(object instanceof GenomeManager.GenomeListItem) || (id = (genomeListItem = (GenomeManager.GenomeListItem)object).getId()) == null || !id.trim().equalsIgnoreCase(genomeId)) continue;
                this.genomeComboBox.setSelectedIndex(i2);
                wasFound = true;
                break;
            }
        }
        if (!wasFound) {
            int count = this.genomeComboBox.getItemCount();
            for (i2 = 0; i2 < count; ++i2) {
                object = this.genomeComboBox.getItemAt(i2);
                if (!(object instanceof GenomeManager.GenomeListItem)) continue;
                GenomeManager.GenomeListItem item = (GenomeManager.GenomeListItem)object;
                this.genomeComboBox.setSelectedIndex(i2);
                break;
            }
        }
        log.debug("Finish selectGenomeFromList");
    }

    public void updateGenome(String id) {
        FeatureDB.clearFeatures();
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        IGV.getInstance().getTrackManager().createGeneTrack(genome);
        FrameManager.getDefaultFrame().invalidateLocationScale();
        for (Chromosome chr : genome.getChromosomes()) {
            List<Cytoband> cytobands = chr.getCytobands();
            if (cytobands == null) continue;
            for (Cytoband cyto : cytobands) {
                FeatureDB.addFeature(cyto.getLongName(), cyto);
            }
        }
        this.updateChromosomeDropdown();
    }

    public DefaultComboBoxModel getModelForGenomeListComboBox() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        if (this.userDefinedGenomeItemList != null && !this.userDefinedGenomeItemList.isEmpty()) {
            for (GenomeManager.GenomeListItem item : this.userDefinedGenomeItemList) {
                list.add(item);
            }
            list.add("--SEPARATOR--");
        }
        if (this.serverGenomeItemList != null && !this.serverGenomeItemList.isEmpty()) {
            for (GenomeManager.GenomeListItem item : this.serverGenomeItemList) {
                list.add(item);
            }
            if (this.cachedGenomeItemList == null || this.cachedGenomeItemList.isEmpty()) {
                list.add("--SEPARATOR--");
            }
        }
        if (this.cachedGenomeItemList != null && !this.cachedGenomeItemList.isEmpty()) {
            for (GenomeManager.GenomeListItem item : this.cachedGenomeItemList) {
                list.add(item);
            }
            list.add("--SEPARATOR--");
        }
        if (list.isEmpty()) {
            list.add(IGV.getInstance().getGenomeManager().getDefaultGenomeListItem());
        }
        return new DefaultComboBoxModel<Object>(list.toArray());
    }

    public void setGenomeItemList(List<GenomeManager.GenomeListItem> clientItemList, List<GenomeManager.GenomeListItem> serverItemList, List<GenomeManager.GenomeListItem> cachedGenomeItemList) {
        if (clientItemList == null) {
            clientItemList = new LinkedList<GenomeManager.GenomeListItem>();
        }
        if (serverItemList == null) {
            serverItemList = new LinkedList<GenomeManager.GenomeListItem>();
        }
        if (cachedGenomeItemList == null) {
            cachedGenomeItemList = new LinkedList<GenomeManager.GenomeListItem>();
        }
        this.userDefinedGenomeItemList = clientItemList;
        this.cachedGenomeItemList = cachedGenomeItemList;
        this.serverGenomeItemList = serverItemList;
    }

    public void setGenomeItemListModel() {
        this.genomeComboBox.setModel(this.getModelForGenomeListComboBox());
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(200, 32));
        JideBoxLayout layout = new JideBoxLayout(this, 0);
        this.setLayout(layout);
        this.locationPanel = new JPanel();
        this.locationPanel.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.locationPanel.setPreferredSize(new Dimension(150, 20));
        this.locationPanel.setLayout(new JideBoxLayout(this.locationPanel, 0));
        this.locationPanel.setAlignmentY(0.5f);
        this.locationPanel.add(Box.createRigidArea(new Dimension(10, 36)), "fix");
        this.genomeComboBox = new JComboBox();
        this.genomeComboBox.setMinimumSize(new Dimension(180, 27));
        this.genomeComboBox.setPreferredSize(new Dimension(180, 27));
        this.locationPanel.add((Component)this.genomeComboBox, "fix");
        this.locationPanel.add(Box.createHorizontalStrut(5), "fix");
        this.chromosomeComboBox = new JComboBox();
        this.chromosomeComboBox.setToolTipText("Select a chromosome to view");
        this.chromosomeComboBox.setMaximumSize(new Dimension(120, 30));
        this.chromosomeComboBox.setMinimumSize(new Dimension(120, 30));
        this.chromosomeComboBox.setPreferredSize(new Dimension(120, 30));
        this.chromosomeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.chromosomeComboBoxActionPerformed(evt);
            }
        });
        this.locationPanel.add((Component)this.chromosomeComboBox, "fix");
        this.locationPanel.add(Box.createHorizontalStrut(5), "fix");
        this.searchTextField = new SearchTextField();
        this.searchTextField.setToolTipText("Enter a gene of locus, e.f. EGFR,   chr1,   or chr1:100,000-200,000");
        this.searchTextField.setMaximumSize(new Dimension(250, 15));
        this.searchTextField.setMinimumSize(new Dimension(100, 28));
        this.searchTextField.setPreferredSize(new Dimension(230, 28));
        this.searchTextField.setAlignmentY(0.5f);
        this.locationPanel.add((Component)this.searchTextField, "fix");
        this.goButton = new JideButton("Go");
        this.goButton.setToolTipText("Jump to gene or locus");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.goButtonActionPerformed(evt);
            }
        });
        this.locationPanel.add((Component)this.goButton, "fix");
        this.add((Component)this.locationPanel, "fix");
        this.add(Box.createHorizontalStrut(10), "fix");
        this.toolPanel = new JPanel();
        this.toolPanel.setAlignmentX(1.0f);
        this.toolPanel.setLayout(new JideBoxLayout(this.toolPanel, 0));
        this.homeButton = new JideButton();
        this.homeButton.setAlignmentX(1.0f);
        this.homeButton.setButtonStyle(1);
        this.homeButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Home24.gif")));
        this.homeButton.setMaximumSize(new Dimension(32, 32));
        this.homeButton.setMinimumSize(new Dimension(32, 32));
        this.homeButton.setPreferredSize(new Dimension(32, 32));
        this.homeButton.setToolTipText("Jump to whole genome view");
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.homeButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.homeButton, "fix");
        this.backButton = new JideButton();
        this.backButton.setButtonStyle(1);
        this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/images/left-arrow.gif")));
        this.backButton.setToolTipText("Go back");
        this.backButton.setMaximumSize(new Dimension(32, 32));
        this.backButton.setMinimumSize(new Dimension(32, 32));
        this.backButton.setPreferredSize(new Dimension(32, 32));
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGV.getInstance().getSession().getHistory().back();
            }
        });
        this.backButton.setEnabled(false);
        this.toolPanel.add((Component)this.backButton, "fix");
        this.forwardButton = new JideButton();
        this.forwardButton.setButtonStyle(1);
        this.forwardButton.setIcon(new ImageIcon(this.getClass().getResource("/images/right-arrow.gif")));
        this.forwardButton.setToolTipText("Go forward");
        this.forwardButton.setMaximumSize(new Dimension(32, 32));
        this.forwardButton.setMinimumSize(new Dimension(32, 32));
        this.forwardButton.setPreferredSize(new Dimension(32, 32));
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGV.getInstance().getSession().getHistory().forward();
            }
        });
        this.forwardButton.setEnabled(false);
        this.toolPanel.add((Component)this.forwardButton, "fix");
        this.refreshButton = new JideButton();
        this.refreshButton.setButtonStyle(1);
        this.refreshButton.setAlignmentX(1.0f);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh24.gif")));
        this.refreshButton.setMaximumSize(new Dimension(32, 32));
        this.refreshButton.setMinimumSize(new Dimension(32, 32));
        this.refreshButton.setPreferredSize(new Dimension(32, 32));
        this.refreshButton.setToolTipText("Refresh the screen");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.refreshButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.refreshButton, "fix");
        ImageIcon regionOfInterestIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.REGION_OF_INTEREST);
        this.roiToggleButton = new JideToggleButton(regionOfInterestIcon);
        this.roiToggleButton.setButtonStyle(1);
        this.roiToggleButton.setAlignmentX(1.0f);
        this.roiToggleButton.setToolTipText("Define a region of interest.");
        this.roiToggleButton.setMaximumSize(new Dimension(32, 32));
        this.roiToggleButton.setMinimumSize(new Dimension(32, 32));
        this.roiToggleButton.setPreferredSize(new Dimension(32, 32));
        this.roiToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.roiToggleButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.roiToggleButton, "fix");
        this.fitToWindowButton = new JideButton();
        this.fitToWindowButton.setButtonStyle(1);
        this.fitToWindowButton.setAlignmentX(1.0f);
        this.fitToWindowButton.setIcon(new ImageIcon(this.getClass().getResource("/images/collapseall.gif")));
        this.fitToWindowButton.setMaximumSize(new Dimension(32, 32));
        this.fitToWindowButton.setMinimumSize(new Dimension(32, 32));
        this.fitToWindowButton.setPreferredSize(new Dimension(32, 32));
        this.fitToWindowButton.setToolTipText("Resize tracks to fit in window.");
        this.fitToWindowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new FitDataToWindowMenuAction(null, 0, IGV.getInstance()).actionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.fitToWindowButton, "fix");
        final ImageIcon noTooltipIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.NO_TOOLTIP);
        final ImageIcon tooltipIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.TOOLTIP);
        this.supressTooltipButton = new JideButton(noTooltipIcon);
        this.supressTooltipButton.setButtonStyle(1);
        this.supressTooltipButton.setAlignmentX(1.0f);
        this.supressTooltipButton.setToolTipText(DISABLE_POPUP_TOOLTIP);
        this.supressTooltipButton.setMaximumSize(new Dimension(32, 32));
        this.supressTooltipButton.setMinimumSize(new Dimension(32, 32));
        this.supressTooltipButton.setPreferredSize(new Dimension(32, 32));
        this.supressTooltipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.suppressTooltip = !IGVCommandBar.this.suppressTooltip;
                if (IGVCommandBar.this.suppressTooltip) {
                    IGVCommandBar.this.supressTooltipButton.setIcon(tooltipIcon);
                    IGVCommandBar.this.supressTooltipButton.setToolTipText(IGVCommandBar.ENABLE_POPUP_TOOLTIP);
                } else {
                    IGVCommandBar.this.supressTooltipButton.setIcon(noTooltipIcon);
                    IGVCommandBar.this.supressTooltipButton.setToolTipText(IGVCommandBar.DISABLE_POPUP_TOOLTIP);
                }
            }
        });
        this.toolPanel.add((Component)this.supressTooltipButton, "fix");
        this.add(this.toolPanel);
        this.add(Box.createHorizontalGlue(), "vary");
        this.zoomControl = new ZoomSliderPanel();
        this.zoomControl.setPreferredSize(new Dimension(200, 30));
        this.zoomControl.setMinimumSize(new Dimension(200, 30));
        this.zoomControl.setMaximumSize(new Dimension(200, 30));
        this.zoomControl.setToolTipText("Click + to zoom in,  - to zoom out.");
        this.zoomControl.setOpaque(false);
        this.add((Component)this.zoomControl, "fix");
        this.add(Box.createHorizontalStrut(20), "fix");
    }

    public GenomeManager.GenomeListItem getGenomeSelectedInDropdown() {
        return (GenomeManager.GenomeListItem)this.genomeComboBox.getSelectedItem();
    }

    private void adjustChromosomeDropdownWidth(int width) {
        int newWidth = width > 120 ? width : 120;
        this.chromosomeComboBox.setMaximumSize(new Dimension(newWidth, 35));
        this.chromosomeComboBox.setMinimumSize(new Dimension(newWidth, 27));
        this.chromosomeComboBox.setPreferredSize(new Dimension(newWidth, 16));
        this.revalidate();
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        if (FrameManager.isGeneListMode()) {
            IGV.getInstance().setGeneList(null);
        }
        if (genome != null) {
            String chrName = genome.getHomeChromosome();
            this.getDefaultReferenceFrame().setChromosomeName(chrName);
            IGV.getInstance().getSession().getHistory().push(chrName, this.getDefaultReferenceFrame().getZoom());
            this.chromosomeComboBox.setSelectedItem(chrName);
            this.updateCurrentCoordinates();
            IGV.getInstance().chromosomeChangeEvent(chrName);
            IGV.getMainFrame().repaint();
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        IGV.getInstance().doRefresh();
    }

    private void chromosomeComboBoxActionPerformed(ActionEvent evt) {
        JComboBox combobox = (JComboBox)evt.getSource();
        final String chrName = (String)combobox.getSelectedItem();
        if (chrName != null && !chrName.equals(this.getDefaultReferenceFrame().getChrName())) {
            NamedRunnable runnable = new NamedRunnable(){

                @Override
                public void run() {
                    IGVCommandBar.this.getDefaultReferenceFrame().setChromosomeName(chrName);
                    IGVCommandBar.this.getDefaultReferenceFrame().recordHistory();
                    IGVCommandBar.this.updateCurrentCoordinates();
                    IGV.getInstance().chromosomeChangeEvent(chrName);
                    IGV.getMainFrame().repaint();
                    PreferenceManager.getInstance().setLastChromosomeViewed(chrName);
                }

                @Override
                public String getName() {
                    return "Changed chromosome to: " + chrName;
                }
            };
            LongRunningTask.submit(runnable);
        }
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        String searchText = this.searchTextField.getText();
        this.searchByLocus(searchText);
    }

    public void searchByLocus(String searchText) {
        this.searchByLocus(searchText, true);
    }

    public void searchByLocus(final String searchText, boolean inBackground) {
        if (log.isDebugEnabled()) {
            log.debug("Enter search by locus: " + searchText);
        }
        if (searchText != null && searchText.length() > 0) {
            NamedRunnable runnable = new NamedRunnable(){

                @Override
                public void run() {
                    IGVCommandBar.this.searchTextField.setText(searchText);
                    new SearchCommand(IGVCommandBar.this.getDefaultReferenceFrame(), searchText).execute();
                    IGVCommandBar.this.chromosomeComboBox.setSelectedItem(IGVCommandBar.this.getDefaultReferenceFrame().getChrName());
                }

                @Override
                public String getName() {
                    return "Search: " + searchText;
                }
            };
            if (inBackground) {
                LongRunningTask.submit(runnable);
            } else {
                runnable.run();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit search by locus: " + searchText);
        }
    }

    private void roiToggleButtonActionPerformed(ActionEvent evt) {
        if (this.roiToggleButton.isSelected()) {
            IGV.getInstance().beginROI(this.roiToggleButton);
        } else {
            IGV.getInstance().endROI();
        }
    }

    static class SearchTextField
    extends JTextField {
        SearchTextField() {
        }

        @Override
        public void reshape(int arg0, int arg1, int arg2, int arg3) {
            super.reshape(arg0, arg1, arg2, this.getPreferredSize().height);
        }
    }

    static class ComboBoxRenderer
    implements ListCellRenderer {
        JSeparator separator = new JSeparator(0);

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value == null ? "" : value.toString();
            JLabel renderer = null;
            if ("--SEPARATOR--".equals(text)) {
                return this.separator;
            }
            if (text.equals("Remove Imported Genomes...")) {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            } else {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            }
            if (isSelected) {
                ((Component)renderer).setBackground(list.getSelectionBackground());
                ((Component)renderer).setForeground(list.getSelectionForeground());
            } else {
                ((Component)renderer).setBackground(list.getBackground());
                ((Component)renderer).setForeground(list.getForeground());
            }
            ((Component)renderer).setFont(list.getFont());
            return renderer;
        }
    }

    class GenomeBoxActionListener
    implements ActionListener {
        GenomeBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GenomeManager.GenomeListItem genomeListItem = (GenomeManager.GenomeListItem)IGVCommandBar.this.genomeComboBox.getSelectedItem();
                    if (genomeListItem != null) {
                        IGV igv = IGV.getInstance();
                        ProgressMonitor monitor = new ProgressMonitor();
                        ProgressBar bar = ProgressBar.showProgressDialog(IGV.getMainFrame(), "Loading Genome...", monitor, false);
                        try {
                            monitor.fireProgressChange(50);
                            if (genomeListItem.isUserDefined()) {
                                igv.getGenomeManager().loadUserDefinedGenome(genomeListItem.getLocation(), null);
                            } else {
                                igv.getGenomeManager().loadSystemGenome(genomeListItem.getLocation(), null);
                            }
                            IGVCommandBar.this.updateGenome(genomeListItem.getId());
                            monitor.fireProgressChange(25);
                            if (!IGVCommandBar.this.isGenomeCached(genomeListItem.getId())) {
                                IGVCommandBar.this.cachedGenomeItemList.add(genomeListItem);
                            }
                            if (igv.isStartupComplete()) {
                                igv.createNewSession(null);
                            }
                            PreferenceManager.getInstance().setDefaultGenome(genomeListItem.getId());
                            monitor.fireProgressChange(25);
                            IGV.getInstance().doRefresh();
                        }
                        catch (GenomeServerException e2) {
                            log.error("Error accessing genome list: " + e2.getMessage());
                            JOptionPane.showMessageDialog(IGV.getMainFrame(), "The Genome server is currently inaccessible.");
                        }
                        catch (IOException e3) {
                            int choice;
                            if (bar != null) {
                                bar.close();
                            }
                            if ((choice = JOptionPane.showConfirmDialog(IGV.getMainFrame(), "The genome file [" + e3.getMessage() + "] could not be read. Would you like to remove the selected entry?", "", 2)) == 0) {
                                HashSet<String> excludedArchivesUrls = new HashSet<String>();
                                excludedArchivesUrls.add(genomeListItem.getLocation());
                                IGVCommandBar.this.rebuildGenomeItemList(excludedArchivesUrls);
                            }
                        }
                        finally {
                            if (bar != null) {
                                bar.close();
                            }
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        runnable.run();
                        return null;
                    }
                };
                worker.execute();
            } else {
                runnable.run();
            }
        }
    }
}

