/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.RNAiBarChartRenderer;
import org.broad.igv.renderer.ScatterplotRenderer;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.DataRangeDialog;
import org.broad.igv.ui.HeatmapScaleDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.stats.KMPlotFrame;
import org.broad.tribble.Feature;

public class TrackMenuUtils {
    static Logger log = Logger.getLogger(TrackMenuUtils.class);
    static final String LEADING_HEADING_SPACER = "  ";
    private static final WindowFunction[] ORDERED_WINDOW_FUNCTIONS = new WindowFunction[]{WindowFunction.min, WindowFunction.percentile2, WindowFunction.percentile10, WindowFunction.median, WindowFunction.mean, WindowFunction.percentile90, WindowFunction.percentile98, WindowFunction.max, WindowFunction.none};

    public static IGVPopupMenu getPopupMenu(Collection<Track> tracks, String title, TrackClickEvent te) {
        if (log.isDebugEnabled()) {
            log.debug("enter getPopupMenu");
        }
        IGVPopupMenu menu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel(LEADING_HEADING_SPACER + title, 0);
        popupTitle.setFont(UIConstants.boldFont);
        if (popupTitle != null) {
            menu.add(popupTitle);
            menu.addSeparator();
        }
        TrackMenuUtils.addStandardItems(menu, tracks, te);
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.close();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.close();
            }

            private void close() {
                IGV.getInstance().getTrackManager().clearSelections();
                IGV.getInstance().repaint();
            }
        });
        return menu;
    }

    public static void addStandardItems(JPopupMenu menu, Collection<Track> tracks, TrackClickEvent te) {
        boolean hasDataTracks = false;
        boolean hasFeatureTracks = false;
        boolean hasOtherTracks = false;
        for (Track track : tracks) {
            if (track instanceof DataTrack) {
                hasDataTracks = true;
            } else if (track instanceof FeatureTrack) {
                hasFeatureTracks = true;
            } else {
                hasOtherTracks = true;
            }
            if (!hasDataTracks || !hasFeatureTracks || !hasOtherTracks) continue;
            break;
        }
        boolean featureTracksOnly = hasFeatureTracks && !hasDataTracks && !hasOtherTracks;
        boolean dataTracksOnly = !hasFeatureTracks && hasDataTracks && !hasOtherTracks;
        TrackMenuUtils.addSharedItems(menu, tracks, hasFeatureTracks);
        menu.addSeparator();
        if (dataTracksOnly) {
            TrackMenuUtils.addDataItems(menu, tracks);
        } else if (featureTracksOnly) {
            TrackMenuUtils.addFeatureItems(menu, tracks, te);
        }
        menu.addSeparator();
        menu.add(TrackMenuUtils.getRemoveMenuItem(tracks));
    }

    public static void addZoomItems(JPopupMenu menu, final ReferenceFrame frame) {
        if (FrameManager.isGeneListMode()) {
            JMenuItem item = new JMenuItem("Reset panel to '" + frame.getName() + "'");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    frame.reset();
                }
            });
            menu.add(item);
        }
        JMenuItem zoomOutItem = new JMenuItem("Zoom out");
        zoomOutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.incrementZoom(-1);
            }
        });
        menu.add(zoomOutItem);
        JMenuItem zoomInItem = new JMenuItem("Zoom in");
        zoomInItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.incrementZoom(1);
            }
        });
        menu.add(zoomInItem);
    }

    private static void addDataItems(JPopupMenu menu, final Collection<Track> tracks) {
        if (log.isDebugEnabled()) {
            log.debug("enter getDataPopupMenu");
        }
        String[] labels = new String[]{"Heatmap", "Bar Chart", "Scatterplot", "Line Plot"};
        Class[] renderers = new Class[]{HeatmapRenderer.class, BarChartRenderer.class, ScatterplotRenderer.class, LineplotRenderer.class};
        JLabel rendererHeading = new JLabel("  Type of Graph", 2);
        rendererHeading.setFont(UIConstants.boldFont);
        menu.add(rendererHeading);
        HashSet currentRenderers = new HashSet();
        for (Track track : tracks) {
            if (track.getRenderer() == null) continue;
            currentRenderers.add(track.getRenderer().getClass());
        }
        for (int i2 = 0; i2 < labels.length; ++i2) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(labels[i2]);
            final Class rendererClass = renderers[i2];
            if (currentRenderers.contains(rendererClass)) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrackMenuUtils.changeRenderer(tracks, rendererClass);
                }
            });
            menu.add(item);
        }
        menu.addSeparator();
        HashSet<WindowFunction> avaibleWindowFunctions = new HashSet<WindowFunction>();
        for (Track track : tracks) {
            avaibleWindowFunctions.addAll(track.getAvailableWindowFunctions());
        }
        avaibleWindowFunctions.add(WindowFunction.none);
        HashSet<WindowFunction> currentWindowFunctions = new HashSet<WindowFunction>();
        for (Track track : tracks) {
            if (track.getWindowFunction() == null) continue;
            currentWindowFunctions.add(track.getWindowFunction());
        }
        if (!avaibleWindowFunctions.isEmpty() || !currentWindowFunctions.isEmpty()) {
            JLabel statisticsHeading = new JLabel("  Windowing Function", 2);
            statisticsHeading.setFont(UIConstants.boldFont);
            menu.add(statisticsHeading);
            for (final WindowFunction wf : ORDERED_WINDOW_FUNCTIONS) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(wf.getDisplayName());
                if (!avaibleWindowFunctions.contains((Object)wf) && !currentWindowFunctions.contains((Object)wf)) continue;
                if (currentWindowFunctions.contains((Object)wf)) {
                    item.setSelected(true);
                }
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TrackMenuUtils.changeStatType(wf.toString(), tracks);
                    }
                });
                menu.add(item);
            }
            menu.addSeparator();
        }
        menu.add(TrackMenuUtils.getDataRangeItem(tracks));
        menu.add(TrackMenuUtils.getHeatmapScaleItem(tracks));
        if (tracks.size() > 0) {
            menu.add(TrackMenuUtils.getLogScaleItem(tracks));
        }
        menu.add(TrackMenuUtils.getAutoscaleItem(tracks));
        menu.add(TrackMenuUtils.getShowDataRangeItem(tracks));
    }

    private static void addFeatureItems(JPopupMenu featurePopupMenu, Collection<Track> tracks, TrackClickEvent te) {
        Track t;
        Feature f2;
        TrackMenuUtils.addDisplayModeItems(tracks, featurePopupMenu);
        if (tracks.size() == 1 && (f2 = (t = tracks.iterator().next()).getFeatureAtMousePosition(te)) != null) {
            featurePopupMenu.addSeparator();
            if (f2 instanceof IGVFeature) {
                double position = te.getChromosomePosition();
                List<Exon> exons = ((IGVFeature)f2).getExons();
                if (exons != null) {
                    for (Exon exon : exons) {
                        if (!(position > (double)exon.getStart()) || !(position < (double)exon.getEnd())) continue;
                        f2 = exon;
                        break;
                    }
                }
            }
            featurePopupMenu.add(TrackMenuUtils.getCopyDetailsItem(f2, te));
            featurePopupMenu.add(TrackMenuUtils.getCopySequenceItem(f2));
        }
        featurePopupMenu.addSeparator();
        featurePopupMenu.add(TrackMenuUtils.getChangeFeatureWindow(tracks));
    }

    private static void addSharedItems(JPopupMenu menu, final Collection<Track> tracks, boolean hasFeatureTracks) {
        menu.add(TrackMenuUtils.getTrackRenameItem(tracks));
        String colorLabel = hasFeatureTracks ? "Change Track Color..." : "Change Track Color (Positive Values)...";
        JMenuItem item = new JMenuItem(colorLabel);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeTrackColor(tracks);
            }
        });
        menu.add(item);
        if (!hasFeatureTracks) {
            item = new JMenuItem("Change Track Color (Negative Values)...");
            item.setToolTipText("Change the alternate track color.  This color is used when graphing negative values");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrackMenuUtils.changeAltTrackColor(tracks);
                }
            });
            menu.add(item);
        }
        menu.add(TrackMenuUtils.getChangeTrackHeightItem(tracks));
        menu.add(TrackMenuUtils.getChangeFontSizeItem(tracks));
    }

    private static void changeStatType(String statType, Collection<Track> selectedTracks) {
        for (Track track : selectedTracks) {
            track.setWindowFunction(WindowFunction.valueOf(statType));
        }
        TrackMenuUtils.refresh();
    }

    public static JMenuItem getTrackRenameItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Rename Track...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        TrackMenuUtils.renameTrack(selectedTracks);
                    }
                });
            }
        });
        if (selectedTracks.size() > 1) {
            item.setEnabled(false);
        }
        return item;
    }

    private static JMenuItem getHeatmapScaleItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Heatmap Scale...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedTracks.size() > 0) {
                    ContinuousColorScale colorScale = ((Track)selectedTracks.iterator().next()).getColorScale();
                    HeatmapScaleDialog dlg = new HeatmapScaleDialog(IGV.getMainFrame(), colorScale);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        colorScale = dlg.getColorScale();
                        for (Track track : selectedTracks) {
                            track.setColorScale(colorScale);
                        }
                        IGV.getInstance().repaint();
                    }
                }
            }
        });
        return item;
    }

    public static JMenuItem getDataRangeItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Data Range...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedTracks.size() > 0) {
                    float mid = 0.0f;
                    float min = Float.MAX_VALUE;
                    float max = Float.MIN_VALUE;
                    boolean drawBaseline = false;
                    for (Track t : selectedTracks) {
                        DataRange dr = t.getDataRange();
                        min = Math.min(min, dr.getMinimum());
                        max = Math.max(max, dr.getMaximum());
                        mid += dr.getBaseline();
                    }
                    if ((mid /= (float)selectedTracks.size()) < min) {
                        mid = min;
                    } else if (mid > max) {
                        min = max;
                    }
                    DataRange prevAxisDefinition = new DataRange(min, mid, max, drawBaseline);
                    DataRangeDialog dlg = new DataRangeDialog(IGV.getMainFrame(), prevAxisDefinition);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        min = Math.min(dlg.getMax(), dlg.getMin());
                        max = Math.max(dlg.getMin(), dlg.getMax());
                        mid = dlg.getBase();
                        mid = Math.max(min, Math.min(mid, max));
                        DataRange axisDefinition = new DataRange(dlg.getMin(), dlg.getBase(), dlg.getMax());
                        for (Track track : selectedTracks) {
                            track.setDataRange(axisDefinition);
                            if (!(track instanceof DataTrack)) continue;
                            ((DataTrack)track).setAutoscale(false);
                        }
                        IGV.getInstance().repaint();
                    }
                }
            }
        });
        return item;
    }

    private static JMenuItem getDrawBorderItem() {
        final JCheckBoxMenuItem drawBorderItem = new JCheckBoxMenuItem("Draw borders");
        drawBorderItem.setSelected(FeatureTrack.isDrawBorder());
        drawBorderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTrack.setDrawBorder(drawBorderItem.isSelected());
                IGV.getInstance().repaintDataPanels();
            }
        });
        return drawBorderItem;
    }

    private static JMenuItem getLogScaleItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem logScaleItem = new JCheckBoxMenuItem("Log scale");
        boolean logScale = selectedTracks.iterator().next().getDataRange().isLog();
        logScaleItem.setSelected(logScale);
        logScaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataRange.Type scaleType = logScaleItem.isSelected() ? DataRange.Type.LOG : DataRange.Type.LINEAR;
                for (Track t : selectedTracks) {
                    t.getDataRange().setType(scaleType);
                }
                IGV.getInstance().repaintDataPanels();
            }
        });
        return logScaleItem;
    }

    private static JMenuItem getAutoscaleItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        if (selectedTracks.size() == 0) {
            autoscaleItem.setEnabled(false);
        } else {
            boolean autoScale = false;
            for (Track t : selectedTracks) {
                if (!(t instanceof DataTrack) || !((DataTrack)t).isAutoscale()) continue;
                autoScale = true;
                break;
            }
            autoscaleItem.setSelected(autoScale);
            autoscaleItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean autoScale = autoscaleItem.isSelected();
                    for (Track t : selectedTracks) {
                        if (!(t instanceof DataTrack)) continue;
                        ((DataTrack)t).setAutoscale(autoScale);
                    }
                    IGV.getInstance().repaintDataPanels();
                }
            });
        }
        return autoscaleItem;
    }

    private static JMenuItem getShowDataRangeItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Data Range");
        if (selectedTracks.size() == 0) {
            item.setEnabled(false);
        } else {
            boolean showDataRange = true;
            for (Track t : selectedTracks) {
                if (t.isShowDataRange()) continue;
                showDataRange = false;
                break;
            }
            item.setSelected(showDataRange);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean showDataRange = item.isSelected();
                    for (Track t : selectedTracks) {
                        if (!(t instanceof DataTrack)) continue;
                        ((DataTrack)t).setShowDataRange(showDataRange);
                    }
                    IGV.getInstance().repaintDataPanels();
                }
            });
        }
        return item;
    }

    public static void addDisplayModeItems(final Collection<Track> tracks, JPopupMenu menu) {
        int expCount = 0;
        int sqCount = 0;
        int collCount = 0;
        for (Track track : tracks) {
            switch (track.getDisplayMode()) {
                case EXPANDED: {
                    ++expCount;
                    break;
                }
                case SQUISHED: {
                    ++sqCount;
                    break;
                }
                case COLLAPSED: {
                    ++collCount;
                }
            }
        }
        Track.DisplayMode currentMode = null;
        currentMode = expCount > sqCount && expCount > collCount ? Track.DisplayMode.EXPANDED : (sqCount > expCount && sqCount > collCount ? Track.DisplayMode.SQUISHED : Track.DisplayMode.COLLAPSED);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem m1 = new JRadioButtonMenuItem("Expanded");
        m1.setSelected(currentMode == Track.DisplayMode.EXPANDED);
        m1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.setTrackDisplayMode(tracks, Track.DisplayMode.EXPANDED);
                TrackMenuUtils.refresh();
            }
        });
        JRadioButtonMenuItem m2 = new JRadioButtonMenuItem("Squished");
        m2.setSelected(currentMode == Track.DisplayMode.SQUISHED);
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.setTrackDisplayMode(tracks, Track.DisplayMode.SQUISHED);
                TrackMenuUtils.refresh();
            }
        });
        JRadioButtonMenuItem m3 = new JRadioButtonMenuItem("Collapsed");
        m3.setSelected(currentMode == Track.DisplayMode.COLLAPSED);
        m3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.setTrackDisplayMode(tracks, Track.DisplayMode.COLLAPSED);
                TrackMenuUtils.refresh();
            }
        });
        group.add(m1);
        group.add(m2);
        group.add(m3);
        menu.add(m3);
        menu.add(m2);
        menu.add(m1);
    }

    private static void setTrackDisplayMode(Collection<Track> tracks, Track.DisplayMode mode) {
        for (Track t : tracks) {
            t.setDisplayMode(mode);
        }
    }

    public static JMenuItem getRemoveMenuItem(final Collection<Track> selectedTracks) {
        boolean multiple = selectedTracks.size() > 1;
        JMenuItem item = new JMenuItem("Remove Track" + (multiple ? "s" : ""));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedTracks.isEmpty()) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (Track track : selectedTracks) {
                    buffer.append("\n\t");
                    buffer.append(track.getName());
                }
                String deleteItems = buffer.toString();
                JTextArea textArea = new JTextArea();
                textArea.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(textArea);
                textArea.setText(deleteItems);
                JOptionPane optionPane = new JOptionPane(scrollPane, -1, 0);
                optionPane.setPreferredSize(new Dimension(550, 500));
                JDialog dialog = optionPane.createDialog(IGV.getMainFrame(), "Remove The Following Tracks");
                dialog.setVisible(true);
                Object choice = optionPane.getValue();
                if (choice == null || 0 != (Integer)choice) {
                    return;
                }
                IGV.getInstance().getTrackManager().removeTracks(selectedTracks);
                IGV.getInstance().doRefresh();
            }
        });
        return item;
    }

    public static void changeRenderer(Collection<Track> selectedTracks, Class rendererClass) {
        for (Track track : selectedTracks) {
            if (track.getTrackType() == TrackType.RNAI && rendererClass == BarChartRenderer.class) {
                rendererClass = RNAiBarChartRenderer.class;
            }
            track.setRendererClass(rendererClass);
        }
        TrackMenuUtils.refresh();
    }

    public static void renameTrack(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Track t = selectedTracks.iterator().next();
        String newName = JOptionPane.showInputDialog(IGV.getMainFrame(), "Enter new name: ", t.getName());
        if (newName == null || newName.trim() == "") {
            return;
        }
        t.setName(newName);
        TrackMenuUtils.refresh();
    }

    public static void changeTrackHeight(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        String parameter = "Track height";
        int value = TrackMenuUtils.getIntValue("Track height", TrackMenuUtils.getRepresentativeTrackHeight(selectedTracks));
        if (value == Integer.MIN_VALUE) {
            return;
        }
        value = Math.max(0, value);
        for (Track track : selectedTracks) {
            track.setHeight(value);
        }
        TrackMenuUtils.refresh();
    }

    public static void changeFeatureVisibilityWindow(Collection<Track> selectedTracks) {
        ArrayList<Track> featureTracks = new ArrayList<Track>(selectedTracks.size());
        for (Track t : selectedTracks) {
            if (!(t instanceof FeatureTrack)) continue;
            featureTracks.add(t);
        }
        if (featureTracks.isEmpty()) {
            return;
        }
        int origValue = ((Track)featureTracks.iterator().next()).getVisibilityWindow();
        int origValueKB = Math.max(1, origValue / 1000);
        int value = TrackMenuUtils.getIntValue("Visibility window (kb)", origValueKB);
        if (value == Integer.MIN_VALUE) {
            return;
        }
        for (Track track : featureTracks) {
            track.setVisibilityWindow(value * 1000);
        }
        TrackMenuUtils.refresh();
    }

    public static void changeFontSize(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        String parameter = "Font size";
        int defaultValue = selectedTracks.iterator().next().getFontSize();
        int value = TrackMenuUtils.getIntValue("Font size", defaultValue);
        if (value == Integer.MIN_VALUE) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setFontSize(value);
        }
        TrackMenuUtils.refresh();
    }

    public static int getIntValue(String parameter, int value) {
        String height;
        while ((height = JOptionPane.showInputDialog(IGV.getMainFrame(), parameter + ": ", String.valueOf(value))) != null && !height.trim().equals("")) {
            try {
                value = Integer.parseInt(height);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), parameter + " must be an integer number.");
                continue;
            }
            break;
        }
        return Integer.MIN_VALUE;
    }

    public static void changeTrackColor(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Color currentSelection = selectedTracks.iterator().next().getColor();
        Color color = UIUtilities.showColorChooserDialog("Select Track Color (Positive Values)", currentSelection);
        if (color != null) {
            for (Track track : selectedTracks) {
                track.setColor(color);
            }
            TrackMenuUtils.refresh();
        }
    }

    public static void changeAltTrackColor(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Color currentSelection = selectedTracks.iterator().next().getColor();
        Color color = UIUtilities.showColorChooserDialog("Select Track Color (Negative Values)", currentSelection);
        if (color == null) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setAltColor(color);
        }
        TrackMenuUtils.refresh();
    }

    public static JMenuItem getCopyDetailsItem(final Feature f2, final TrackClickEvent evt) {
        JMenuItem item = new JMenuItem("Copy Details to Clipboard");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String details;
                ReferenceFrame frame = evt.getFrame();
                int mouseX = evt.getMouseEvent().getX();
                double location = frame.getChromosomePosition(mouseX);
                if (f2 instanceof IGVFeature && (details = ((IGVFeature)f2).getValueString(location, null)) != null) {
                    details = details.replace("<br>", System.getProperty("line.separator"));
                    details = details + System.getProperty("line.separator") + f2.getChr() + ":" + (f2.getStart() + 1) + "-" + f2.getEnd();
                    StringSelection stringSelection = new StringSelection(details);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        return item;
    }

    public static JMenuItem getCopySequenceItem(final Feature f2) {
        JMenuItem item = new JMenuItem("Copy Sequence");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int end;
                int start;
                String chr;
                Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
                byte[] seqBytes = genome.getSequence(chr = f2.getChr(), start = f2.getStart(), end = f2.getEnd());
                if (seqBytes == null) {
                    MessageUtils.showMessage("Sequence not available");
                } else {
                    String sequence = new String(seqBytes);
                    StringSelection stringSelection = new StringSelection(sequence);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        return item;
    }

    public static int getRepresentativeTrackHeight(Collection<Track> tracks) {
        double[] heights = new double[tracks.size()];
        int i2 = 0;
        for (Track track : tracks) {
            heights[i2] = track.getHeight();
            ++i2;
        }
        int medianTrackHeight = (int)Math.round(StatUtils.percentile(heights, 50.0));
        if (medianTrackHeight > 0) {
            return medianTrackHeight;
        }
        return PreferenceManager.getInstance().getAsInt("15");
    }

    public static void refresh() {
        IGV.getInstance().showLoadedTrackCount();
        IGV.getInstance().doRefresh();
    }

    public static JMenuItem getChangeTrackHeightItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Change Track Height...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeTrackHeight(selectedTracks);
            }
        });
        return item;
    }

    public static JMenuItem getChangeKMPlotItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Kaplan-Meier Plot...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KMPlotFrame frame = new KMPlotFrame(selectedTracks);
                frame.setVisible(true);
            }
        });
        return item;
    }

    public static JMenuItem getChangeFeatureWindow(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Feature Visibility Window...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeFeatureVisibilityWindow(selectedTracks);
            }
        });
        return item;
    }

    public static JMenuItem getChangeFontSizeItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Change Font Size...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeFontSize(selectedTracks);
            }
        });
        return item;
    }
}

