/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.gs.dm.DMUtils;
import org.broad.igv.gs.dm.GSDirectoryListing;
import org.broad.igv.gs.dm.GSFileMetadata;
import org.broad.igv.ui.util.MessageUtils;
import org.json.JSONException;

public class GSFileBrowser
extends JDialog {
    private GSDirectoryListing dirListing;
    private static Logger log = Logger.getLogger(GSFileBrowser.class);
    static ImageIcon folderIcon;
    static ImageIcon fileIcon;
    static GSFileMetadata selectedFile;
    Mode mode = Mode.OPEN;
    String userRootUrl = null;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JPanel hSpacer2;
    private JButton newFolderButton;
    private JPanel hSpacer1;
    private JButton cancelButton;
    private JButton openButton;
    private JPanel savePanel;
    private JLabel label2;
    private JTextField selectedFileTextField;
    private JPanel splitPane1;
    private JScrollPane scrollPane1;
    private JList fileList;
    private JLabel label1;

    public static void main(String[] args) throws IOException, JSONException {
        GSFileBrowser fb = new GSFileBrowser(null, Mode.SAVE);
        fb.setVisible(true);
        System.out.println(fb.getPath());
    }

    public GSFileBrowser(Frame owner) throws IOException, JSONException {
        this(owner, Mode.OPEN);
    }

    public GSFileBrowser(Frame owner, Mode mode) throws IOException, JSONException {
        super(owner);
        this.setModal(true);
        this.initComponents();
        this.init();
        this.fileList.setSelectionMode(0);
        this.mode = mode;
        this.savePanel.setVisible(mode == Mode.SAVE);
        this.newFolderButton.setVisible(mode == Mode.SAVE);
        this.openButton.setText(mode == Mode.OPEN ? "Open" : "Save");
        this.getRootPane().setDefaultButton(this.openButton);
    }

    void init() throws JSONException, IOException {
        if (folderIcon == null) {
            folderIcon = new ImageIcon(this.getClass().getResource("/images/Folder-icon.png"));
            fileIcon = new ImageIcon(this.getClass().getResource("/images/file-document.png"));
        }
        this.fileList.setCellRenderer(new CellRenderer());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                int index = GSFileBrowser.this.fileList.locationToIndex(e2.getPoint());
                GSFileMetadata md = (GSFileMetadata)GSFileBrowser.this.fileList.getModel().getElementAt(index);
                GSFileBrowser.this.setSelectedFile(md);
                if (e2.getClickCount() == 2) {
                    if (md.isDirectory()) {
                        try {
                            GSFileBrowser.this.fetchContents(new URL(md.getUrl()));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (JSONException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        GSFileBrowser.this.setVisible(false);
                    }
                }
            }
        };
        this.fileList.addMouseListener(mouseListener);
        URL defaultURL = new URL(GSUtils.dmServer + "defaultdirectory");
        this.fetchContents(defaultURL);
    }

    private void setSelectedFile(GSFileMetadata md) {
        selectedFile = md;
        if (md.isDirectory()) {
            this.selectedFileTextField.setText(null);
        } else {
            this.selectedFileTextField.setText(md.getName());
        }
    }

    public String getFileURL() {
        return selectedFile == null ? null : selectedFile.getUrl();
    }

    public String getPath() {
        if (selectedFile == null) {
            return null;
        }
        if (selectedFile.isDirectory()) {
            if (this.mode == Mode.OPEN) {
                return null;
            }
            return selectedFile.getPath() + "/" + this.selectedFileTextField.getText();
        }
        return selectedFile.getPath();
    }

    private void fetchContents(URL url) throws IOException, JSONException {
        this.dirListing = DMUtils.getDirectoryListing(url);
        String dirUrlString = this.dirListing.getDirectory().getUrl();
        this.setTitle(dirUrlString);
        if (this.userRootUrl == null) {
            this.userRootUrl = dirUrlString;
            int idx = this.userRootUrl.lastIndexOf("/");
            String user = this.userRootUrl.substring(idx).replace("/", "");
            GSFileMetadata rootMD = new GSFileMetadata(".", "/users/" + user, this.userRootUrl, "", "", true);
            this.setSelectedFile(rootMD);
        }
        List<GSFileMetadata> elements = this.dirListing.getContents();
        if (!dirUrlString.equals(this.userRootUrl)) {
            int lastSlashIdx = dirUrlString.lastIndexOf("/");
            String parentURL = dirUrlString.substring(0, lastSlashIdx);
            elements.add(0, new GSFileMetadata("Parent Directory", "", parentURL, "", "", true));
        }
        ListModel model = new ListModel(this.dirListing.getContents());
        this.fileList.setModel(model);
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        selectedFile = null;
        this.setVisible(false);
        this.dispose();
    }

    private void loadButtonActionPerformed(ActionEvent e2) {
        try {
            GSFileMetadata md;
            Object[] selections = this.fileList.getSelectedValues();
            if (selections.length == 1 && (md = (GSFileMetadata)selections[0]).isDirectory()) {
                this.fetchContents(new URL(md.getUrl()));
                return;
            }
            for (Object obj : selections) {
                if (!(obj instanceof GSFileMetadata)) continue;
                GSFileMetadata md2 = (GSFileMetadata)obj;
                if (this.mode != Mode.OPEN || md2.isDirectory()) continue;
                selectedFile = md2;
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception e1) {
            log.error("Error loading GS files", e1);
            MessageUtils.showMessage("Error: " + e1.toString());
        }
    }

    private void newFolderButtonActionPerformed(ActionEvent e2) {
        String folderName = MessageUtils.showInputDialog("Name of new folder:");
        if (folderName != null && folderName.length() > 0) {
            String dirurl = selectedFile.getUrl();
            if (!selectedFile.isDirectory()) {
                int idx = dirurl.lastIndexOf("/");
                dirurl = dirurl.substring(0, idx);
            }
            String putURL = dirurl + "/" + folderName;
            try {
                GSFileMetadata metaData = DMUtils.createDirectory(putURL);
                if (metaData != null) {
                    this.setSelectedFile(metaData);
                }
                this.fetchContents(new URL(putURL));
            }
            catch (IOException e1) {
                log.error("Error creating directory: " + putURL, e1);
                MessageUtils.showMessage("<html>Error creating directory: " + e1 + "<br>" + e1.getMessage());
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.hSpacer2 = new JPanel(null);
        this.newFolderButton = new JButton();
        this.hSpacer1 = new JPanel(null);
        this.cancelButton = new JButton();
        this.openButton = new JButton();
        this.savePanel = new JPanel();
        this.label2 = new JLabel();
        this.selectedFileTextField = new JTextField();
        this.splitPane1 = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.fileList = new JList();
        this.label1 = new JLabel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new BoxLayout(this.buttonBar, 0));
        this.buttonBar.add(this.hSpacer2);
        this.newFolderButton.setText("New Folder");
        this.newFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSFileBrowser.this.newFolderButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add(this.newFolderButton);
        this.buttonBar.add(this.hSpacer1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSFileBrowser.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add(this.cancelButton);
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSFileBrowser.this.loadButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add(this.openButton);
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.savePanel.setVisible(false);
        this.savePanel.setLayout(new BoxLayout(this.savePanel, 0));
        this.label2.setText("Save As: ");
        this.savePanel.add(this.label2);
        this.savePanel.add(this.selectedFileTextField);
        this.dialogPane.add((Component)this.savePanel, "North");
        this.splitPane1.setLayout(new BoxLayout(this.splitPane1, 1));
        this.scrollPane1.setViewportView(this.fileList);
        this.splitPane1.add(this.scrollPane1);
        this.label1.setHorizontalAlignment(0);
        this.label1.setIcon(new ImageIcon(this.getClass().getResource("/images/genomespacelogo.png")));
        this.splitPane1.add(this.label1);
        this.dialogPane.add((Component)this.splitPane1, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(490, 530);
        this.setLocationRelativeTo(this.getOwner());
    }

    static class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            GSFileMetadata fileElement = (GSFileMetadata)value;
            String s = value.toString();
            this.setText(s);
            this.setIcon(fileElement.isDirectory() ? folderIcon : fileIcon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    static class ListModel
    extends AbstractListModel {
        List<GSFileMetadata> elements;

        ListModel(List<GSFileMetadata> elements) {
            this.elements = elements;
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        @Override
        public Object getElementAt(int i2) {
            return this.elements.get(i2);
        }
    }

    public static enum Mode {
        OPEN,
        SAVE;

    }
}

