/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.BumpMap;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class DiffuseLightingRed
extends AbstractRed {
    private double kd;
    private Light light;
    private BumpMap bumpMap;
    private double scaleX;
    private double scaleY;
    private Rectangle litRegion;
    private boolean linear;

    public DiffuseLightingRed(double kd, Light light, BumpMap bumpMap, Rectangle litRegion, double scaleX, double scaleY, boolean linear) {
        this.kd = kd;
        this.light = light;
        this.bumpMap = bumpMap;
        this.litRegion = litRegion;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.linear = linear;
        ColorModel cm = linear ? GraphicsUtil.Linear_sRGB_Pre : GraphicsUtil.sRGB_Pre;
        SampleModel sm = cm.createCompatibleSampleModel(litRegion.width, litRegion.height);
        this.init((CachableRed)null, litRegion, cm, sm, litRegion.x, litRegion.y, null);
    }

    public WritableRaster copyData(WritableRaster wr) {
        double[] lightColor = this.light.getColor(this.linear);
        int w = wr.getWidth();
        int h2 = wr.getHeight();
        int minX = wr.getMinX();
        int minY = wr.getMinY();
        DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
        int[] pixels = db.getBankData()[0];
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)wr.getSampleModel();
        int offset = db.getOffset() + sppsm.getOffset(minX - wr.getSampleModelTranslateX(), minY - wr.getSampleModelTranslateY());
        int scanStride = sppsm.getScanlineStride();
        int adjust = scanStride - w;
        int p2 = offset;
        int r = 0;
        int g2 = 0;
        int b2 = 0;
        int i2 = 0;
        int j2 = 0;
        double x = this.scaleX * (double)minX;
        double y = this.scaleY * (double)minY;
        double NL = 0.0;
        double[][][] NA = this.bumpMap.getNormalArray(minX, minY, w, h2);
        if (!this.light.isConstant()) {
            double[][] LA = new double[w][3];
            i2 = 0;
            while (i2 < h2) {
                double[][] NR = NA[i2];
                this.light.getLightRow(x, y + (double)i2 * this.scaleY, this.scaleX, w, NR, LA);
                j2 = 0;
                while (j2 < w) {
                    double[] N = NR[j2];
                    double[] L = LA[j2];
                    NL = 255.0 * this.kd * (N[0] * L[0] + N[1] * L[1] + N[2] * L[2]);
                    r = (int)(NL * lightColor[0]);
                    g2 = (int)(NL * lightColor[1]);
                    b2 = (int)(NL * lightColor[2]);
                    if ((r & 0xFFFFFF00) != 0) {
                        int n2 = r = (r & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((g2 & 0xFFFFFF00) != 0) {
                        int n3 = g2 = (g2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((b2 & 0xFFFFFF00) != 0) {
                        b2 = (b2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    pixels[p2++] = 0xFF000000 | r << 16 | g2 << 8 | b2;
                    ++j2;
                }
                p2 += adjust;
                ++i2;
            }
        } else {
            double[] L = new double[3];
            this.light.getLight(0.0, 0.0, 0.0, L);
            i2 = 0;
            while (i2 < h2) {
                double[][] NR = NA[i2];
                j2 = 0;
                while (j2 < w) {
                    double[] N = NR[j2];
                    NL = 255.0 * this.kd * (N[0] * L[0] + N[1] * L[1] + N[2] * L[2]);
                    r = (int)(NL * lightColor[0]);
                    g2 = (int)(NL * lightColor[1]);
                    b2 = (int)(NL * lightColor[2]);
                    if ((r & 0xFFFFFF00) != 0) {
                        int n4 = r = (r & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((g2 & 0xFFFFFF00) != 0) {
                        int n5 = g2 = (g2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((b2 & 0xFFFFFF00) != 0) {
                        b2 = (b2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    pixels[p2++] = 0xFF000000 | r << 16 | g2 << 8 | b2;
                    ++j2;
                }
                p2 += adjust;
                ++i2;
            }
        }
        return wr;
    }
}

