/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import java.util.Arrays;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.annotation.DiploidGenotype;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.gelitext.GeliTextFeature;
import org.broad.tribble.readers.LineReader;

public class GeliTextCodec
implements FeatureCodec {
    private String[] parts;

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public Feature decode(String line) {
        try {
            if (line.startsWith("#") || line.startsWith("@")) {
                return null;
            }
            this.parts = line.trim().split("\\s+");
            if (this.parts.length != 18) {
                throw new CodecLineParsingException("Invalid GeliTextFeature row found -- incorrect element count.  Expected 18, got " + this.parts.length + " line = " + line);
            }
            char[] x = this.parts[5].toUpperCase().toCharArray();
            Arrays.sort(x);
            String bestGenotype = new String(x);
            double[] genotypeLikelihoods = new double[10];
            int pieceIndex = 8;
            int offset = 0;
            while (pieceIndex < 18) {
                genotypeLikelihoods[offset] = Double.valueOf(this.parts[pieceIndex]);
                ++pieceIndex;
                ++offset;
            }
            return new GeliTextFeature(this.parts[0], Long.valueOf(this.parts[1]), Character.toUpperCase(this.parts[2].charAt(0)), Integer.valueOf(this.parts[3]), Integer.valueOf(this.parts[4]), DiploidGenotype.toDiploidGenotype(bestGenotype), Double.valueOf(this.parts[6]), Double.valueOf(this.parts[7]), genotypeLikelihoods);
        }
        catch (CodecLineParsingException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Unable to parse line " + line, e2);
        }
        catch (NumberFormatException e3) {
            e3.printStackTrace();
            throw new RuntimeException("Unable to parse line " + line, e3);
        }
    }

    public Class getFeatureType() {
        return GeliTextFeature.class;
    }

    @Override
    public Object readHeader(LineReader reader) {
        return null;
    }
}

