/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.Utilities;

public final class ZipArchiveWrapper {
    private static Logger logger = Logger.getLogger(Utilities.class);
    private File zipFile;
    private URL zipUrl;

    public ZipArchiveWrapper(File zipFile) throws FileNotFoundException, IOException {
        if (zipFile == null) {
            throw new FileNotFoundException("Zip file was null!");
        }
        this.zipFile = zipFile;
        this.zipUrl = zipFile.toURI().toURL();
    }

    public ZipIterator iterator() throws IOException {
        ZipIterator iterator = new ZipIterator(new ZipInputStream(IGVHttpClientUtils.openConnectionStream(this.zipUrl)));
        return iterator;
    }

    public int getEntryCount() throws IOException {
        ZipIterator iterator = new ZipIterator(new ZipInputStream(IGVHttpClientUtils.openConnectionStream(this.zipUrl)));
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
        }
        return count;
    }

    public class ZipIterator
    implements Iterator {
        private boolean firstTime = true;
        private ZipEntry zipEntry = null;
        ZipInputStream zipInputStream;

        public ZipIterator(ZipInputStream zipInputStream) {
            this.zipInputStream = zipInputStream;
        }

        @Override
        public boolean hasNext() {
            if (this.zipInputStream == null) {
                return false;
            }
            try {
                if (this.firstTime) {
                    this.firstTime = false;
                    this.zipEntry = this.zipInputStream.getNextEntry();
                    if (this.zipEntry == null) {
                        return false;
                    }
                } else {
                    if (this.zipEntry == null) {
                        return false;
                    }
                    this.zipEntry = this.zipInputStream.getNextEntry();
                    if (this.zipEntry == null) {
                        return false;
                    }
                }
            }
            catch (IOException e2) {
                logger.error("Zip entry error!", e2);
            }
            return true;
        }

        public ZipEntry next() {
            return this.zipEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public ZipInputStream getZipInputStream() {
            return this.zipInputStream;
        }

        public void close() {
            try {
                if (this.zipInputStream != null) {
                    this.zipInputStream.close();
                }
            }
            catch (IOException ex) {
                logger.warn("Error closing zip file " + ZipArchiveWrapper.this.zipFile.getAbsolutePath(), ex);
            }
        }
    }
}

