/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.SamQueryReaderFactory;
import org.broad.igv.tools.IgvTools;
import org.broad.igv.tools.PreprocessingException;

public class LaneCounter {
    public static void main(String[] args) throws IOException {
        Globals.setHeadless(true);
        Genome genome = IgvTools.loadGenome(args[0]);
        if (genome == null) {
            throw new PreprocessingException("Genome could not be loaded: hg18");
        }
        LaneCounter.run(genome, args[1], args[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Genome genome, String alignmentFileList, String queryInterval) {
        String[] tmp;
        String[] tokens = queryInterval.split(":");
        String chr = tokens[0];
        String[] tokens2 = tokens[1].split("-");
        int intervalStart = Integer.parseInt(tokens2[0]);
        int intervalEnd = Integer.parseInt(tokens2[1]);
        byte[] ref = genome.getSequence(chr, intervalStart, intervalEnd);
        for (String alignmentFile : tmp = alignmentFileList.split(",")) {
            System.out.println(alignmentFile + "   " + queryInterval);
            AlignmentQueryReader reader = null;
            CloseableIterator<Alignment> iter = null;
            try {
                reader = SamQueryReaderFactory.getReader(alignmentFile, true);
                iter = reader.query(chr, intervalStart, intervalEnd, false);
                HashMap<String, ReadGroupCount> counts = new HashMap<String, ReadGroupCount>();
                while (iter != null && iter.hasNext()) {
                    AlignmentBlock[] blocks;
                    Alignment alignment = (Alignment)iter.next();
                    if (!LaneCounter.passFilter(alignment)) continue;
                    if (alignment.getMappingQuality() == 0) {
                        // empty if block
                    }
                    if ((blocks = alignment.getAlignmentBlocks()) == null) continue;
                    int lastBlockEnd = -1;
                    for (AlignmentBlock block : blocks) {
                        if (block.isSoftClipped()) continue;
                        byte[] bases = block.getBases();
                        int blockStart = block.getStart();
                        int adjustedStart = block.getStart();
                        int adjustedEnd = block.getEnd();
                        for (int pos = adjustedStart; pos < adjustedEnd; ++pos) {
                            if (pos < intervalStart) continue;
                            if (pos >= intervalEnd) break;
                            int baseIdx = pos - blockStart;
                            if (bases == null || baseIdx < 0 || baseIdx >= bases.length) continue;
                            String rg = alignment.getReadGroup();
                            ReadGroupCount rgc = (ReadGroupCount)counts.get(rg);
                            if (rgc == null) {
                                rgc = new ReadGroupCount(rg);
                                counts.put(rg, rgc);
                            }
                            ++rgc.totalBases;
                            byte base = bases[baseIdx];
                            byte refBase = ref[pos - intervalStart];
                            if (base == refBase) continue;
                            ++rgc.mismatches;
                        }
                        lastBlockEnd = block.getEnd();
                    }
                }
                LaneCounter.outputReadCounts(counts);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                iter.close();
                try {
                    reader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    private static void outputReadCounts(Map<String, ReadGroupCount> counts) {
        for (ReadGroupCount rgc : counts.values()) {
            float percent = 100.0f * (float)rgc.mismatches / (float)rgc.totalBases;
            System.out.println(rgc.rg + "\t" + rgc.totalBases + "\t" + rgc.mismatches + "\t" + percent);
        }
    }

    private static boolean passFilter(Alignment alignment) {
        return alignment.isMapped() && !alignment.isDuplicate() && alignment.getMappingQuality() > 0 && !alignment.isVendorFailedRead();
    }

    static class ReadGroupCount {
        String rg;
        int totalBases = 0;
        int mismatches = 0;

        ReadGroupCount(String rg) {
            this.rg = rg;
        }
    }
}

