/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SeekableBufferedStream;
import net.sf.samtools.util.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.stream.SeekablePicardFtpStream;
import org.broad.igv.util.stream.SeekablePicardHTTPStream;

public class BAMHttpQueryReader
implements AlignmentQueryReader {
    static Logger log = Logger.getLogger(BAMHttpQueryReader.class);
    static Properties cachedEtags;
    URL url;
    SAMFileHeader header;
    File indexFile;
    SAMFileReader reader;
    static File cacheDirectory;
    static Properties tagCache;
    static Properties indexLookup;

    public BAMHttpQueryReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        this.url = new URL(locator.getPath());
        if (requireIndex) {
            this.indexFile = this.getIndexFile(this.url, locator.getIndexPath());
            if (this.indexFile == null) {
                throw new RuntimeException("Could not load index file for file: " + this.url.getPath());
            }
            SeekableBufferedStream ss = new SeekableBufferedStream(this.getSeekableStream(this.url));
            this.reader = new SAMFileReader(ss, this.indexFile, false);
        } else {
            InputStream is = IGVHttpClientUtils.openConnectionStream(this.url);
            this.reader = new SAMFileReader(new BufferedInputStream(is));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public SAMFileHeader getHeader() {
        if (this.header == null) {
            this.header = this.reader.getFileHeader();
        }
        return this.header;
    }

    @Override
    public boolean hasIndex() {
        return this.indexFile != null && this.indexFile.exists();
    }

    @Override
    public Set<String> getSequenceNames() {
        SAMFileHeader header = this.getHeader();
        if (header == null) {
            return null;
        }
        HashSet<String> seqNames = new HashSet<String>();
        List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                seqNames.add(chr);
            }
        }
        return seqNames;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        try {
            if (this.reader == null) {
                InputStream is = IGVHttpClientUtils.openConnectionStream(this.url);
                this.reader = new SAMFileReader(new BufferedInputStream(is));
            }
            return new WrappedIterator(this.reader.iterator());
        }
        catch (IOException e2) {
            log.error("Error creating iterator", e2);
            throw new RuntimeException(e2);
        }
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        try {
            if (this.reader == null) {
                SeekableBufferedStream ss = new SeekableBufferedStream(this.getSeekableStream(this.url));
                this.reader = new SAMFileReader(ss, this.indexFile, false);
            }
            SAMRecordIterator iter = this.reader.query(sequence, start, end, contained);
            return new WrappedIterator(iter);
        }
        catch (IOException e2) {
            log.error("Error opening SAM reader", e2);
            throw new RuntimeException("Error opening SAM reader", e2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SeekableStream getSeekableStream(URL url) throws IOException {
        void var3_6;
        String protocol = url.getProtocol().toLowerCase();
        Object var3_3 = null;
        if (protocol.equals("http") || protocol.equals("https")) {
            boolean useByteRange = IGVHttpClientUtils.useByteRange();
            if (!useByteRange) throw new RuntimeException("Byte-range requests are disabled.  HTTP and FTP access to BAM files require byte-range support.");
            SeekablePicardHTTPStream seekablePicardHTTPStream = new SeekablePicardHTTPStream(url);
            return var3_6;
        } else {
            if (!protocol.equals("ftp")) throw new RuntimeException("Unknown protocol: " + protocol);
            SeekablePicardFtpStream seekablePicardFtpStream = new SeekablePicardFtpStream(url);
        }
        return var3_6;
    }

    File getIndexFile(URL url, String indexPath) throws IOException {
        String urlString = url.toString();
        String idxFilename = this.getTmpIndexFilename(urlString);
        this.indexFile = new File(this.getCacheDirectory(), idxFilename);
        if (this.indexFile.exists()) {
            this.indexFile.delete();
        }
        this.loadIndexFile(urlString, indexPath, this.indexFile);
        this.indexFile.deleteOnExit();
        return this.indexFile;
    }

    private String getTmpIndexFilename(String bamURL) {
        int tmp = bamURL.lastIndexOf("/");
        String prefix = tmp > 0 ? bamURL.substring(tmp + 1) : "index_";
        String indexName = prefix + System.currentTimeMillis() + ".bai";
        return indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndexFile(String path, String indexPath, File indexFile) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            String idx = indexPath != null && indexPath.length() > 0 ? indexPath : path + ".bai";
            URL indexURL = new URL(idx);
            os = new FileOutputStream(indexFile);
            try {
                is = IGVHttpClientUtils.openConnectionStream(indexURL);
            }
            catch (FileNotFoundException e2) {
                String baseName = path.substring(0, path.length() - 4);
                indexURL = new URL(baseName + ".bai");
                try {
                    is = IGVHttpClientUtils.openConnectionStream(indexURL);
                }
                catch (FileNotFoundException e1) {
                    MessageUtils.showMessage("Index file not found for file: " + path);
                    throw new DataLoadException("Index file not found for file: " + path, path);
                }
            }
            byte[] buf = new byte[512000];
            while ((bytesRead = is.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
    }

    static synchronized File getCacheDirectory() {
        File defaultDir;
        if (cacheDirectory == null && (defaultDir = Globals.getIgvDirectory()).exists() && !(cacheDirectory = new File(defaultDir, "bam")).exists()) {
            cacheDirectory.mkdir();
        }
        return cacheDirectory;
    }

    static synchronized Properties getTagCache() {
        if (tagCache == null) {
            tagCache = BAMHttpQueryReader.loadCachedProperties("etags");
        }
        return tagCache;
    }

    static synchronized Properties getIndexCache() {
        if (indexLookup == null) {
            indexLookup = BAMHttpQueryReader.loadCachedProperties("index");
        }
        return indexLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadCachedProperties(String name) {
        File propFile = new File(BAMHttpQueryReader.getCacheDirectory(), name);
        Properties props = new Properties();
        if (propFile.exists()) {
            FileInputStream reader = null;
            try {
                reader = new FileInputStream(propFile);
                props.load(reader);
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        ((InputStream)reader).close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCachedProperties(Properties props, String name) {
        OutputStream os = null;
        try {
            File propFile = new File(BAMHttpQueryReader.getCacheDirectory(), name);
            os = new FileOutputStream(propFile);
            props.store(os, null);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    static {
        cacheDirectory = null;
        tagCache = null;
        indexLookup = null;
    }
}

