/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JPanel;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.GenomeBuilderPane;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.OkCancelDialog;

public class GenomeBuilderDialog
extends OkCancelDialog {
    private GenomeBuilderPane builderPane;
    private File genomeArchiveFile = null;

    public GenomeBuilderDialog(IGV igv, boolean modal) {
        super(igv.getMainFrame(), modal);
        this.builderPane = new GenomeBuilderPane(igv);
        this.setTitle("Import Genome");
        this.setSize(800, 500);
        JPanel contentPane = this.getDialogPanel();
        contentPane.add(this.builderPane);
        this.setResizable(false);
        this.setLocationRelativeTo(igv.getMainFrame());
        this.setOkButtonText(" Save ");
    }

    public String getCytobandFileName() {
        return this.builderPane.getCytobandFileName();
    }

    public String getFastaFileName() {
        return this.builderPane.getFastaFileName();
    }

    public String getChrAliasFileName() {
        return this.builderPane.getChrAliasFileName();
    }

    public String getGenomeId() {
        return this.builderPane.getGenomeId();
    }

    public String getGenomeDisplayName() {
        return this.builderPane.getGenomeDisplayName();
    }

    public String getRefFlatFileName() {
        return this.builderPane.getRefFlatFileName();
    }

    public String getGenomeArchiveLocation() {
        return this.builderPane.getGenomeArchiveLocation();
    }

    public String getArchiveFileName() {
        return this.builderPane.getArchiveFileName();
    }

    public String getSequenceLocation() {
        String name = this.getFastaFileName();
        if (name != null && !name.trim().equals("")) {
            return this.getGenomeId();
        }
        return null;
    }

    public String getSequenceLocationOverride() {
        String seqLocation = this.builderPane.getSequenceURL();
        if (seqLocation == null && seqLocation.trim().length() == 0) {
            return null;
        }
        return seqLocation;
    }

    @Override
    public boolean cancelButtonClicked(ActionEvent event) {
        return true;
    }

    @Override
    public boolean okButtonClicked(ActionEvent event) {
        boolean isOk = this.builderPane.validateSelection();
        if (isOk) {
            this.genomeArchiveFile = Globals.IS_MAC ? this.builderPane.showGenomeArchiveDirectoryChooser() : this.builderPane.showGenomeArchiveDirectoryChooser();
            if (this.genomeArchiveFile == null) {
                isOk = false;
            }
        }
        return isOk;
    }
}

