/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.IOException;
import java.util.Set;
import org.broad.igv.feature.genome.FastaSequenceIndex;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class FastaSequence
implements Sequence {
    FastaSequenceIndex index;
    String path;
    long contentLength;

    public FastaSequence(String path) throws IOException {
        this.path = path;
        this.contentLength = ParsingUtils.getContentLength(path);
        String indexPath = path + ".fai";
        this.index = new FastaSequenceIndex(indexPath);
    }

    @Override
    public byte[] readSequence(String chr, int start, int end) {
        FastaSequenceIndex.FastaSequenceIndexEntry idxEntry = this.index.getIndexEntry(chr);
        if (idxEntry == null) {
            return null;
        }
        try {
            int nBases;
            int bytesPerLine = idxEntry.getBytesPerLine();
            int basesPerLine = idxEntry.getBasesPerLine();
            int nEndBytes = bytesPerLine - basesPerLine;
            int startLine = start / basesPerLine;
            int endLine = end / basesPerLine;
            int base0 = startLine * basesPerLine;
            int offset = start - base0;
            long position = idxEntry.getPosition();
            long startByte = position + (long)(startLine * bytesPerLine) + (long)offset;
            int base1 = endLine * basesPerLine;
            int offset1 = end - base1;
            long endByte = Math.min(this.contentLength, position + (long)(endLine * bytesPerLine) + (long)offset1);
            byte[] allBytes = this.readBytes(startByte, endByte);
            byte[] seqBytes = new byte[end - start];
            int srcPos = 0;
            int desPos = 0;
            if (offset > 0) {
                nBases = Math.min(end - start, basesPerLine - offset);
                System.arraycopy(allBytes, srcPos, seqBytes, desPos, nBases);
                srcPos += nBases + nEndBytes;
                desPos += nBases;
            }
            nBases = Math.min(basesPerLine, allBytes.length - srcPos);
            while (srcPos < allBytes.length) {
                System.arraycopy(allBytes, srcPos, seqBytes, desPos, nBases);
                srcPos += nBases + nEndBytes;
                desPos += nBases;
            }
            return seqBytes;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(long posStart, long posEnd) throws IOException {
        SeekableStream ss = null;
        try {
            ss = SeekableStreamFactory.getStreamFor(this.path);
            int nBytes = (int)(posEnd - posStart);
            byte[] bytes = new byte[nBytes];
            ss.seek(posStart);
            ss.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (ss != null) {
                ss.close();
            }
        }
    }

    public Set<String> getChromosomeNames() {
        return this.index.getContigs();
    }

    public int getChromosomeLength(String chrname) {
        return this.index.getContigSize(chrname);
    }
}

