/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeItem;

public class RPTreeLeafNode
implements RPTreeNode {
    private static Logger log = Logger.getLogger(RPTreeLeafNode.class);
    private RPChromosomeRegion chromosomeBounds;
    private ArrayList<RPTreeLeafNodeItem> leafItems = new ArrayList();

    public RPTreeLeafNode() {
        this.chromosomeBounds = new RPChromosomeRegion();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    @Override
    public int compareRegions(RPChromosomeRegion chromosomeRegion) {
        int value = this.chromosomeBounds.compareRegions(chromosomeRegion);
        return value;
    }

    @Override
    public int getItemCount() {
        return this.leafItems.size();
    }

    @Override
    public RPTreeNodeItem getItem(int index) {
        if (index < 0 || index >= this.leafItems.size()) {
            return null;
        }
        return this.leafItems.get(index);
    }

    @Override
    public boolean insertItem(RPTreeNodeItem item) {
        RPTreeLeafNodeItem newItem = (RPTreeLeafNodeItem)item;
        this.leafItems.add(newItem);
        this.chromosomeBounds = this.chromosomeBounds == null ? new RPChromosomeRegion(newItem.getChromosomeBounds()) : this.chromosomeBounds.getExtremes(newItem.getChromosomeBounds());
        return true;
    }

    @Override
    public boolean deleteItem(int index) {
        int itemCount = this.getItemCount();
        if (index < 0 || index >= itemCount) {
            return false;
        }
        this.leafItems.remove(index);
        return true;
    }

    @Override
    public void printItems() {
        log.debug("Leaf Node contains " + this.leafItems.size() + " items:");
        for (int item = 0; item < this.leafItems.size(); ++item) {
            this.leafItems.get(item).print();
        }
    }
}

