/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class Semaphore
implements Sync {
    protected long permits_;

    public Semaphore(long l2) {
        this.permits_ = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.permits_ <= 0L) {
                    this.wait();
                }
                --this.permits_;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    public boolean attempt(long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.permits_ > 0L) {
                --this.permits_;
                return true;
            }
            if (l2 <= 0L) {
                return false;
            }
            try {
                long l3 = System.currentTimeMillis();
                long l4 = l2;
                do {
                    this.wait(l4);
                    if (this.permits_ <= 0L) continue;
                    --this.permits_;
                    return true;
                } while ((l4 = l2 - (System.currentTimeMillis() - l3)) > 0L);
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    public synchronized void release() {
        ++this.permits_;
        this.notify();
    }

    public synchronized void release(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        this.permits_ += l2;
        for (long i2 = 0L; i2 < l2; ++i2) {
            this.notify();
        }
    }

    public synchronized long permits() {
        return this.permits_;
    }
}

