/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.AttributePanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.util.MessageUtils;

public class RegionNavigatorDialog
extends JDialog
implements Observer {
    private static Logger log = Logger.getLogger(AttributePanel.class);
    private static final int TABLE_COLINDEX_CHR = 0;
    private static final int TABLE_COLINDEX_START = 1;
    private static final int TABLE_COLINDEX_END = 2;
    private static final int TABLE_COLINDEX_DESC = 3;
    public static RegionNavigatorDialog activeInstance;
    private DefaultTableModel regionTableModel;
    private TableRowSorter<TableModel> regionTableRowSorter;
    private boolean synchingRegions = false;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JTable regionTable;
    private JPanel panel1;
    private JTextField textFieldSearch;
    private JLabel label1;
    private JButton button1;
    private JPanel panel2;
    private JButton buttonAddRegion;
    private JButton button2;
    private JPanel panel3;
    private JCheckBox checkBoxZoomWhenNav;
    private JCheckBox checkBoxShowAllChrs;
    private CancelAction cancelAction;
    private AddRegionAction addRegionAction;
    private RemoveSelectedRegionsAction actionRemoveRegions;
    private ShowAllChromosomesCheckboxAction showAllChromosomesCheckboxAction;

    public static RegionNavigatorDialog getActiveInstance() {
        return activeInstance;
    }

    public static boolean destroyActiveInstance() {
        if (activeInstance == null) {
            return false;
        }
        activeInstance.dispose();
        activeInstance = null;
        return true;
    }

    public RegionNavigatorDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.postInit();
    }

    public RegionNavigatorDialog(Dialog owner) {
        super(owner);
        this.initComponents();
        this.postInit();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.synchRegions();
    }

    public void synchRegions() {
        this.synchingRegions = true;
        List<RegionOfInterest> regions = this.retrieveRegionsAsList();
        this.regionTableModel = (DefaultTableModel)this.regionTable.getModel();
        while (this.regionTableModel.getRowCount() > 0) {
            this.regionTableModel.removeRow(0);
        }
        this.regionTableModel.setRowCount(regions.size());
        for (int i2 = 0; i2 < regions.size(); ++i2) {
            RegionOfInterest region = regions.get(i2);
            this.regionTableModel.setValueAt(region.getDescription(), i2, 3);
            this.regionTableModel.setValueAt(region.getDisplayStart(), i2, 1);
            this.regionTableModel.setValueAt(region.getDisplayEnd(), i2, 2);
            this.regionTableModel.setValueAt(region.getChr(), i2, 0);
        }
        this.synchingRegions = false;
        this.regionTableModel.fireTableDataChanged();
    }

    private List<RegionOfInterest> retrieveRegionsAsList() {
        return new ArrayList<RegionOfInterest>(IGV.getInstance().getSession().getAllRegionsOfInterest());
    }

    private void postInit() {
        this.regionTableModel = (DefaultTableModel)this.regionTable.getModel();
        this.regionTable.getSelectionModel().addListSelectionListener(new RegionTableSelectionListener());
        this.regionTableModel.addTableModelListener(new RegionTableModelListener());
        this.regionTableRowSorter = new TableRowSorter<DefaultTableModel>(this.regionTableModel);
        this.regionTable.setRowSorter(this.regionTableRowSorter);
        this.regionTableRowSorter.setRowFilter(new RegionRowFilter());
        this.textFieldSearch.getDocument().addDocumentListener(new SearchFieldDocumentListener());
        activeInstance = this;
        this.updateChromosomeDisplayed();
        this.synchRegions();
        IGV.getInstance().getSession().getRegionsOfInterestObservable().addObserver(this);
        int newTableHeight = Math.min(this.regionTableModel.getRowCount() + 1, 5) * this.regionTable.getRowHeight();
        int extraHeight = 225;
        int newDialogHeight = newTableHeight + extraHeight;
        if (newDialogHeight < this.getHeight()) {
            this.regionTable.setPreferredScrollableViewportSize(new Dimension(this.regionTable.getPreferredSize().width, newTableHeight));
            this.setSize(this.getWidth(), newTableHeight + extraHeight);
            this.update(this.getGraphics());
        }
        this.regionTable.addMouseListener(new RegionTablePopupHandler());
    }

    public void updateChromosomeDisplayed() {
        this.regionTableModel.fireTableDataChanged();
    }

    protected boolean shouldIncludeRegion(String regionChr, String regionDesc) {
        if (regionChr == null) {
            return false;
        }
        String filterStringLowercase = null;
        if (this.textFieldSearch.getText() != null) {
            filterStringLowercase = this.textFieldSearch.getText().toLowerCase();
        }
        String chr = FrameManager.getDefaultFrame().getChrName();
        if (!(filterStringLowercase == null || filterStringLowercase.isEmpty() || regionDesc != null && regionDesc.toLowerCase().contains(filterStringLowercase))) {
            return false;
        }
        if (this.checkBoxShowAllChrs.isSelected()) {
            return true;
        }
        return chr == null || chr.isEmpty() || regionChr.equals(chr);
    }

    public void updateROIsFromRegionTable() {
        for (int i2 = 0; i2 < this.regionTable.getRowSorter().getModelRowCount(); ++i2) {
            this.updateROIFromRegionTable(i2);
        }
    }

    public void updateROIFromRegionTable(int tableRow) {
        List<RegionOfInterest> regions = this.retrieveRegionsAsList();
        if (tableRow > this.regionTable.getRowCount() - 1) {
            return;
        }
        int rowIdx = 0;
        try {
            rowIdx = this.regionTable.getRowSorter().convertRowIndexToModel(tableRow);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return;
        }
        RegionOfInterest region = regions.get(rowIdx);
        Object descObject = this.regionTableModel.getValueAt(rowIdx, 3);
        if (descObject != null) {
            region.setDescription(descObject.toString());
        }
        int storeStartValue = Math.max(0, (Integer)this.regionTableModel.getValueAt(rowIdx, 1) - 1);
        region.setStart(storeStartValue);
        int storeEndValue = Math.max(0, (Integer)this.regionTableModel.getValueAt(rowIdx, 2) - 1);
        region.setEnd(storeEndValue);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.regionTable = new JTable();
        this.panel1 = new JPanel();
        this.textFieldSearch = new JTextField();
        this.label1 = new JLabel();
        this.button1 = new JButton();
        this.panel2 = new JPanel();
        this.buttonAddRegion = new JButton();
        this.button2 = new JButton();
        this.panel3 = new JPanel();
        this.checkBoxZoomWhenNav = new JCheckBox();
        this.checkBoxShowAllChrs = new JCheckBox();
        this.cancelAction = new CancelAction();
        this.addRegionAction = new AddRegionAction();
        this.actionRemoveRegions = new RemoveSelectedRegionsAction();
        this.showAllChromosomesCheckboxAction = new ShowAllChromosomesCheckboxAction();
        this.setTitle("Regions of Interest");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(null);
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.regionTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"Chr", "Start", "End", "Description"}){
            Class<?>[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{String.class, Integer.class, Integer.class, Object.class};
                this.columnEditable = new boolean[]{false, true, true, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        TableColumnModel cm = this.regionTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(50);
        cm.getColumn(1).setPreferredWidth(100);
        cm.getColumn(2).setPreferredWidth(100);
        cm.getColumn(3).setPreferredWidth(200);
        this.regionTable.setAutoCreateRowSorter(true);
        this.scrollPane1.setViewportView(this.regionTable);
        this.contentPanel.add((Component)this.scrollPane1, "Center");
        this.panel1.setLayout(new BorderLayout());
        this.textFieldSearch.setToolTipText("Search for regions containing the specified description text.");
        this.panel1.add((Component)this.textFieldSearch, "Center");
        this.label1.setText("Search");
        this.panel1.add((Component)this.label1, "West");
        this.button1.setAction(this.cancelAction);
        this.button1.setText("Clear Search");
        this.panel1.add((Component)this.button1, "East");
        this.panel2.setLayout(new BorderLayout());
        this.buttonAddRegion.setAction(this.addRegionAction);
        this.buttonAddRegion.setText("Add");
        this.panel2.add((Component)this.buttonAddRegion, "West");
        this.button2.setAction(this.actionRemoveRegions);
        this.button2.setText("Remove Selected");
        this.panel2.add((Component)this.button2, "Center");
        this.panel3.setLayout(new BorderLayout());
        this.checkBoxZoomWhenNav.setText("Zoom to Region");
        this.checkBoxZoomWhenNav.setToolTipText("When navigating to a region, change zoom level?");
        this.checkBoxZoomWhenNav.setSelected(true);
        this.panel3.add((Component)this.checkBoxZoomWhenNav, "Center");
        this.checkBoxShowAllChrs.setAction(this.showAllChromosomesCheckboxAction);
        this.checkBoxShowAllChrs.setToolTipText("View regions from all chromosomes (othrwise, current chromosome only)");
        this.checkBoxShowAllChrs.setSelected(true);
        this.panel3.add((Component)this.checkBoxShowAllChrs, "West");
        this.panel2.add((Component)this.panel3, "East");
        this.panel1.add((Component)this.panel2, "North");
        this.contentPanel.add((Component)this.panel1, "South");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class RegionTablePopupHandler
    extends MouseAdapter {
        private static final int MAX_SEQUENCE_LENGTH = 1000000;

        private RegionTablePopupHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (SwingUtilities.isRightMouseButton(e2)) {
                Point p2 = e2.getPoint();
                int row = RegionNavigatorDialog.this.regionTable.getRowSorter().convertRowIndexToModel(RegionNavigatorDialog.this.regionTable.rowAtPoint(p2));
                int col = RegionNavigatorDialog.this.regionTable.columnAtPoint(p2);
                if (row >= 0 && col >= 0) {
                    final String chr = (String)RegionNavigatorDialog.this.regionTableModel.getValueAt(row, 0);
                    final int start = (Integer)RegionNavigatorDialog.this.regionTableModel.getValueAt(row, 1) - 1;
                    final int end = (Integer)RegionNavigatorDialog.this.regionTableModel.getValueAt(row, 2) - 1;
                    final String desc = (String)RegionNavigatorDialog.this.regionTableModel.getValueAt(row, 3);
                    IGVPopupMenu popupMenu = new IGVPopupMenu();
                    JMenuItem copySequenceItem = new JMenuItem("Copy Sequence");
                    copySequenceItem.addActionListener(new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void actionPerformed(ActionEvent e2) {
                            int length = end - start;
                            if (length > 1000000) {
                                JOptionPane.showMessageDialog(RegionNavigatorDialog.this, "Region is to large to copy sequence data.");
                            } else {
                                try {
                                    RegionNavigatorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                                    String genomeId = IGV.getInstance().getGenomeManager().getGenomeId();
                                    byte[] seqBytes = SequenceManager.readSequence(genomeId, chr, start, end);
                                    if (seqBytes == null) {
                                        MessageUtils.showMessage("Sequence not available");
                                    } else {
                                        String sequence = new String(seqBytes);
                                        RegionTablePopupHandler.this.copyTextToClipboard(sequence);
                                    }
                                }
                                finally {
                                    RegionNavigatorDialog.this.setCursor(Cursor.getDefaultCursor());
                                }
                            }
                        }
                    });
                    popupMenu.add(copySequenceItem);
                    JMenuItem copyDetailsItem = new JMenuItem("Copy Details");
                    copyDetailsItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e2) {
                            String details = chr + ":" + start + "-" + end;
                            if (desc != null && !desc.isEmpty()) {
                                details = details + ", " + desc;
                            }
                            RegionTablePopupHandler.this.copyTextToClipboard(details);
                        }
                    });
                    popupMenu.add(copyDetailsItem);
                    popupMenu.show(RegionNavigatorDialog.this.regionTable, p2.x, p2.y);
                }
            }
        }

        private void copyTextToClipboard(String text) {
            StringSelection stringSelection = new StringSelection(text);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private class ShowAllChromosomesCheckboxAction
    extends AbstractAction {
        private ShowAllChromosomesCheckboxAction() {
            this.putValue("Name", "Show All Chrs");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            RegionNavigatorDialog.this.synchRegions();
        }
    }

    private class RemoveSelectedRegionsAction
    extends AbstractAction {
        private RemoveSelectedRegionsAction() {
            this.putValue("Name", "Remove");
            this.putValue("ShortDescription", "Remove all selected regions");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int[] selectedRows = RegionNavigatorDialog.this.regionTable.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                ArrayList<RegionOfInterest> selectedRegions = new ArrayList<RegionOfInterest>();
                List regions = RegionNavigatorDialog.this.retrieveRegionsAsList();
                for (int selectedRowIndex : selectedRows) {
                    int selectedModelRow = RegionNavigatorDialog.this.regionTableRowSorter.convertRowIndexToModel(selectedRowIndex);
                    selectedRegions.add((RegionOfInterest)regions.get(selectedModelRow));
                }
                RegionNavigatorDialog.this.regionTable.clearSelection();
                IGV.getInstance().getSession().removeRegionsOfInterest(selectedRegions);
            } else {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "No regions have been selected for removal.", "Error", 1);
            }
        }
    }

    private class AddRegionAction
    extends AbstractAction {
        private AddRegionAction() {
            this.putValue("Name", "Add Region");
            this.putValue("ShortDescription", "Add a new region");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            String chr = FrameManager.getDefaultFrame().getChrName();
            if (chr == null || chr.isEmpty()) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "No chromosome is specified. Can't create a region without a chromosome.", "Error", 1);
            } else if (chr.equalsIgnoreCase("All")) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "Regions cannot be created in the All Chromosomes view.", "Error", 1);
            } else {
                RegionOfInterest newRegion = new RegionOfInterest(FrameManager.getDefaultFrame().getChrName(), 1, 100, "");
                IGV.getInstance().getSession().addRegionOfInterestWithNoListeners(newRegion);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Clear search box");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            RegionNavigatorDialog.this.textFieldSearch.setText("");
        }
    }

    private class RegionTableSelectionListener
    implements ListSelectionListener {
        private RegionTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e2) {
            if (!e2.getValueIsAdjusting()) {
                List regions = RegionNavigatorDialog.this.retrieveRegionsAsList();
                int[] selectedRows = RegionNavigatorDialog.this.regionTable.getSelectedRows();
                if (selectedRows != null && selectedRows.length > 0 && regions.size() >= selectedRows.length) {
                    RegionOfInterest firstStartRegion = null;
                    RegionOfInterest lastEndRegion = null;
                    HashSet<String> selectedChrs = new HashSet<String>();
                    for (int selectedRowIndex : selectedRows) {
                        int selectedModelRow = RegionNavigatorDialog.this.regionTableRowSorter.convertRowIndexToModel(selectedRowIndex);
                        RegionOfInterest region = (RegionOfInterest)regions.get(selectedModelRow);
                        selectedChrs.add(region.getChr());
                        if (firstStartRegion == null || region.getStart() < firstStartRegion.getStart()) {
                            firstStartRegion = region;
                        }
                        if (lastEndRegion != null && region.getEnd() <= lastEndRegion.getEnd()) continue;
                        lastEndRegion = region;
                    }
                    if (selectedChrs.size() > 1) {
                        return;
                    }
                    if (RegionNavigatorDialog.this.checkBoxZoomWhenNav.isSelected()) {
                        int start = firstStartRegion.getStart() - (int)(0.2 * (double)firstStartRegion.getLength());
                        int end = lastEndRegion.getEnd() + (int)(0.2 * (double)lastEndRegion.getLength());
                        FrameManager.getDefaultFrame().jumpTo((String)selectedChrs.iterator().next(), start, end);
                    } else {
                        FrameManager.getDefaultFrame().centerOnLocation(firstStartRegion.getCenter());
                    }
                }
            }
        }
    }

    private class RegionTableModelListener
    implements TableModelListener {
        private RegionTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e2) {
            if (RegionNavigatorDialog.this.synchingRegions) {
                return;
            }
            List regions = RegionNavigatorDialog.this.retrieveRegionsAsList();
            int firstRow = e2.getFirstRow();
            if (firstRow > regions.size() - 1) {
                return;
            }
            for (int i2 = firstRow; i2 <= Math.max(firstRow, Math.min(RegionNavigatorDialog.this.regionTable.getRowCount(), e2.getLastRow())); ++i2) {
                RegionNavigatorDialog.this.updateROIFromRegionTable(i2);
            }
        }
    }

    private class RegionRowFilter
    extends RowFilter<TableModel, Object> {
        @Override
        public boolean include(RowFilter.Entry entry) {
            return RegionNavigatorDialog.this.shouldIncludeRegion((String)entry.getValue(0), (String)entry.getValue(3));
        }
    }

    private class SearchFieldDocumentListener
    implements DocumentListener {
        private SearchFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            System.err.println("This should not happen");
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            RegionNavigatorDialog.this.regionTableModel.fireTableDataChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            RegionNavigatorDialog.this.regionTableModel.fireTableDataChanged();
        }
    }
}

