/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.swing.JideSplitPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.batch.BatchRunner;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.feature.MaximumContigGenomeException;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.GenomeBuilderDialog;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.lists.GeneListManager;
import org.broad.igv.lists.Preloader;
import org.broad.igv.peaks.PeakCommandBar;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.IGVContentPane;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.Main;
import org.broad.igv.ui.PreferencesEditor;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.dnd.GhostGlassPane;
import org.broad.igv.ui.filefilters.AlignmentFileFilter;
import org.broad.igv.ui.filefilters.CoverageFileFilter;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.RegionNavigatorDialog;
import org.broad.igv.ui.panel.RegionOfInterestPanel;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.CheckListDialog;
import org.broad.igv.ui.util.FileChooser;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;

public class IGV {
    private static Logger log = Logger.getLogger(IGV.class);
    private static IGV theInstance;
    static List<IGV> instances;
    private Frame mainFrame;
    private JRootPane rootPane;
    private IGVContentPane contentPane;
    private IGVMenuBar menuBar;
    Component glassPane;
    GhostGlassPane dNdGlassPane;
    public static Cursor fistCursor;
    public static Cursor zoomInCursor;
    public static Cursor zoomOutCursor;
    public static Cursor dragNDropCursor;
    Session session;
    private TrackManager trackManager;
    private GenomeManager genomeManager;
    private FileChooserDialog trackFileChooser;
    private FileChooser snapshotFileChooser;
    private FileChooser genomeImportFileChooser;
    private LinkedList<String> recentSessionList = new LinkedList();
    private boolean isExportingSnapshot = false;
    private boolean startupComplete = false;
    JCheckBoxMenuItem showPeakMenuItem;
    PeakCommandBar peakCommandBar;

    public static IGV createInstance(Frame frame) {
        if (theInstance != null) {
            throw new RuntimeException("Only a single instance is allowed.");
        }
        theInstance = new IGV(frame);
        return theInstance;
    }

    public static IGV getInstance() {
        if (theInstance == null) {
            throw new RuntimeException("IGV has not been initialized.  Must call createInstance(Frame) first");
        }
        return theInstance;
    }

    public static IGV getFirstInstance() {
        if (instances.isEmpty()) {
            throw new RuntimeException("IGV has not been initialized.  Must call createInstance(Frame) first");
        }
        return instances.get(0);
    }

    public static boolean hasInstance() {
        return theInstance != null;
    }

    public static JRootPane getRootPane() {
        return IGV.getInstance().rootPane;
    }

    public static Frame getMainFrame() {
        return IGV.getInstance().mainFrame;
    }

    private IGV(Frame frame) {
        theInstance = this;
        instances.add(this);
        this.genomeManager = new GenomeManager(this);
        this.mainFrame = frame;
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                this.windowCloseEvent();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                this.windowCloseEvent();
            }

            private void windowCloseEvent() {
                instances.remove(this);
                PreferenceManager.getInstance().setApplicationFrameBounds(IGV.this.rootPane.getBounds());
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(false);
                IGVPopupMenu.closeAll();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(false);
                IGVPopupMenu.closeAll();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(true);
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        });
        this.session = new Session(null);
        this.trackManager = new TrackManager(this);
        this.createHandCursor();
        this.createZoomCursors();
        this.createDragAndDropCursor();
        this.mainFrame.setTitle("IGV");
        if (this.mainFrame instanceof JFrame) {
            JFrame jf = (JFrame)this.mainFrame;
            this.rootPane = jf.getRootPane();
        } else {
            this.rootPane = new JRootPane();
            this.mainFrame.add(this.rootPane);
        }
        this.contentPane = new IGVContentPane(this.trackManager);
        this.menuBar = new IGVMenuBar();
        this.rootPane.setContentPane(this.contentPane);
        this.rootPane.setJMenuBar(this.menuBar);
        this.glassPane = this.rootPane.getGlassPane();
        this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
        this.glassPane.addMouseListener(new MouseAdapter(){});
        this.dNdGlassPane = new GhostGlassPane();
        this.mainFrame.pack();
        this.initializeSnapshot();
        this.initializeDialogs();
        Dimension screenBounds = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle applicationBounds = PreferenceManager.getInstance().getApplicationFrameBounds();
        if (applicationBounds == null || applicationBounds.getMaxX() > screenBounds.getWidth() || applicationBounds.getMaxY() > screenBounds.getHeight()) {
            int width = Math.min(1150, (int)screenBounds.getWidth());
            int height = Math.min(800, (int)screenBounds.getHeight());
            applicationBounds = new Rectangle(0, 0, width, height);
        }
        this.mainFrame.setBounds(applicationBounds);
    }

    public void repaint() {
        this.mainFrame.repaint();
    }

    public GhostGlassPane getDnDGlassPane() {
        return this.dNdGlassPane;
    }

    public void startDnD() {
        this.rootPane.setGlassPane(this.dNdGlassPane);
        this.dNdGlassPane.setVisible(true);
    }

    public void endDnD() {
        this.rootPane.setGlassPane(this.glassPane);
        this.glassPane.setVisible(false);
    }

    public void setSelectedRegion(RegionOfInterest region) {
    }

    public Dimension getPreferredSize() {
        return UIConstants.preferredSize;
    }

    private void initializeDialogs() {
        this.trackFileChooser = new FileChooserDialog(this.mainFrame, true);
        this.trackFileChooser.addChoosableFileFilter(new AlignmentFileFilter());
        this.trackFileChooser.addChoosableFileFilter(new CoverageFileFilter());
        this.trackFileChooser.setFileFilter(this.trackFileChooser.getChoosableFileFilters()[0]);
    }

    public FileChooserDialog getTrackFileChooser() {
        return this.trackFileChooser;
    }

    private void initializeSnapshot() {
        File snapshotDirectory = PreferenceManager.getInstance().getLastSnapshotDirectory();
        FileFilter[] fileFilters = SnapshotUtilities.getAllSnapshotFileFilters();
        this.snapshotFileChooser = UIUtilities.getFileChooser(snapshotDirectory, null, fileFilters);
        this.snapshotFileChooser.setDialogTitle("Snapshot File");
        this.snapshotFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                File oldFile = null;
                String property = e2.getPropertyName();
                if ("SelectedFileChangedProperty".equals(property)) {
                    oldFile = (File)e2.getOldValue();
                    IGV.this.snapshotFileChooser.setPreviousFile(oldFile);
                } else if ("fileFilterChanged".equals(property) && e2.getOldValue() instanceof SnapshotUtilities.SnapshotFileFilter && e2.getNewValue() instanceof SnapshotUtilities.SnapshotFileFilter) {
                    SnapshotUtilities.SnapshotFileFilter newFilter = (SnapshotUtilities.SnapshotFileFilter)e2.getNewValue();
                    File currentDirectory = IGV.this.snapshotFileChooser.getCurrentDirectory();
                    File previousFile = IGV.this.snapshotFileChooser.getPreviousFile();
                    if (previousFile != null) {
                        File file = null;
                        file = currentDirectory != null ? new File(currentDirectory, previousFile.getName()) : previousFile;
                        final File selectedFile = Utilities.changeFileExtension(file, newFilter.getExtension());
                        UIUtilities.invokeOnEventThread(new Runnable(){

                            @Override
                            public void run() {
                                IGV.this.snapshotFileChooser.setSelectedFile(selectedFile);
                                IGV.this.snapshotFileChooser.validate();
                            }
                        });
                    }
                }
            }
        });
    }

    public void addRegionOfInterest(RegionOfInterest roi) {
        this.session.addRegionOfInterestWithNoListeners(roi);
        RegionOfInterestPanel.setSelectedRegion(roi);
        this.doRefresh();
    }

    void beginROI(JButton button) {
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            DataPanelContainer dpc = tsv.getDataPanel();
            for (Component c2 : dpc.getComponents()) {
                if (!(c2 instanceof DataPanel)) continue;
                DataPanel dp = (DataPanel)c2;
                RegionOfInterestTool regionOfInterestTool = new RegionOfInterestTool(dp, button);
                dp.setCurrentTool(regionOfInterestTool);
            }
        }
    }

    public void endROI() {
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            DataPanelContainer dp = tsv.getDataPanel();
            dp.setCurrentTool(null);
        }
    }

    public void chromosomeChangeEvent(String chrName) {
        this.chromosomeChangeEvent(chrName, true);
    }

    public void chromosomeChangeEvent(String chrName, boolean updateCommandBar) {
        this.contentPane.chromosomeChanged(chrName);
        this.repaintDataAndHeaderPanels(updateCommandBar);
    }

    public void repaintDataAndHeaderPanels() {
        this.repaintDataAndHeaderPanels(true);
    }

    public void repaintDataAndHeaderPanels(boolean updateCommandBar) {
        this.rootPane.repaint();
        if (updateCommandBar) {
            this.contentPane.updateCurrentCoordinates();
        }
    }

    public void repaintDataPanels() {
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            tsv.getDataPanel().repaint();
        }
    }

    public void repaintNamePanels() {
        for (TrackPanelScrollPane tsv : this.trackManager.getTrackPanelScrollPanes()) {
            tsv.getNamePanel().repaint();
        }
    }

    public void repaintStatusAndZoomSlider() {
        this.contentPane.getCommandBar().repaint();
    }

    public void selectGenomeFromList(String genome) {
        try {
            this.contentPane.getCommandBar().selectGenomeFromList(genome);
        }
        catch (FileNotFoundException e2) {
            log.error("File not found while intializing genome!", e2);
        }
        catch (NoRouteToHostException e3) {
            log.error("Error while intializing genome!", e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDefineGenome(ProgressMonitor monitor) {
        ProgressBar bar = null;
        File archiveFile = null;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            GenomeBuilderDialog genomeBuilderDialog = new GenomeBuilderDialog(this, true);
            genomeBuilderDialog.setVisible(true);
            if (genomeBuilderDialog.isCanceled()) {
                return;
            }
            if (monitor != null) {
                bar = ProgressBar.showProgressDialog(this.mainFrame, "Defining Genome...", monitor, false);
            }
            String genomeZipLocation = genomeBuilderDialog.getGenomeArchiveLocation();
            String cytobandFileName = genomeBuilderDialog.getCytobandFileName();
            String refFlatFileName = genomeBuilderDialog.getRefFlatFileName();
            String fastaFileName = genomeBuilderDialog.getFastaFileName();
            String chrAliasFile = genomeBuilderDialog.getChrAliasFileName();
            String relativeSequenceLocation = genomeBuilderDialog.getSequenceLocation();
            String seqLocationOverride = genomeBuilderDialog.getSequenceLocationOverride();
            String genomeDisplayName = genomeBuilderDialog.getGenomeDisplayName();
            String genomeId = genomeBuilderDialog.getGenomeId();
            String genomeFileName = genomeBuilderDialog.getArchiveFileName();
            GenomeManager.GenomeListItem genomeListItem = IGV.getInstance().getGenomeManager().defineGenome(genomeZipLocation, cytobandFileName, refFlatFileName, fastaFileName, chrAliasFile, relativeSequenceLocation, genomeDisplayName, genomeId, genomeFileName, monitor, seqLocationOverride);
            this.enableRemoveGenomes();
            this.contentPane.getCommandBar().addToUserDefinedGenomeItemList(genomeListItem);
            this.contentPane.getCommandBar().selectGenomeFromListWithNoImport(genomeListItem.getId());
            if (monitor != null) {
                monitor.fireProgressChange(100);
            }
        }
        catch (MaximumContigGenomeException e2) {
            String genomePath = "";
            if (archiveFile != null) {
                genomePath = archiveFile.getAbsolutePath();
            }
            log.error("Failed to define genome: " + genomePath, e2);
            JOptionPane.showMessageDialog(this.mainFrame, "Failed to define the current genome " + genomePath + "\n" + e2.getMessage());
        }
        catch (Exception e3) {
            String genomePath = "";
            if (archiveFile != null) {
                genomePath = archiveFile.getAbsolutePath();
            }
            log.error("Failed to define genome: " + genomePath, e3);
            MessageUtils.showMessage("Unexpected while importing a genome: " + e3.getMessage());
        }
        finally {
            if (bar != null) {
                bar.close();
            }
            WaitCursorManager.removeWaitCursor(token);
        }
    }

    public GenomeManager.GenomeListItem getGenomeSelectedInDropdown() {
        return this.contentPane.getCommandBar().getGenomeSelectedInDropdown();
    }

    public Collection<String> getGenomeDisplayNames() {
        return this.contentPane.getCommandBar().getGenomeDisplayNames();
    }

    public Collection<String> getGenomeIds() {
        return this.contentPane.getCommandBar().getGenomeIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenomeManager.GenomeListItem doLoadGenome(ProgressMonitor monitor) {
        ProgressBar bar = null;
        GenomeManager.GenomeListItem genomeListItem = null;
        boolean doImport = true;
        while (doImport) {
            doImport = false;
            File file = null;
            WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
            try {
                File directory;
                File importDirectory = PreferenceManager.getInstance().getLastGenomeImportDirectory();
                if (importDirectory == null) {
                    PreferenceManager.getInstance().setLastGenomeImportDirectory(Globals.getUserDirectory());
                }
                FileFilter[] fileFilters = new FileFilter[]{new SnapshotUtilities.GenomeArchiveFileFilter()};
                this.genomeImportFileChooser = UIUtilities.getFileChooser(importDirectory, null, fileFilters);
                this.genomeImportFileChooser.setDialogTitle("Load Genome");
                this.genomeImportFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e2) {
                        File oldFile = null;
                        String property = e2.getPropertyName();
                        if ("SelectedFileChangedProperty".equals(property)) {
                            oldFile = (File)e2.getOldValue();
                            IGV.this.genomeImportFileChooser.setPreviousFile(oldFile);
                        } else if ("fileFilterChanged".equals(property) && e2.getOldValue() instanceof SnapshotUtilities.GenomeArchiveFileFilter && e2.getNewValue() instanceof SnapshotUtilities.GenomeArchiveFileFilter) {
                            SnapshotUtilities.GenomeArchiveFileFilter newFilter = (SnapshotUtilities.GenomeArchiveFileFilter)e2.getNewValue();
                            File currentDirectory = IGV.this.genomeImportFileChooser.getCurrentDirectory();
                            File previousFile = IGV.this.genomeImportFileChooser.getPreviousFile();
                            if (previousFile != null) {
                                File file = null;
                                file = currentDirectory != null ? new File(currentDirectory, previousFile.getName()) : previousFile;
                                final File selectedFile = Utilities.changeFileExtension(file, newFilter.getExtension());
                                UIUtilities.invokeOnEventThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        IGV.this.genomeImportFileChooser.setSelectedFile(selectedFile);
                                        IGV.this.genomeImportFileChooser.validate();
                                    }
                                });
                            }
                        }
                    }
                });
                this.genomeImportFileChooser.showOpenDialog(this.mainFrame);
                file = this.genomeImportFileChooser.getSelectedFile();
                if (file == null) continue;
                if (monitor != null) {
                    bar = ProgressBar.showProgressDialog(this.mainFrame, "Loading Genome...", monitor, false);
                }
                if ((directory = this.genomeImportFileChooser.getCurrentDirectory()) != null) {
                    PreferenceManager.getInstance().setLastGenomeImportDirectory(directory);
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Call loadGenome");
                    }
                    genomeListItem = IGV.getInstance().getGenomeManager().loadGenome(file.getAbsolutePath(), true, monitor);
                    this.contentPane.getCommandBar().addToUserDefinedGenomeItemList(genomeListItem);
                    this.contentPane.getCommandBar().selectGenomeFromListWithNoImport(genomeListItem.getId());
                    if (monitor != null) {
                        monitor.fireProgressChange(100);
                    }
                    if (bar == null) continue;
                    bar.close();
                }
                catch (Exception e2) {
                    log.fatal("Could not import genome!", e2);
                }
            }
            catch (Exception e3) {
                String genomePath = "";
                if (file != null) {
                    genomePath = file.getAbsolutePath();
                }
                log.error("Failed to load genome: " + genomePath, e3);
                int option = JOptionPane.showConfirmDialog(this.mainFrame, "Failed to load the current genome " + genomePath + "\n" + "Would you like to load another?", "Load Genome Failure", 2);
                if (option != 0) continue;
                doImport = true;
            }
            finally {
                WaitCursorManager.removeWaitCursor(token);
            }
        }
        return genomeListItem;
    }

    public void enableExtrasMenu() {
        this.menuBar.enableExtrasMenu();
    }

    public void loadTracks(Collection<ResourceLocator> locators) {
        this.loadTracks(locators, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTracks(Collection<ResourceLocator> locators, boolean doInBackground) {
        this.contentPane.getStatusBar().setMessage("Loading ...");
        log.debug("Run loadTracks");
        WaitCursorManager.CursorToken token = null;
        try {
            token = WaitCursorManager.showWaitCursor();
            if (locators != null && !locators.isEmpty()) {
                HashMap<TrackPanelScrollPane, Integer> trackCountMap = new HashMap<TrackPanelScrollPane, Integer>();
                HashMap<TrackPanelScrollPane, Integer> panelSizeMap = new HashMap<TrackPanelScrollPane, Integer>();
                Collection<TrackPanelScrollPane> scrollPanes = this.trackManager.getTrackPanelScrollPanes();
                for (TrackPanelScrollPane sp : scrollPanes) {
                    trackCountMap.put(sp, sp.getDataPanel().getAllTracks().size());
                    panelSizeMap.put(sp, sp.getDataPanel().getHeight());
                }
                this.getTrackManager().loadResources(locators);
                double totalHeight = 0.0;
                for (TrackPanelScrollPane sp : scrollPanes) {
                    int prevTrackCount;
                    if (trackCountMap.containsKey(sp) && (prevTrackCount = ((Integer)trackCountMap.get(sp)).intValue()) != sp.getDataPanel().getAllTracks().size()) {
                        int scrollPosition = (Integer)panelSizeMap.get(sp);
                        if (prevTrackCount != 0 && sp.getVerticalScrollBar().isShowing()) {
                            sp.getVerticalScrollBar().setMaximum(sp.getDataPanel().getHeight());
                            sp.getVerticalScrollBar().setValue(scrollPosition);
                        }
                    }
                    if (sp.getTrackPanel().getTracks().size() <= 0) continue;
                    totalHeight += (double)Math.min(300, sp.getTrackPanel().getPreferredPanelHeight());
                }
                JideSplitPane centerSplitPane = this.contentPane.getMainPanel().getCenterSplitPane();
                int htotal = centerSplitPane.getHeight();
                int y = 0;
                int i2 = 0;
                for (Component c2 : centerSplitPane.getComponents()) {
                    if (!(c2 instanceof TrackPanelScrollPane)) continue;
                    TrackPanel trackPanel = ((TrackPanelScrollPane)c2).getTrackPanel();
                    if (trackPanel.getTracks().size() > 0) {
                        int panelWeight = Math.min(300, trackPanel.getPreferredPanelHeight());
                        int dh = (int)((double)panelWeight / totalHeight * (double)htotal);
                        y += dh;
                    }
                    centerSplitPane.setDividerLocation(i2, y);
                    ++i2;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IGV.this.contentPane.getMainPanel().doLayout();
                    }
                });
            }
        }
        catch (Exception e2) {
            if (!(e2 instanceof ConcurrentModificationException)) {
                if (e2.getMessage() != null && e2.getMessage().length() > 8) {
                    MessageUtils.showMessage(e2.getMessage());
                } else {
                    log.error(e2);
                    MessageUtils.showMessage("An error occurred while loading tracks. Please check the logs for details.");
                }
            }
        }
        finally {
            this.showLoadedTrackCount();
            if (token != null) {
                WaitCursorManager.removeWaitCursor(token);
            }
        }
        log.debug("Finish loadTracks");
    }

    public void setGeneList(String listID) {
        this.setGeneList(listID, true);
    }

    public void setGeneList(final String listID, final boolean recordHistory) {
        final WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        SwingUtilities.invokeLater(new NamedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (listID == null) {
                        IGV.this.session.setCurrentGeneList(null);
                    } else {
                        GeneList gl = GeneListManager.getInstance().getGeneList(listID);
                        if (recordHistory) {
                            IGV.this.session.getHistory().push("List: " + listID, 0);
                        }
                        IGV.this.session.setCurrentGeneList(gl);
                    }
                    Preloader.preload();
                    IGV.this.resetFrames();
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public String getName() {
                return "Set gene list";
            }
        });
    }

    public void setDefaultFrame(String searchString) {
        FrameManager.setToDefaultFrame(searchString);
        this.resetFrames();
    }

    public void resetFrames() {
        this.contentPane.getMainPanel().headerPanelContainer.createHeaderPanels();
        for (TrackPanelScrollPane tp : this.trackManager.getTrackPanelScrollPanes()) {
            tp.getTrackPanel().createDataPanels();
        }
        this.contentPane.getCommandBar().setGeneListMode(FrameManager.isGeneListMode());
        this.contentPane.getMainPanel().revalidate();
        this.contentPane.getMainPanel().applicationHeaderPanel.revalidate();
        this.contentPane.getMainPanel().repaint();
    }

    public void enableRemoveGenomes() {
        this.menuBar.enableRemoveGenomes();
    }

    public final void doViewPreferences() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean originalSingleTrackValue = PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane");
                PreferencesEditor dialog = new PreferencesEditor(IGV.this.mainFrame, true);
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    IGV.this.resetStatusMessage();
                    return;
                }
                try {
                    boolean singlePanel = PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane");
                    if (originalSingleTrackValue != singlePanel) {
                        JOptionPane.showMessageDialog(IGV.this.mainFrame, "Panel option change will take affect after restart.");
                    }
                }
                finally {
                    IGV.this.doRefresh();
                    IGV.this.resetStatusMessage();
                }
            }
        });
    }

    public final void doExitApplication() {
        if (!this.getRecentSessionList().isEmpty()) {
            int size = this.getRecentSessionList().size();
            if (size > 3) {
                size = 3;
            }
            String recentSessions = "";
            for (int i2 = 0; i2 < size; ++i2) {
                recentSessions = recentSessions + this.getRecentSessionList().get(i2);
                if (i2 >= size - 1) continue;
                recentSessions = recentSessions + ";";
            }
            PreferenceManager.getInstance().remove("IGV.Session.recent.sessions");
            PreferenceManager.getInstance().setRecentSessions(recentSessions);
            IGVHttpClientUtils.shutdown();
        }
    }

    public final void doShowAttributeDisplay(boolean enableAttributeView) {
        boolean oldState = PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views");
        PreferenceManager.getInstance().setShowAttributeView(enableAttributeView);
        if (oldState != enableAttributeView) {
            this.doRefresh();
        }
    }

    public final void doRefresh() {
        this.contentPane.getMainPanel().revalidate();
        this.mainFrame.repaint();
    }

    public final void refreshCommandBar() {
        this.contentPane.getCommandBar().updateCurrentCoordinates();
    }

    public final void doSelectDisplayableAttribute() {
        List<String> allAttributes = AttributeManager.getInstance().getAttributeNames();
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        CheckListDialog dlg = new CheckListDialog(this.mainFrame, allAttributes, hiddenAttributes, false);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            IGV.getInstance().getSession().setHiddenAttributes(dlg.getNonSelections());
            this.doRefresh();
        }
    }

    public final void saveImage(Component target) {
        this.saveImage(target, "igv_snapshot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveImage(Component target, String title) {
        this.contentPane.getStatusBar().setMessage("Creating image...");
        File defaultFile = new File(title + ".png");
        try {
            this.createSnapshot(target, defaultFile);
        }
        catch (Exception e2) {
            log.error("Error exporting  image ", e2);
            MessageUtils.showMessage("Error encountered while exporting image: " + e2.getMessage());
        }
        finally {
            this.resetStatusMessage();
        }
    }

    public boolean isExportingSnapshot() {
        return this.isExportingSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSnapshot(Component target, File defaultFile) {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            this.contentPane.getStatusBar().setMessage("Exporting image: " + defaultFile.getAbsolutePath());
            File file = this.selectSnapshotFile(defaultFile);
            if (file == null) {
                return;
            }
            this.createSnapshotNonInteractive(target, file);
        }
        catch (Exception e2) {
            log.error("Error creating exporting image ", e2);
            MessageUtils.showMessage("Error creating the image file: " + defaultFile + "<br> " + e2.getMessage());
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            this.resetStatusMessage();
        }
    }

    public void createSnapshotNonInteractive(File file) {
        this.createSnapshotNonInteractive(this.contentPane.getMainPanel(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSnapshotNonInteractive(Component target, File file) {
        SnapshotUtilities.SnapshotFileType type;
        log.debug("Creating snapshot: " + file.getName());
        String extension = SnapshotUtilities.getFileExtension(file.getAbsolutePath());
        if (extension == null) {
            FileFilter filter = this.snapshotFileChooser.getFileFilter();
            extension = !(filter instanceof SnapshotUtilities.SnapshotFileFilter) ? SnapshotUtilities.SnapshotFileType.PNG.getExtension() : ((SnapshotUtilities.SnapshotFileFilter)filter).getExtension();
            file = new File(file.getAbsolutePath() + extension);
        }
        if ((type = SnapshotUtilities.getSnapshotFileType(extension)) != SnapshotUtilities.SnapshotFileType.NULL) {
            boolean doubleBuffered = RepaintManager.currentManager(this.contentPane).isDoubleBufferingEnabled();
            try {
                this.setExportingSnapshot(true);
                SnapshotUtilities.doComponentSnapshot(target, file, type);
            }
            finally {
                this.setExportingSnapshot(false);
            }
        }
        log.debug("Finished creating snapshot: " + file.getName());
    }

    public File selectSnapshotFile(File defaultFile) {
        File directory;
        SnapshotUtilities.SnapshotFileFilter snapshotFileFilter = null;
        if (defaultFile != null) {
            String fileExtension = SnapshotUtilities.getFileExtension(defaultFile.getAbsolutePath());
            snapshotFileFilter = SnapshotUtilities.getSnapshotFileFilterForType(SnapshotUtilities.getSnapshotFileType(fileExtension));
        }
        this.snapshotFileChooser.setFileFilter(snapshotFileFilter);
        this.snapshotFileChooser.setSelectedFile(defaultFile);
        this.snapshotFileChooser.showSaveDialog(this.mainFrame);
        this.resetStatusMessage();
        File file = this.snapshotFileChooser.getSelectedFile();
        if (file != null && (directory = this.snapshotFileChooser.getCurrentDirectory()) != null) {
            PreferenceManager.getInstance().setLastSnapshotDirectory(directory);
        }
        return file;
    }

    private void createZoomCursors() throws HeadlessException, IndexOutOfBoundsException {
        if (zoomInCursor == null || zoomOutCursor == null) {
            Image zoomInImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_IN).getImage();
            Image zoomOutImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_OUT).getImage();
            Point hotspot = new Point(10, 10);
            zoomInCursor = this.mainFrame.getToolkit().createCustomCursor(zoomInImage, hotspot, "Zoom in");
            zoomOutCursor = this.mainFrame.getToolkit().createCustomCursor(zoomOutImage, hotspot, "Zoom out");
        }
    }

    private void createHandCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (fistCursor == null) {
            BufferedImage handImage = new BufferedImage(32, 32, 2);
            Graphics2D g2 = handImage.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 32.0, 32.0);
            g2.fill(rect);
            g2 = handImage.createGraphics();
            g2.drawImage(IconFactory.getInstance().getIcon(IconFactory.IconID.FIST).getImage(), 0, 0, null);
            fistCursor = this.mainFrame.getToolkit().createCustomCursor(handImage, new Point(8, 6), "Move");
        }
    }

    private void createDragAndDropCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (dragNDropCursor == null) {
            ImageIcon icon = IconFactory.getInstance().getIcon(IconFactory.IconID.DRAG_AND_DROP);
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            BufferedImage dragNDropImage = new BufferedImage(width, height, 2);
            Graphics2D g2 = dragNDropImage.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
            g2.fill(rect);
            g2 = dragNDropImage.createGraphics();
            Image image = icon.getImage();
            g2.drawImage(image, 0, 0, null);
            dragNDropCursor = this.mainFrame.getToolkit().createCustomCursor(dragNDropImage, new Point(0, 0), "Drag and Drop");
        }
    }

    public void createNewSession(String sessionName) {
        LRUCache.clearCaches();
        AttributeManager.getInstance().clearAllAttributes();
        this.mainFrame.setTitle("IGV");
        this.menuBar.resetSessionActions();
        AttributeManager.getInstance().clearAllAttributes();
        this.session = new Session(sessionName);
        this.contentPane.getMainPanel().resetPanels();
        this.doRefresh();
    }

    public void setStatusBarMessage(String message) {
        if (message.equals("Done.")) {
            this.resetStatusMessage();
        }
        this.contentPane.getStatusBar().setMessage(message);
    }

    public void resetToFactorySettings() {
        try {
            PreferenceManager.getInstance().clear();
            boolean isShow = PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views");
            this.doShowAttributeDisplay(isShow);
            this.doRefresh();
        }
        catch (Exception e2) {
            String message = "Failure while resetting preferences!";
            MessageUtils.showAndLogErrorMessage(this.mainFrame, message, log, e2);
        }
    }

    public void updateTrackState() {
        this.doRefresh();
    }

    public void setFilterMatchAll(boolean value) {
        this.menuBar.setFilterMatchAll(value);
    }

    public boolean isFilterMatchAll() {
        return this.menuBar.isFilterMatchAll();
    }

    public void setFilterShowAllTracks(boolean value) {
        this.menuBar.setFilterShowAllTracks(value);
    }

    public boolean isFilterShowAllTracks() {
        return this.menuBar.isFilterShowAllTracks();
    }

    public TrackPanelScrollPane addDataPanel(String name) {
        return this.contentPane.getMainPanel().addDataPanel(name);
    }

    public TrackPanel getDataPanel(String name) {
        TrackPanelScrollPane sp = this.trackManager.getScrollPane(name);
        if (sp == null) {
            sp = this.addDataPanel(name);
            this.trackManager.putScrollPane(name, sp);
        }
        return sp.getTrackPanel();
    }

    public boolean scrollToTrack(String trackName) {
        for (TrackPanelScrollPane sp : this.trackManager.getTrackPanelScrollPanes()) {
            if (!sp.getNamePanel().scrollTo(trackName)) continue;
            return true;
        }
        return false;
    }

    public List<TrackPanel> getTrackPanels() {
        return this.contentPane.getMainPanel().getTrackPanels();
    }

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRestoreSession(File sessionFile, String locus) {
        String filePath = "";
        if (sessionFile != null) {
            log.debug("Run doRestoreSession");
            BufferedInputStream inputStream = null;
            WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
            try {
                inputStream = new BufferedInputStream(new FileInputStream(sessionFile));
                this.doRestoreSession(inputStream, sessionFile.getAbsolutePath(), locus, false);
                String sessionFilePath = sessionFile.getAbsolutePath();
                if (!this.getRecentSessionList().contains(sessionFilePath)) {
                    this.getRecentSessionList().addFirst(sessionFilePath);
                }
            }
            catch (Exception e2) {
                String message = "Failed to load session! : " + sessionFile.getAbsolutePath();
                MessageUtils.showAndLogErrorMessage(this.mainFrame, message, log, e2);
            }
            finally {
                WaitCursorManager.removeWaitCursor(token);
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {
                        log.error("Error closing session stream", iOException);
                    }
                }
            }
            log.debug("Finish doRestoreSession");
        } else {
            String message = "Session file does not exist! : " + filePath;
            MessageUtils.showAndLogErrorMessage(this.mainFrame, message, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRestoreSession(URL sessionURL, String locus) throws Exception {
        log.debug("Enter doRestoreSession: " + sessionURL + " " + locus);
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(sessionURL.openStream());
            this.doRestoreSession(inputStream, URLDecoder.decode(sessionURL.toExternalForm(), "UTF-8"), locus, false);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {
                    log.error("Error closing session stream", iOException);
                }
            }
        }
        log.debug("Exit doRestoreSession");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRestoreSession(InputStream inputStream, String sessionPath, String locus, boolean merge) {
        try {
            String searchText;
            this.setStatusBarMessage("Opening session...");
            if (!merge) {
                this.createNewSession(sessionPath);
            }
            SessionReader sessionReader = new SessionReader(this);
            sessionReader.loadSession(inputStream, this.session, sessionPath);
            String string = searchText = locus == null ? this.session.getLocus() : locus;
            if (!FrameManager.isGeneListMode() && searchText != null && !searchText.equals("All") && searchText.trim().length() > 0) {
                this.goToLocus(searchText);
            }
            this.mainFrame.setTitle("IGV - Session: " + sessionPath);
            LRUCache.clearCaches();
            double[] dividerFractions = this.session.getDividerFractions();
            if (dividerFractions != null) {
                this.contentPane.getMainPanel().setDividerFractions(dividerFractions);
            }
            this.session.clearDividerLocations();
            RegionNavigatorDialog.destroyActiveInstance();
            this.doRefresh();
        }
        finally {
            this.resetStatusMessage();
        }
    }

    public void resetStatusMessage() {
        this.contentPane.getStatusBar().setMessage("" + IGV.getInstance().getTrackManager().getVisibleTrackCount() + " tracks loaded");
    }

    public void rebuildGenomeDropdownList(Set excludedArchivesUrls) {
        this.contentPane.getCommandBar().rebuildGenomeItemList(excludedArchivesUrls);
    }

    public void showLoadedTrackCount() {
        this.contentPane.getStatusBar().setMessage("" + IGV.getInstance().getTrackManager().getVisibleTrackCount() + " track(s) currently loaded");
    }

    private void closeWindow(final ProgressBar progressBar) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                progressBar.close();
            }
        });
    }

    public void goToLocus(String locus) {
        this.contentPane.getCommandBar().searchByLocus(locus, false);
    }

    public TrackManager getTrackManager() {
        return this.trackManager;
    }

    public void tweakPanelDivider() {
        this.contentPane.getMainPanel().tweakPanelDivider();
    }

    public void removeDataPanel(String name) {
        this.contentPane.getMainPanel().removeDataPanel(name);
    }

    public void layoutMainPanel() {
        this.contentPane.getMainPanel().doLayout();
    }

    public MainPanel getMainPanel() {
        return this.contentPane.getMainPanel();
    }

    public void setExportingSnapshot(boolean exportingSnapshot) {
        this.isExportingSnapshot = exportingSnapshot;
        if (this.isExportingSnapshot) {
            RepaintManager.currentManager(this.contentPane).setDoubleBufferingEnabled(false);
        } else {
            RepaintManager.currentManager(this.contentPane).setDoubleBufferingEnabled(true);
        }
    }

    public LinkedList<String> getRecentSessionList() {
        return this.recentSessionList;
    }

    public void setRecentSessionList(LinkedList<String> recentSessionList) {
        this.recentSessionList = recentSessionList;
    }

    public IGVContentPane getContentPane() {
        return this.contentPane;
    }

    public GenomeManager getGenomeManager() {
        return this.genomeManager;
    }

    public void addCommandBar(PeakCommandBar cb) {
        this.peakCommandBar = cb;
        this.contentPane.add(this.peakCommandBar);
        this.contentPane.invalidate();
        this.showPeakMenuItem = new JCheckBoxMenuItem("Show peaks toolbar");
        this.showPeakMenuItem.setSelected(true);
        this.showPeakMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IGV.this.showPeakMenuItem.isSelected()) {
                    IGV.this.contentPane.add(IGV.this.peakCommandBar);
                } else {
                    IGV.this.contentPane.remove(IGV.this.peakCommandBar);
                }
            }
        });
        this.menuBar.getViewMenu().addSeparator();
        this.menuBar.getViewMenu().add(this.showPeakMenuItem);
    }

    public boolean isSuppressTooltip() {
        return this.contentPane != null && this.contentPane.getCommandBar().isSuppressTooltip();
    }

    public void startUp(String[] args) {
        Main.IGVArgs igvArgs;
        if (log.isDebugEnabled()) {
            log.debug("startUp");
        }
        if ((igvArgs = new Main.IGVArgs(args)).getPropertyFile() != null) {
            // empty if block
        }
        if (igvArgs.getDataServerURL() != null) {
            PreferenceManager.getInstance().overrideDataServerURL(igvArgs.getDataServerURL());
        }
        if (igvArgs.getGenomeServerURL() != null) {
            PreferenceManager.getInstance().overrideGenomeServerURL(igvArgs.getGenomeServerURL());
        }
        StartupWorker worker = new StartupWorker(igvArgs);
        worker.execute();
    }

    public boolean isStartupComplete() {
        return this.startupComplete;
    }

    static {
        instances = new LinkedList<IGV>();
    }

    public class StartupWorker
    extends SwingWorker {
        Main.IGVArgs igvArgs;

        StartupWorker(Main.IGVArgs args) {
            this.igvArgs = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            ProgressMonitor monitor = new ProgressMonitor();
            ProgressBar progressBar = ProgressBar.showProgressDialog(IGV.this.mainFrame, "Initializing...", monitor, false);
            monitor.fireProgressChange(20);
            try {
                IGV.this.contentPane.getCommandBar().initializeGenomeList(monitor);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(IGV.this.mainFrame, "Error initializing genome list: " + ex.getMessage());
                log.error("Error initializing genome list: ", ex);
            }
            catch (NoRouteToHostException ex) {
                JOptionPane.showMessageDialog(IGV.this.mainFrame, "Network error initializing genome list: " + ex.getMessage());
                log.error("Network error initializing genome list: ", ex);
            }
            finally {
                monitor.fireProgressChange(50);
                IGV.this.closeWindow(progressBar);
            }
            if (this.igvArgs.getGenomeId() != null) {
                IGV.this.selectGenomeFromList(this.igvArgs.getGenomeId());
            } else if (this.igvArgs.getSessionFile() == null) {
                String genomeId = PreferenceManager.getInstance().getDefaultGenome();
                IGV.this.contentPane.getCommandBar().selectGenomeFromList(genomeId);
            }
            if (this.igvArgs.getSessionFile() != null || this.igvArgs.getDataFileString() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Loadding session data");
                }
                IndefiniteProgressMonitor indefMonitor = new IndefiniteProgressMonitor(60);
                ProgressBar bar2 = ProgressBar.showProgressDialog(IGV.this.mainFrame, "Loading session data", indefMonitor, false);
                indefMonitor.start();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Calling restore session");
                    }
                    if (this.igvArgs.getSessionFile() != null) {
                        if (IGVHttpClientUtils.isURL(this.igvArgs.getSessionFile())) {
                            URL url = new URL(this.igvArgs.getSessionFile());
                            IGV.this.doRestoreSession(url, this.igvArgs.getLocusString());
                        } else {
                            File sf = new File(this.igvArgs.getSessionFile());
                            if (sf.exists()) {
                                IGV.this.doRestoreSession(sf, this.igvArgs.getLocusString());
                            }
                        }
                    } else if (this.igvArgs.getDataFileString() != null) {
                        String[] tokens = this.igvArgs.getDataFileString().split(",");
                        String indexFile = this.igvArgs.getIndexFile();
                        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
                        for (String p2 : tokens) {
                            ResourceLocator rl = new ResourceLocator(p2);
                            rl.setIndexPath(indexFile);
                            locators.add(rl);
                        }
                        IGV.this.getTrackManager().loadResources(locators);
                    }
                }
                catch (Exception ex) {
                    String tmp = this.igvArgs.getSessionFile() != null ? this.igvArgs.getSessionFile() : this.igvArgs.getDataFileString();
                    JOptionPane.showMessageDialog(IGV.this.mainFrame, "<html>Error loading session: " + tmp + "<br>" + ex.toString());
                    log.error("Error loading session: " + tmp, ex);
                    String genomeId = PreferenceManager.getInstance().getDefaultGenome();
                    IGV.this.contentPane.getCommandBar().selectGenomeFromList(genomeId);
                }
                indefMonitor.stop();
                IGV.this.closeWindow(bar2);
            }
            if (this.igvArgs.getLocusString() != null) {
                IGV.this.goToLocus(this.igvArgs.getLocusString());
            }
            IGV.this.session.recordHistory();
            boolean portEnabled = PreferenceManager.getInstance().getAsBoolean("PORT_ENABLED");
            String portString = this.igvArgs.getPort();
            if (portEnabled || portString != null) {
                int port = PreferenceManager.getInstance().getAsInt("PORT_NUMBER");
                if (portString != null) {
                    port = Integer.parseInt(portString);
                }
                CommandListener.start(port);
            }
            IGV.this.startupComplete = true;
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    IGV.this.mainFrame.setVisible(true);
                }
            });
            return null;
        }

        @Override
        protected void done() {
            if (this.igvArgs.getBatchFile() != null) {
                LongRunningTask.submit(new BatchRunner(this.igvArgs.getBatchFile()));
            }
        }
    }
}

