/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Strand;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;

public class SequenceTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(SequenceTrack.class);
    private static final int SEQUENCE_HEIGHT = 14;
    private static String NAME = "Sequence";
    private SequenceRenderer sequenceRenderer = new SequenceRenderer();
    private boolean shouldShowTranslation = true;
    private boolean sequenceVisible = false;
    Strand strand = Strand.POSITIVE;
    private boolean showColorSpace = false;
    private Rectangle arrowRect;

    public SequenceTrack(String name) {
        super(name);
        this.setSortable(false);
        this.shouldShowTranslation = PreferenceManager.getInstance().getAsBoolean("SHOW_SEQUENCE_TRANSLATION");
    }

    @Override
    public void renderName(Graphics2D graphics, Rectangle trackRectangle, Rectangle visibleRectangle) {
        Font font = FontManager.getFont(this.fontSize);
        if (this.sequenceVisible) {
            graphics.setFont(font);
            graphics.drawString(NAME, trackRectangle.x + 5, trackRectangle.y + 12);
            int rx = trackRectangle.x + trackRectangle.width - 20;
            this.arrowRect = new Rectangle(rx, trackRectangle.y + 2, 15, 10);
            this.drawArrow(graphics);
        }
    }

    private void drawArrow(Graphics2D graphics) {
        if (this.strand == Strand.POSITIVE) {
            GraphicUtils.drawHorizontalArrow(graphics, this.arrowRect, true);
        } else {
            GraphicUtils.drawHorizontalArrow(graphics, this.arrowRect, false);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        boolean visible;
        int resolutionThreshold = PreferenceManager.getInstance().getAsInt("MAX_SEQUENCE_RESOLUTION");
        boolean bl = visible = FrameManager.getMinimumScale() < (double)resolutionThreshold && !context.getChr().equals("All");
        if (visible != this.sequenceVisible) {
            this.sequenceVisible = visible;
            IGV.getInstance().doRefresh();
        }
        if (this.sequenceVisible) {
            this.sequenceRenderer.setStrand(this.strand);
            this.sequenceRenderer.draw(context, rect, this.showColorSpace, this.shouldShowTranslation, resolutionThreshold);
        }
    }

    @Override
    public int getHeight() {
        return this.sequenceVisible ? 14 + (this.showColorSpace ? 14 : 0) + (this.shouldShowTranslation ? 42 : 0) : 0;
    }

    @Override
    public int getPreferredHeight() {
        return this.getHeight();
    }

    @Override
    public boolean handleDataClick(TrackClickEvent e2) {
        MouseEvent evt = e2.getMouseEvent();
        this.setShouldShowTranslation(!this.shouldShowTranslation);
        Object source = e2.getMouseEvent().getSource();
        if (source instanceof JComponent) {
            this.repaint();
        }
        return true;
    }

    @Override
    public void handleNameClick(MouseEvent e2) {
        if (this.arrowRect != null && this.arrowRect.contains(e2.getPoint())) {
            this.flipStrand(e2.getSource());
        }
    }

    private void flipStrand(Object source) {
        this.strand = this.strand == Strand.POSITIVE ? Strand.NEGATIVE : Strand.POSITIVE;
        this.repaint();
        IGV.getInstance().getTrackManager().clearSelections();
    }

    public void setShouldShowTranslation(boolean shouldShowTranslation) {
        this.shouldShowTranslation = shouldShowTranslation;
        PreferenceManager.getInstance().put("SHOW_SEQUENCE_TRANSLATION", shouldShowTranslation);
    }

    @Override
    public IGVPopupMenu getPopupMenu(final TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        JMenuItem m1 = new JMenuItem("Flip strand");
        m1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SequenceTrack.this.flipStrand(te.getMouseEvent().getSource());
            }
        });
        final JCheckBoxMenuItem m2 = new JCheckBoxMenuItem("Show translation");
        m2.setSelected(this.shouldShowTranslation);
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SequenceTrack.this.setShouldShowTranslation(m2.isSelected());
                SequenceTrack.this.repaint();
                IGV.getInstance().getTrackManager().clearSelections();
            }
        });
        menu.add(m1);
        menu.add(m2);
        return menu;
    }

    private void repaint() {
        IGV.getMainFrame().repaint();
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }
}

