/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.parsers;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class WiggleParser {
    private DataConsumer dataConsumer;
    private Type type = Type.bed;
    String trackLine = null;
    String nextLine = null;
    private String chr;
    String lastChr = "";
    int lastPosition = 0;
    private int start = 0;
    private int step = 1;
    private int span = 1;
    private int startBase = 1;
    private double minValue;
    private double maxValue;
    ResourceLocator resourceLocator;
    Set<String> unsortedChromosomes;
    Genome genome;

    public WiggleParser(String file, DataConsumer dataConsumer, Genome genome) {
        this.resourceLocator = new ResourceLocator(file);
        this.dataConsumer = dataConsumer;
        this.genome = genome;
        this.parseHeader();
        String[] trackNames = new String[]{this.resourceLocator.getTrackName()};
        if (this.resourceLocator.getPath().endsWith(".ewig") || this.resourceLocator.getPath().endsWith(".ewig.gz")) {
            trackNames = new String[5];
            trackNames[4] = this.resourceLocator.getTrackName();
            trackNames[0] = "A";
            trackNames[1] = "C";
            trackNames[2] = "G";
            trackNames[3] = "T";
        }
        dataConsumer.setTrackParameters(TrackType.OTHER, this.trackLine, trackNames);
        if (this.trackLine != null) {
            TrackProperties props = new TrackProperties();
            ParsingUtils.parseTrackLine(this.trackLine, props);
            TrackProperties.BaseCoord convention = props.getBaseCoord();
            if (convention == TrackProperties.BaseCoord.ZERO) {
                this.startBase = 0;
            }
        }
        if (this.resourceLocator.getPath().endsWith("CpG.txt")) {
            this.type = Type.cpg;
        }
    }

    public DataConsumer getDataConsumer() {
        return this.dataConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWiggle(ResourceLocator file) {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(file, true);
            String nextLine = null;
            int lineNo = 0;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                if (nextLine.startsWith("track") && nextLine.contains("wiggle_0")) {
                    boolean bl = true;
                    return bl;
                }
                if (lineNo++ <= 100) continue;
                break;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseHeader() {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.resourceLocator, true);
            while ((this.nextLine = reader.readLine()) != null && this.nextLine.trim().length() > 0) {
                if (this.nextLine.startsWith("#") || this.nextLine.startsWith("data") || this.nextLine.startsWith("browser") || this.nextLine.trim().length() == 0) continue;
                if (this.nextLine.startsWith("track")) {
                    this.trackLine = this.nextLine;
                    continue;
                }
                return;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        String[] tokens = new String[10];
        this.lastPosition = 0;
        this.unsortedChromosomes = new HashSet<String>();
        AsciiLineReader reader = null;
        float[] dataArray = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.resourceLocator);
            int position = -1;
            while ((this.nextLine = reader.readLine()) != null) {
                if (this.nextLine.startsWith("#") || this.nextLine.startsWith("data") || this.nextLine.startsWith("browser") || this.nextLine.trim().length() == 0) continue;
                if (this.nextLine.startsWith("track")) {
                    this.type = Type.bed;
                    this.dataConsumer.setType("bed");
                    continue;
                }
                if (this.nextLine.startsWith("fixedStep")) {
                    this.type = Type.fixedStep;
                    this.dataConsumer.setType("fixedStep");
                    this.parseStepLine(this.nextLine);
                    position = this.start;
                    if (this.start >= this.lastPosition) continue;
                    this.unsortedChromosomes.add(this.chr);
                    continue;
                }
                if (this.nextLine.startsWith("variableStep")) {
                    this.type = Type.variableStep;
                    this.dataConsumer.setType("variableStep");
                    this.parseStepLine(this.nextLine);
                    if (this.start >= this.lastPosition) continue;
                    this.unsortedChromosomes.add(this.chr);
                    continue;
                }
                int nTokens = ParsingUtils.splitWhitespace(this.nextLine, tokens);
                if (nTokens == 0) continue;
                try {
                    int endPosition;
                    if (this.type.equals((Object)Type.cpg)) {
                        if (nTokens <= 3) continue;
                        if (dataArray == null) {
                            dataArray = new float[nTokens - 3];
                        }
                        this.chr = tokens[1].trim();
                        if (!this.chr.equals(this.lastChr)) {
                            this.newChromosome();
                        }
                        this.lastChr = this.chr;
                        int endPosition2 = -1;
                        try {
                            endPosition2 = Integer.parseInt(tokens[2].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Column 2  is not a number");
                            throw new RuntimeException("Column 2 must be numeric. Found: " + tokens[1]);
                        }
                        int startPosition = endPosition2 - 1;
                        if (startPosition < this.lastPosition) {
                            this.unsortedChromosomes.add(this.chr);
                        }
                        this.lastPosition = startPosition;
                        float value = Float.parseFloat(tokens[4].trim());
                        if (tokens[3].trim().equals("R")) {
                            value = -value;
                        }
                        dataArray[0] = value;
                        this.getDataConsumer().addData(this.chr, startPosition, endPosition2, dataArray, null);
                        continue;
                    }
                    if (this.type.equals((Object)Type.bed)) {
                        if (nTokens <= 3) continue;
                        if (dataArray == null) {
                            dataArray = new float[nTokens - 3];
                        }
                        String string = this.chr = this.genome == null ? tokens[0].trim() : this.genome.getChromosomeAlias(tokens[0].trim());
                        if (!this.chr.equals(this.lastChr)) {
                            this.newChromosome();
                        }
                        this.lastChr = this.chr;
                        int startPosition = Integer.parseInt(tokens[1].trim());
                        if (startPosition < this.lastPosition) {
                            this.unsortedChromosomes.add(this.chr);
                        }
                        this.lastPosition = startPosition;
                        endPosition = Integer.parseInt(tokens[2].trim());
                        for (int i2 = 0; i2 < dataArray.length; ++i2) {
                            dataArray[i2] = Float.parseFloat(tokens[3 + i2].trim());
                        }
                        this.getDataConsumer().addData(this.chr, startPosition, endPosition, dataArray, null);
                        continue;
                    }
                    if (this.type.equals((Object)Type.variableStep)) {
                        int startPosition;
                        if (nTokens <= 1) continue;
                        if (dataArray == null) {
                            dataArray = new float[nTokens - 1];
                        }
                        if ((startPosition = Integer.parseInt(tokens[0]) - this.startBase) < this.lastPosition) {
                            this.unsortedChromosomes.add(this.chr);
                        }
                        this.lastPosition = startPosition;
                        endPosition = startPosition + this.span;
                        for (int i3 = 0; i3 < dataArray.length; ++i3) {
                            dataArray[i3] = Float.parseFloat(tokens[1 + i3].trim());
                        }
                        this.getDataConsumer().addData(this.chr, startPosition, endPosition, dataArray, null);
                        continue;
                    }
                    if (position >= 0) {
                        if (dataArray == null) {
                            dataArray = new float[nTokens];
                        }
                        int endPosition3 = position + this.span;
                        for (int i4 = 0; i4 < dataArray.length; ++i4) {
                            dataArray[i4] = Float.parseFloat(tokens[i4].trim());
                        }
                        this.getDataConsumer().addData(this.chr, position, endPosition3, dataArray, null);
                    }
                    this.lastPosition = position += this.step;
                }
                catch (NumberFormatException e2) {
                    System.out.println("Cannot parse: " + this.nextLine);
                }
            }
            this.parsingComplete();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void parseStepLine(String header) {
        String[] tokens;
        for (String token : tokens = header.split("\\s+")) {
            String[] keyValue = token.split("=");
            if (keyValue.length < 2) continue;
            if (keyValue[0].equalsIgnoreCase("chrom")) {
                String string = this.chr = this.genome == null ? keyValue[1] : this.genome.getChromosomeAlias(keyValue[1]);
                if (!this.chr.equals(this.lastChr)) {
                    this.newChromosome();
                }
                this.lastChr = this.chr;
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("start")) {
                this.start = Integer.parseInt(keyValue[1]) - this.startBase;
                if (this.start >= this.lastPosition) continue;
                this.unsortedChromosomes.add(this.chr);
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("step")) {
                this.step = Integer.parseInt(keyValue[1]);
                continue;
            }
            if (!keyValue[0].equalsIgnoreCase("span")) continue;
            this.span = Integer.parseInt(keyValue[1]);
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void newChromosome() {
    }

    private void parsingComplete() {
        this.getDataConsumer().parsingComplete();
    }

    private static enum Type {
        fixedStep,
        variableStep,
        bed,
        cpg;

    }
}

