/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.goby.GobyCountArchiveDataSource;
import org.broad.igv.lists.GeneList;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.FeatureRenderer;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SpliceJunctionFinderTrack;
import org.broad.igv.session.Session;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.InsertSizeSettingsDialog;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DragEvent;
import org.broad.igv.ui.panel.DragListener;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.ResourceLocator;

public class AlignmentTrack
extends AbstractTrack
implements DragListener {
    public static final int MIN_ALIGNMENT_SPACING = 10;
    static final ColorOption DEFAULT_COLOR_OPTION = ColorOption.INSERT_SIZE;
    static final boolean DEFAULT_SHOWALLBASES = false;
    private static ColorOption colorByOption = null;
    private SequenceTrack sequenceTrack;
    private CoverageTrack coverageTrack;
    private SpliceJunctionFinderTrack spliceJunctionTrack;
    private RenderOptions renderOptions;
    private static Logger log = Logger.getLogger(AlignmentTrack.class);
    private int expandedHeight = 14;
    private int maxCollapsedHeight;
    private int collapsedHeight = this.maxCollapsedHeight = 4;
    private FeatureRenderer renderer;
    private double minVisibleScale = 25.0;
    private Rectangle renderedRect;
    private HashMap<String, Color> selectedReadNames = new HashMap();
    private int selectionColorIndex = 0;
    private int minHeight = 100;
    private AlignmentDataManager dataManager;
    Genome genome;
    DataPanel parent;

    public AlignmentTrack(ResourceLocator locator, AlignmentDataManager dataManager, Genome genome) {
        super(locator);
        this.genome = genome;
        this.dataManager = dataManager;
        PreferenceManager prefs = PreferenceManager.getInstance();
        float maxRange = prefs.getAsFloat("SAM.MAX_VISIBLE_RANGE");
        this.minVisibleScale = maxRange * 1000.0f / 700.0f;
        this.renderer = new AlignmentRenderer();
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
        if (prefs.getAsBoolean("SAM.SHOW_REF_SEQ")) {
            this.sequenceTrack = new SequenceTrack("Reference sequence");
            this.sequenceTrack.setHeight(14);
        }
        this.renderOptions = new RenderOptions();
        if (colorByOption == null) {
            String colorByString = PreferenceManager.getInstance().get("SAM.COLOR_BY");
            if (colorByString == null) {
                colorByOption = DEFAULT_COLOR_OPTION;
            } else {
                try {
                    colorByOption = ColorOption.valueOf(colorByString);
                }
                catch (Exception e2) {
                    log.error("Error setting color option", e2);
                    colorByOption = DEFAULT_COLOR_OPTION;
                }
            }
        }
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public void setSpliceJunctionTrack(SpliceJunctionFinderTrack spliceJunctionTrack) {
        this.spliceJunctionTrack = spliceJunctionTrack;
    }

    public SpliceJunctionFinderTrack getSpliceJunctionTrack() {
        return this.spliceJunctionTrack;
    }

    public void setRenderer(FeatureRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return new PopupMenu(te);
    }

    @Override
    public void setHeight(int preferredHeight) {
        super.setHeight(preferredHeight);
        this.minHeight = preferredHeight;
    }

    @Override
    public int getHeight() {
        int h2 = Math.max(this.minHeight, this.getNLevels() * this.getRowHeight() + 20);
        return h2;
    }

    private int getRowHeight() {
        return this.getDisplayMode() == Track.DisplayMode.EXPANDED ? this.expandedHeight : this.collapsedHeight;
    }

    private int getNLevels() {
        return this.dataManager.getNLevels();
    }

    @Override
    public int getPreferredHeight() {
        return Math.max(100, this.getHeight());
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int seqHeight;
        this.parent = context.getPanel();
        int n2 = seqHeight = this.sequenceTrack == null ? 0 : this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.render(context, seqRect);
        }
        int gap = seqHeight > 0 ? seqHeight : 6;
        rect.y += gap;
        rect.height -= gap;
        this.renderedRect = new Rectangle(rect);
        if (context.getScale() > this.minVisibleScale) {
            Graphics2D g2 = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", context.getVisibleRect(), g2);
            return;
        }
        this.renderFeatures(context, rect);
    }

    private void renderFeatures(RenderContext context, Rectangle inputRect) {
        try {
            log.debug("Render features");
            List<AlignmentInterval.Row> tmp = this.dataManager.getAlignmentRows(context);
            Map<String, PEStats> peStats = this.dataManager.getPEStats();
            if (peStats != null) {
                this.renderOptions.peStats = peStats;
            }
            if (tmp == null) {
                return;
            }
            Rectangle visibleRect = context.getVisibleRect();
            double y = inputRect.getY();
            double h2 = this.expandedHeight;
            if (this.getDisplayMode() != Track.DisplayMode.EXPANDED) {
                int visHeight = context.getVisibleRect().height;
                int depth = this.dataManager.getMaxLevels();
                this.collapsedHeight = Math.min(this.maxCollapsedHeight, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
                h2 = this.collapsedHeight;
            }
            int levelNumber = 0;
            for (AlignmentInterval.Row row : tmp) {
                if (visibleRect != null && y > visibleRect.getMaxY()) {
                    return;
                }
                if (y + h2 > visibleRect.getY()) {
                    Rectangle rect = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h2);
                    this.renderOptions.colorOption = colorByOption;
                    this.renderer.renderAlignments(row.alignments, context, rect, this.renderOptions, this.getDisplayMode() == Track.DisplayMode.EXPANDED, this.selectedReadNames);
                }
                ++levelNumber;
                y += h2;
            }
        }
        catch (Exception ex) {
            log.error("Error rendering track", ex);
            throw new RuntimeException("Error rendering track ", ex);
        }
    }

    public void clearCaches() {
        this.dataManager.clear();
        this.renderOptions = new RenderOptions();
    }

    public void sortRows(SortOption option, ReferenceFrame referenceFrame) {
        if (option == SortOption.READ_GROUP || option == SortOption.SAMPLE) {
            this.dataManager.repackAlignments(referenceFrame, option);
        } else {
            this.dataManager.sortRows(option, referenceFrame);
        }
    }

    public void sortRows(SortOption option, ReferenceFrame referenceFrame, double location) {
        if (option == SortOption.STRAND || option == SortOption.READ_GROUP || option == SortOption.SAMPLE) {
            this.dataManager.repackAlignments(referenceFrame, option);
        } else {
            this.dataManager.sortRows(option, referenceFrame, location);
        }
    }

    public void packAlignments(ReferenceFrame referenceFrame) {
        this.dataManager.repackAlignments(referenceFrame);
    }

    public void copyToClipboard(TrackClickEvent e2, Alignment alignment, double location) {
        if (alignment != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(alignment.getValueString(location, null).replace("<br>", "\n"));
            buf.append("\n");
            buf.append("Alignment start position = " + alignment.getChr() + ":" + (alignment.getAlignmentStart() + 1));
            buf.append("\n");
            buf.append(alignment.getReadSequence());
            StringSelection stringSelection = new StringSelection(buf.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    public void gotoMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String chr = mate.getChr();
                int start = mate.start - 1;
                te.getFrame().centerOnLocation(chr, start);
                te.getFrame().recordHistory();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    public void splitScreenMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String mateChr = mate.getChr();
                int mateStart = mate.start - 1;
                ReferenceFrame frame = te.getFrame();
                String locus1 = frame.getFormattedLocusString();
                ReferenceFrame.Range range = frame.getCurrentRange();
                int length = range.getLength();
                int s2 = Math.max(0, mateStart - length / 2);
                int e2 = s2 + length;
                String startStr = NumberFormat.getInstance().format(s2);
                String endStr = NumberFormat.getInstance().format(e2);
                String mateLocus = mateChr + ":" + startStr + "-" + endStr;
                Session currentSession = IGV.getInstance().getSession();
                ArrayList<String> loci = null;
                if (FrameManager.isGeneListMode()) {
                    loci = new ArrayList(FrameManager.getFrames().size());
                    for (ReferenceFrame ref : FrameManager.getFrames()) {
                        loci.add(ref.getLocus().toString());
                    }
                    loci.add(mateLocus);
                } else {
                    loci = Arrays.asList(locus1, mateLocus);
                }
                GeneList.sortByPosition(loci);
                StringBuffer listName = new StringBuffer();
                for (String s : loci) {
                    listName.append(s + "   ");
                }
                GeneList geneList = new GeneList(listName.toString(), loci, false);
                currentSession.setCurrentGeneList(geneList);
                IGV.getInstance().resetFrames();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, ReferenceFrame frame) {
        return 0.0f;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        Alignment feature = this.getAlignmentAt(position, y, frame);
        String tmp = feature == null ? null : feature.getValueString(position, this.getWindowFunction());
        return tmp;
    }

    private Alignment getAlignmentAt(double position, int y, ReferenceFrame frame) {
        List<AlignmentInterval.Row> alignmentRows = this.dataManager.getAlignmentRows(frame);
        if (alignmentRows == null || alignmentRows.isEmpty()) {
            return null;
        }
        int h2 = this.getDisplayMode() == Track.DisplayMode.EXPANDED ? this.expandedHeight : this.collapsedHeight;
        int levelNumber = (y - this.renderedRect.y) / h2;
        if (levelNumber < 0 || levelNumber >= alignmentRows.size()) {
            return null;
        }
        AlignmentInterval.Row row = alignmentRows.get(levelNumber);
        List<Alignment> features = row.alignments;
        int buffer = 0;
        return (Alignment)FeatureUtils.getFeatureAt(position, buffer, features);
    }

    @Override
    public void dragStopped(DragEvent evt) {
    }

    private static Alignment getFeatureContaining(List<Alignment> features, int right) {
        int leftBounds = 0;
        int rightBounds = features.size() - 1;
        int idx = features.size() / 2;
        int lastIdx = -1;
        while (idx != lastIdx) {
            lastIdx = idx;
            Alignment f2 = features.get(idx);
            if (f2.contains(right)) {
                return f2;
            }
            if (f2.getStart() > right) {
                rightBounds = idx;
                idx = (leftBounds + idx) / 2;
                continue;
            }
            leftBounds = idx;
            idx = (rightBounds + idx) / 2;
        }
        if (features.get(0).contains(right)) {
            return features.get(0);
        }
        if (features.get(rightBounds).contains(right)) {
            return features.get(rightBounds);
        }
        return null;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        ReferenceFrame frame;
        MouseEvent e2 = te.getMouseEvent();
        if ((Globals.IS_MAC && e2.isMetaDown() || !Globals.IS_MAC && e2.isControlDown()) && (frame = te.getFrame()) != null) {
            this.selectAlignment(e2, frame);
            if (this.parent != null) {
                this.parent.repaint();
            }
            return true;
        }
        return false;
    }

    private void selectAlignment(MouseEvent e2, ReferenceFrame frame) {
        double location = frame.getChromosomePosition(e2.getX());
        double displayLocation = location + 1.0;
        Alignment alignment = this.getAlignmentAt(displayLocation, e2.getY(), frame);
        if (alignment != null) {
            if (this.selectedReadNames.containsKey(alignment.getReadName())) {
                this.selectedReadNames.remove(alignment.getReadName());
            } else {
                this.setSelected(alignment);
            }
        }
    }

    private void setSelected(Alignment alignment) {
        Color c2 = alignment.isPaired() && alignment.getMate() != null && alignment.getMate().isMapped() ? ColorUtilities.randomColor(this.selectionColorIndex++) : Color.black;
        this.selectedReadNames.put(alignment.getReadName(), c2);
    }

    private void refresh() {
        IGV.getInstance().repaintDataPanels();
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> attrs = super.getPersistentState();
        attrs.putAll(this.renderOptions.getPersistentState());
        return attrs;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        this.renderOptions.restorePersistentState(attributes);
    }

    class PopupMenu
    extends IGVPopupMenu {
        PopupMenu(TrackClickEvent e2) {
            ArrayList<Track> tracks = new ArrayList<Track>();
            tracks.add(AlignmentTrack.this);
            JLabel popupTitle = new JLabel("  " + AlignmentTrack.this.getName(), 0);
            Font newFont = this.getFont().deriveFont(1, 12.0f);
            popupTitle.setFont(newFont);
            if (popupTitle != null) {
                this.add(popupTitle);
            }
            this.addSeparator();
            this.add(TrackMenuUtils.getTrackRenameItem(tracks));
            this.addCopyToClipboardItem(e2);
            this.addSeparator();
            this.addSortMenuItem();
            this.addPackMenuItem();
            this.addCoverageDepthMenuItem();
            this.addSeparator();
            this.addColorByMenuItem();
            this.addShadeBaseMenuItem();
            this.addShowAllBasesMenuItem();
            this.addSeparator();
            this.addViewAsPairsMenuItem();
            this.addGoToMate(e2);
            this.showMateRegion(e2);
            this.addInsertSizeMenuItem();
            this.addSeparator();
            this.addShowCoverageItem();
            this.addLoadCoverageDataItem();
            this.addSeparator();
            TrackMenuUtils.addDisplayModeItems(tracks, this);
            this.addSeparator();
            this.addSelecteByNameItem();
            this.addClearSelectionsMenuItem();
            this.addSeparator();
            this.add(TrackMenuUtils.getRemoveMenuItem(tracks));
        }

        public void addSelecteByNameItem() {
            JMenuItem item = new JMenuItem("Select by name...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String val = MessageUtils.showInputDialog("Enter read name: ");
                    if (val != null && val.trim().length() > 0) {
                        AlignmentTrack.this.selectedReadNames.put(val, ColorUtilities.randomColor(AlignmentTrack.this.selectedReadNames.size() + 1));
                        AlignmentTrack.this.refresh();
                    }
                }
            });
            this.add(item);
        }

        public void addSortMenuItem() {
            JMenu item = new JMenu("Sort alignments");
            JMenuItem m1 = new JMenuItem("by start location");
            m1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().getTrackManager().sortAlignmentTracks(SortOption.START);
                    AlignmentTrack.this.refresh();
                }
            });
            item.add(m1);
            JMenuItem m2 = new JMenuItem("by strand");
            m2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().getTrackManager().sortAlignmentTracks(SortOption.STRAND);
                    AlignmentTrack.this.refresh();
                }
            });
            item.add(m2);
            JMenuItem m3 = new JMenuItem("by base");
            m3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().getTrackManager().sortAlignmentTracks(SortOption.NUCELOTIDE);
                    AlignmentTrack.this.refresh();
                }
            });
            item.add(m3);
            JMenuItem m4 = new JMenuItem("by mapping quality");
            m4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().getTrackManager().sortAlignmentTracks(SortOption.QUALITY);
                    AlignmentTrack.this.refresh();
                }
            });
            item.add(m4);
            JMenuItem m5 = new JMenuItem("by sample");
            m5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().getTrackManager().sortAlignmentTracks(SortOption.SAMPLE);
                    AlignmentTrack.this.refresh();
                }
            });
            item.add(m5);
            JMenuItem m6 = new JMenuItem("by read group");
            m6.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().getTrackManager().sortAlignmentTracks(SortOption.READ_GROUP);
                    AlignmentTrack.this.refresh();
                }
            });
            item.add(m6);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                JMenuItem m7 = new JMenuItem("by insert size");
                m7.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        IGV.getInstance().getTrackManager().sortAlignmentTracks(SortOption.INSERT_SIZE);
                        AlignmentTrack.this.refresh();
                    }
                });
                item.add(m7);
            }
            this.add(item);
        }

        private void setColorOption(ColorOption option) {
            colorByOption = option;
            PreferenceManager.getInstance().put("SAM.COLOR_BY", option.toString());
        }

        public void addColorByMenuItem() {
            JMenu colorMenu = new JMenu("Color alignments");
            ButtonGroup group = new ButtonGroup();
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                JRadioButtonMenuItem m1 = new JRadioButtonMenuItem("by insert size");
                m1.setSelected(colorByOption == ColorOption.INSERT_SIZE);
                m1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        PopupMenu.this.setColorOption(ColorOption.INSERT_SIZE);
                        AlignmentTrack.this.refresh();
                    }
                });
                colorMenu.add(m1);
                group.add(m1);
                JRadioButtonMenuItem m1a = new JRadioButtonMenuItem("by pair orientation");
                m1a.setSelected(colorByOption == ColorOption.PAIR_ORIENTATION);
                m1a.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        PopupMenu.this.setColorOption(ColorOption.PAIR_ORIENTATION);
                        AlignmentTrack.this.refresh();
                    }
                });
                colorMenu.add(m1a);
                group.add(m1a);
            }
            JRadioButtonMenuItem m2 = new JRadioButtonMenuItem("by read strand");
            m2.setSelected(colorByOption == ColorOption.READ_STRAND);
            m2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    PopupMenu.this.setColorOption(ColorOption.READ_STRAND);
                    AlignmentTrack.this.refresh();
                }
            });
            colorMenu.add(m2);
            group.add(m2);
            JRadioButtonMenuItem m4 = new JRadioButtonMenuItem("by read group");
            m4.setSelected(colorByOption == ColorOption.READ_GROUP);
            m4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    PopupMenu.this.setColorOption(ColorOption.READ_GROUP);
                    AlignmentTrack.this.refresh();
                }
            });
            colorMenu.add(m4);
            group.add(m4);
            JRadioButtonMenuItem m5 = new JRadioButtonMenuItem("by sample");
            m5.setSelected(colorByOption == ColorOption.SAMPLE);
            m5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    PopupMenu.this.setColorOption(ColorOption.SAMPLE);
                    AlignmentTrack.this.refresh();
                }
            });
            colorMenu.add(m5);
            group.add(m5);
            this.add(colorMenu);
        }

        public void addPackMenuItem() {
            JMenuItem item = new JMenuItem("Re-pack alignments");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            IGV.getInstance().getTrackManager().packAlignmentTracks();
                            AlignmentTrack.this.refresh();
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addCopyToClipboardItem(final TrackClickEvent te) {
            MouseEvent me = te.getMouseEvent();
            JMenuItem item = new JMenuItem("Copy read details to clipboard");
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                final double location = frame.getChromosomePosition(me.getX());
                double displayLocation = location + 1.0;
                final Alignment alignment = AlignmentTrack.this.getAlignmentAt(displayLocation, me.getY(), frame);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.copyToClipboard(te, alignment, location);
                    }
                });
                if (alignment == null) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void addViewAsPairsMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("View as pairs");
            item.setSelected(AlignmentTrack.this.dataManager.isLoadAsPairs());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    AlignmentTrack.this.dataManager.setLoadAsPairs(item.isSelected());
                    AlignmentTrack.this.refresh();
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addGoToMate(final TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Go to mate");
            MouseEvent e2 = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(e2.getX());
                double displayLocation = location + 1.0;
                final Alignment alignment = AlignmentTrack.this.getAlignmentAt(displayLocation, e2.getY(), frame);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.gotoMate(te, alignment);
                    }
                });
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void showMateRegion(final TrackClickEvent te) {
            JMenuItem item = new JMenuItem("View mate region in split screen");
            MouseEvent e2 = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(e2.getX());
                double displayLocation = location + 1.0;
                final Alignment alignment = AlignmentTrack.this.getAlignmentAt(displayLocation, e2.getY(), frame);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.splitScreenMate(te, alignment);
                    }
                });
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void addClearSelectionsMenuItem() {
            JMenuItem item = new JMenuItem("Clear selections");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    AlignmentTrack.this.selectedReadNames.clear();
                    AlignmentTrack.this.refresh();
                }
            });
            this.add(item);
        }

        public void addShowAllBasesMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show all bases");
            item.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.showAllBases);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    ((AlignmentTrack)AlignmentTrack.this).renderOptions.showAllBases = item.isSelected();
                    AlignmentTrack.this.refresh();
                }
            });
            this.add(item);
        }

        public void addCoverageDepthMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set maximum coverage depth ...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    int maxLevels = AlignmentTrack.this.dataManager.getMaxLevels();
                    String val = MessageUtils.showInputDialog("Maximum coverage depth", String.valueOf(maxLevels));
                    try {
                        int newMaxLevels = Integer.parseInt(val);
                        if (newMaxLevels != maxLevels) {
                            AlignmentTrack.this.dataManager.setMaxLevels(newMaxLevels);
                            AlignmentTrack.this.refresh();
                        }
                    }
                    catch (NumberFormatException ex) {
                        MessageUtils.showMessage("Insert size must be an integer value: " + val);
                    }
                }
            });
            this.add(item);
        }

        public void addInsertSizeMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set insert size options ...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    InsertSizeSettingsDialog dlg = new InsertSizeSettingsDialog(IGV.getMainFrame(), AlignmentTrack.this.renderOptions);
                    dlg.setModal(true);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        AlignmentTrack.this.renderOptions.setComputeIsizes(dlg.isComputeIsize());
                        AlignmentTrack.this.renderOptions.setMinInsertSizePercentile(dlg.getMinPercentile());
                        AlignmentTrack.this.renderOptions.setMaxInsertSizePercentile(dlg.getMaxPercentile());
                        if (AlignmentTrack.this.renderOptions.isComputeIsizes()) {
                            AlignmentTrack.this.dataManager.updatePEStats(AlignmentTrack.this.renderOptions);
                        }
                        AlignmentTrack.this.renderOptions.setMinInsertSize(dlg.getMinThreshold());
                        AlignmentTrack.this.renderOptions.setMaxInsertSize(dlg.getMaxThreshold());
                        AlignmentTrack.this.refresh();
                    }
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addShadeBaseMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade base by quality");
            item.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBases);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            ((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBases = item.isSelected();
                            AlignmentTrack.this.refresh();
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addShowCoverageItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show coverage track");
            item.setSelected(AlignmentTrack.this.getCoverageTrack() != null && AlignmentTrack.this.getCoverageTrack().isVisible());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            if (AlignmentTrack.this.getCoverageTrack() != null) {
                                AlignmentTrack.this.getCoverageTrack().setVisible(item.isSelected());
                                AlignmentTrack.this.refresh();
                                IGV.getInstance().repaintNamePanels();
                            }
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addLoadCoverageDataItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Load coverage data...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            FileChooserDialog trackFileDialog = IGV.getInstance().getTrackFileChooser();
                            trackFileDialog.setMultiSelectionEnabled(false);
                            trackFileDialog.setVisible(true);
                            if (!trackFileDialog.isCanceled()) {
                                File file = trackFileDialog.getSelectedFile();
                                String path = file.getAbsolutePath();
                                if (path.endsWith(".tdf") || path.endsWith(".tdf")) {
                                    TDFReader reader = TDFReader.getReader(file.getAbsolutePath());
                                    TDFDataSource ds = new TDFDataSource(reader, 0, PopupMenu.this.getName() + " coverage", AlignmentTrack.this.genome);
                                    AlignmentTrack.this.getCoverageTrack().setDataSource(ds);
                                    AlignmentTrack.this.refresh();
                                } else if (path.endsWith(".counts")) {
                                    GobyCountArchiveDataSource ds = new GobyCountArchiveDataSource(file);
                                    AlignmentTrack.this.getCoverageTrack().setDataSource(ds);
                                } else {
                                    MessageUtils.showMessage("Coverage data must be in .tdf format");
                                }
                            }
                        }
                    });
                }
            });
            this.add(item);
        }
    }

    public static class RenderOptions {
        boolean shadeBases;
        boolean shadeCenters;
        boolean flagUnmappedPairs;
        boolean showAllBases;
        private boolean computeIsizes;
        private int minInsertSize;
        private int maxInsertSize;
        private double minInsertSizePercentile;
        private double maxInsertSizePercentile;
        ColorOption colorOption;
        private boolean viewPairs = false;
        Map<String, PEStats> peStats;

        RenderOptions() {
            PreferenceManager prefs = PreferenceManager.getInstance();
            this.shadeBases = prefs.getAsBoolean("SAM.SHADE_BASE_QUALITY");
            this.shadeCenters = prefs.getAsBoolean("SAM.SHADE_CENTER");
            this.flagUnmappedPairs = prefs.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR");
            this.computeIsizes = prefs.getAsBoolean("SAM.COMPUTE_ISIZES");
            this.minInsertSize = prefs.getAsInt("SAM.MIN_INSERT_SIZE_THRESHOLD");
            this.maxInsertSize = prefs.getAsInt("SAM.INSERT_SIZE_THRESHOLD");
            this.minInsertSizePercentile = prefs.getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE");
            this.maxInsertSizePercentile = prefs.getAsFloat("SAM.ISIZE_MAX_PERCENTILE");
            this.showAllBases = false;
            this.colorOption = colorByOption;
        }

        public Map<String, String> getPersistentState() {
            HashMap<String, String> attributes = new HashMap<String, String>();
            PreferenceManager prefs = PreferenceManager.getInstance();
            if (this.shadeBases != prefs.getAsBoolean("SAM.SHADE_BASE_QUALITY")) {
                attributes.put("shadeBases", String.valueOf(this.shadeBases));
            }
            if (this.shadeCenters != prefs.getAsBoolean("SAM.SHADE_CENTER")) {
                attributes.put("shadeCenters", String.valueOf(this.shadeBases));
            }
            if (this.flagUnmappedPairs != prefs.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR")) {
                attributes.put("flagUnmappedPairs", String.valueOf(this.flagUnmappedPairs));
            }
            if (this.maxInsertSize != prefs.getAsInt("SAM.INSERT_SIZE_THRESHOLD")) {
                attributes.put("insertSizeThreshold", String.valueOf(this.maxInsertSize));
            }
            if (this.getMinInsertSize() != prefs.getAsInt("SAM.MIN_INSERT_SIZE_THRESHOLD")) {
                attributes.put("minInsertSizeThreshold", String.valueOf(this.maxInsertSize));
            }
            if (this.showAllBases) {
                attributes.put("showAllBases", String.valueOf(this.showAllBases));
            }
            if (this.colorOption != DEFAULT_COLOR_OPTION) {
                attributes.put("colorOption", colorByOption.toString());
            }
            return attributes;
        }

        public void restorePersistentState(Map<String, String> attributes) {
            String value = attributes.get("insertSizeThreshold");
            if (value != null) {
                this.maxInsertSize = Integer.parseInt(value);
            }
            if ((value = attributes.get("minInsertSizeThreshold")) != null) {
                this.setMinInsertSize(Integer.parseInt(value));
            }
            if ((value = attributes.get("shadeBases")) != null) {
                this.shadeBases = Boolean.parseBoolean(value);
            }
            if ((value = attributes.get("shadeCenters")) != null) {
                this.shadeCenters = Boolean.parseBoolean(value);
            }
            if ((value = attributes.get("flagUnmappedPairs")) != null) {
                this.flagUnmappedPairs = Boolean.parseBoolean(value);
            }
            if ((value = attributes.get("showAllBases")) != null) {
                this.showAllBases = Boolean.parseBoolean(value);
            }
            if ((value = attributes.get("colorOption")) != null) {
                this.colorOption = ColorOption.valueOf(value);
                colorByOption = this.colorOption;
            }
        }

        public int getMinInsertSize() {
            return this.minInsertSize;
        }

        public void setMinInsertSize(int minInsertSize) {
            this.minInsertSize = minInsertSize;
        }

        public int getMaxInsertSize() {
            return this.maxInsertSize;
        }

        public boolean isViewPairs() {
            return this.viewPairs;
        }

        public void setViewPairs(boolean viewPairs) {
            this.viewPairs = viewPairs;
        }

        public boolean isComputeIsizes() {
            return this.computeIsizes;
        }

        public void setComputeIsizes(boolean computeIsizes) {
            this.computeIsizes = computeIsizes;
        }

        public double getMinInsertSizePercentile() {
            return this.minInsertSizePercentile;
        }

        public void setMinInsertSizePercentile(double minInsertSizePercentile) {
            this.minInsertSizePercentile = minInsertSizePercentile;
        }

        public double getMaxInsertSizePercentile() {
            return this.maxInsertSizePercentile;
        }

        public void setMaxInsertSizePercentile(double maxInsertSizePercentile) {
            this.maxInsertSizePercentile = maxInsertSizePercentile;
        }

        public void setMaxInsertSize(int maxInsertSize) {
            this.maxInsertSize = maxInsertSize;
        }
    }

    public static enum ColorOption {
        INSERT_SIZE,
        READ_STRAND,
        FRAGMENT_STRAND,
        PAIR_ORIENTATION,
        SAMPLE,
        READ_GROUP;

    }

    public static enum SortOption {
        START,
        STRAND,
        NUCELOTIDE,
        QUALITY,
        SAMPLE,
        READ_GROUP,
        INSERT_SIZE;

    }
}

