/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.PairedAlignment;

public class AlignmentPacker {
    private static Logger log = Logger.getLogger(AlignmentPacker.class);
    public static final int MIN_ALIGNMENT_SPACING = 5;
    private static final int MAX_ROWS = 100000;
    private Comparator lengthComparator = new Comparator<Alignment>(){

        @Override
        public int compare(Alignment row1, Alignment row2) {
            return row2.getEnd() - row2.getStart() - (row1.getEnd() - row2.getStart());
        }
    };

    public List<AlignmentInterval.Row> packAlignments(Iterator<Alignment> iter, int end, boolean pairAlignments, AlignmentTrack.SortOption groupBy, int maxLevels) {
        ArrayList<AlignmentInterval.Row> alignmentRows = new ArrayList<AlignmentInterval.Row>(1000);
        if (iter == null || !iter.hasNext()) {
            return alignmentRows;
        }
        if (groupBy == null) {
            this.pack(iter, end, pairAlignments, this.lengthComparator, alignmentRows, maxLevels);
        } else {
            ArrayList<Alignment> nullGroup = new ArrayList<Alignment>();
            HashMap<String, ArrayList<Alignment>> groupedAlignments = new HashMap<String, ArrayList<Alignment>>();
            while (iter.hasNext()) {
                Alignment al = iter.next();
                String groupKey = this.getGroupValue(al, groupBy);
                if (groupKey == null) {
                    nullGroup.add(al);
                    continue;
                }
                ArrayList<Alignment> group = (ArrayList<Alignment>)groupedAlignments.get(groupKey);
                if (group == null) {
                    group = new ArrayList<Alignment>(1000);
                    groupedAlignments.put(groupKey, group);
                }
                group.add(al);
            }
            ArrayList keys = new ArrayList(groupedAlignments.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                List group = (List)groupedAlignments.get(key);
                this.pack(group.iterator(), end, pairAlignments, this.lengthComparator, alignmentRows, maxLevels);
            }
            this.pack(nullGroup.iterator(), end, pairAlignments, this.lengthComparator, alignmentRows, maxLevels);
        }
        return alignmentRows;
    }

    private String getGroupValue(Alignment al, AlignmentTrack.SortOption groupBy) {
        switch (groupBy) {
            case STRAND: {
                return String.valueOf(al.isNegativeStrand());
            }
            case SAMPLE: {
                return al.getSample();
            }
            case READ_GROUP: {
                return al.getReadGroup();
            }
        }
        return null;
    }

    private void pack(Iterator<Alignment> iter, int end, boolean pairAlignments, Comparator lengthComparator, List<AlignmentInterval.Row> alignmentRows, int maxLevels) {
        PriorityQueue<Alignment> firstBucket;
        if (!iter.hasNext()) {
            return;
        }
        HashMap<String, PairedAlignment> pairs = null;
        if (pairAlignments) {
            pairs = new HashMap<String, PairedAlignment>(1000);
        }
        Alignment firstAlignment = iter.next();
        if (pairAlignments && firstAlignment.isPaired() && firstAlignment.isProperPair() && firstAlignment.getMate().isMapped()) {
            String readName = firstAlignment.getReadName();
            PairedAlignment pair = new PairedAlignment(firstAlignment);
            pairs.put(readName, pair);
            firstAlignment = pair;
        }
        int start = firstAlignment.getStart();
        int bucketCount = end - start + 1;
        PriorityQueue[] bucketArray = new PriorityQueue[bucketCount];
        bucketArray[0] = firstBucket = new PriorityQueue<Alignment>(5, lengthComparator);
        firstBucket.add(firstAlignment);
        int totalCount = 1;
        while (iter.hasNext()) {
            int bucketNumber;
            Alignment al = iter.next();
            String readName = al.getReadName();
            if (!al.isMapped()) continue;
            Alignment alignment = al;
            if (pairAlignments && al.isPaired() && al.getMate().isMapped() && al.getChr().equals(al.getMate().getChr())) {
                PairedAlignment pair = (PairedAlignment)pairs.get(readName);
                if (pair == null) {
                    pair = new PairedAlignment(al);
                    pairs.put(readName, pair);
                    alignment = pair;
                } else if (al.getChr().equals(pair.getChr())) {
                    pair.setSecondAlignment(al);
                    pairs.remove(readName);
                    continue;
                }
            }
            if ((bucketNumber = Math.max(0, alignment.getStart() - start)) < bucketCount) {
                PriorityQueue<Alignment> bucket = bucketArray[bucketNumber];
                if (bucket == null) {
                    bucketArray[bucketNumber] = bucket = new PriorityQueue<Alignment>(5, lengthComparator);
                }
                bucket.add(alignment);
                ++totalCount;
                continue;
            }
            log.debug("Alignment out of bounds: " + alignment.getStart() + " (> " + end);
        }
        long t0 = System.currentTimeMillis();
        int allocatedCount = 0;
        int nextStart = start;
        AlignmentInterval.Row currentRow = new AlignmentInterval.Row();
        while (allocatedCount < totalCount) {
            while (nextStart <= end) {
                AbstractQueue bucket = null;
                while (bucket == null && nextStart <= end) {
                    int bucketNumber = nextStart - start;
                    bucket = bucketArray[bucketNumber];
                    if (bucket != null) continue;
                    ++nextStart;
                }
                if (bucket == null) continue;
                Alignment alignment = (Alignment)bucket.remove();
                if (bucket.isEmpty()) {
                    bucketArray[nextStart - start] = null;
                }
                currentRow.addAlignment(alignment);
                nextStart = currentRow.getLastEnd() + 5;
                ++allocatedCount;
            }
            if (currentRow.alignments.size() > 0) {
                alignmentRows.add(currentRow);
            }
            currentRow = new AlignmentInterval.Row();
            nextStart = start;
        }
        if (log.isDebugEnabled()) {
            long dt = System.currentTimeMillis() - t0;
            log.debug("Packed alignments in " + dt);
        }
        if (currentRow != null && currentRow.alignments.size() > 0) {
            alignmentRows.add(currentRow);
        }
    }
}

