/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.ui.panel.ReferenceFrame;

public class AlignmentInterval
extends Locus {
    private static Logger log = Logger.getLogger(AlignmentInterval.class);
    private String genomeId;
    private byte[] reference;
    private int maxCount = 0;
    private List<AlignmentCounts> counts;
    private List<Row> alignmentRows;
    private List<SpliceJunctionFeature> spliceJunctions = null;

    public AlignmentInterval(String genomeId, String chr, int start, int end, List<Row> rows, List<AlignmentCounts> counts) {
        super(chr, start, end);
        this.genomeId = genomeId;
        this.alignmentRows = rows;
        this.reference = SequenceManager.readSequence(this.genomeId, chr, start, end);
        this.counts = counts;
        for (AlignmentCounts c2 : counts) {
            this.maxCount = Math.max(this.maxCount, c2.getMaxCount());
        }
        boolean showSpliceJunctionTrack = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
        if (showSpliceJunctionTrack) {
            try {
                this.getSpliceJunctions();
            }
            catch (IOException e2) {
                log.error("Error computing splice junctions", e2);
            }
        }
    }

    public boolean contains(String genomeId, String chr, int start, int end) {
        return this.genomeId.equals(genomeId) && this.contains(chr, start, end);
    }

    public boolean overlaps(String genomeId, String chr, int start, int end) {
        return this.genomeId.equals(genomeId) && this.overlaps(chr, start, end);
    }

    public int getDepth() {
        return this.alignmentRows.size();
    }

    static Alignment getFeatureContaining(List<Alignment> features, int right) {
        int leftBounds = 0;
        int rightBounds = features.size() - 1;
        int idx = features.size() / 2;
        int lastIdx = -1;
        while (idx != lastIdx) {
            lastIdx = idx;
            Alignment f2 = features.get(idx);
            if (f2.contains(right)) {
                return f2;
            }
            if (f2.getStart() > right) {
                rightBounds = idx;
                idx = (leftBounds + idx) / 2;
                continue;
            }
            leftBounds = idx;
            idx = (rightBounds + idx) / 2;
        }
        if (features.get(0).contains(right)) {
            return features.get(0);
        }
        if (features.get(rightBounds).contains(right)) {
            return features.get(rightBounds);
        }
        return null;
    }

    public List<Row> getAlignmentRows() {
        return this.alignmentRows;
    }

    public void setAlignmentRows(List<Row> alignmentRows) {
        this.alignmentRows = alignmentRows;
    }

    public void sortRows(AlignmentTrack.SortOption option, ReferenceFrame referenceFrame) {
        double center = referenceFrame.getCenter();
        this.sortRows(option, center);
    }

    public void sortRows(AlignmentTrack.SortOption option, double location) {
        if (this.alignmentRows == null) {
            return;
        }
        for (Row row : this.alignmentRows) {
            if (option == AlignmentTrack.SortOption.NUCELOTIDE) {
                // empty if block
            }
            row.updateScore(option, location, this);
        }
        Collections.sort(this.alignmentRows, new Comparator<Row>(){

            @Override
            public int compare(Row arg0, Row arg1) {
                if (arg0.getScore() > arg1.getScore()) {
                    return 1;
                }
                if (arg0.getScore() > arg1.getScore()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public byte getReference(int pos) {
        if (this.reference == null) {
            return 0;
        }
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.reference.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.reference[offset];
    }

    public List<AlignmentCounts> getCounts() {
        return this.counts;
    }

    public int getCount(int pos, byte b2) {
        for (AlignmentCounts c2 : this.counts) {
            if (pos < c2.getStart() || pos >= c2.getEnd()) continue;
            return c2.getCount(pos, b2);
        }
        return 0;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getTotalCount(int pos) {
        for (AlignmentCounts c2 : this.counts) {
            if (pos < c2.getStart() || pos >= c2.getEnd()) continue;
            return c2.getTotalCount(pos);
        }
        return 0;
    }

    public int getNegCount(int pos, byte b2) {
        for (AlignmentCounts c2 : this.counts) {
            if (pos < c2.getStart() || pos >= c2.getEnd()) continue;
            return c2.getNegCount(pos, b2);
        }
        return 0;
    }

    public int getPosCount(int pos, byte b2) {
        for (AlignmentCounts c2 : this.counts) {
            if (pos < c2.getStart() || pos >= c2.getEnd()) continue;
            return c2.getPosCount(pos, b2);
        }
        return 0;
    }

    public Iterator<Alignment> getAlignmentIterator() {
        return new AlignmentIterator();
    }

    public List<SpliceJunctionFeature> getSpliceJunctions() throws IOException {
        if (this.spliceJunctions == null) {
            this.spliceJunctions = SpliceJunctionHelper.computeFeatures(this.getAlignmentIterator());
        }
        return this.spliceJunctions;
    }

    class AlignmentIterator
    implements Iterator<Alignment> {
        PriorityQueue<Row> rows;
        Alignment nextAlignment;

        AlignmentIterator() {
            this.rows = new PriorityQueue<Row>(5, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    return o1.getNextStartPos() - o2.getNextStartPos();
                }
            });
            for (Row r : AlignmentInterval.this.alignmentRows) {
                r.resetIdx();
                this.rows.add(r);
            }
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public Alignment next() {
            Alignment tmp = this.nextAlignment;
            if (tmp != null) {
                this.advance();
            }
            return tmp;
        }

        private void advance() {
            this.nextAlignment = null;
            Row nextRow = null;
            block0: while (this.nextAlignment == null && !this.rows.isEmpty()) {
                while ((nextRow = this.rows.poll()) != null) {
                    if (!nextRow.hasNext()) continue;
                    this.nextAlignment = nextRow.nextAlignment();
                    continue block0;
                }
            }
            if (nextRow != null && this.nextAlignment != null) {
                this.rows.add(nextRow);
            }
        }

        @Override
        public void remove() {
        }
    }

    public static class Row {
        int nextIdx = 0;
        private double score = 0.0;
        List<Alignment> alignments = new ArrayList<Alignment>(100);
        private int start;
        private int lastEnd;

        public void addAlignment(Alignment alignment) {
            if (this.alignments.isEmpty()) {
                this.start = alignment.getStart();
            }
            this.alignments.add(alignment);
            this.lastEnd = alignment.getEnd();
        }

        public void updateScore(AlignmentTrack.SortOption option, double center, AlignmentInterval interval) {
            int adjustedCenter = (int)center;
            Alignment centerAlignment = AlignmentInterval.getFeatureContaining(this.alignments, adjustedCenter);
            if (centerAlignment == null) {
                this.setScore(Double.MAX_VALUE);
            } else {
                switch (option) {
                    case START: {
                        this.setScore(centerAlignment.getStart());
                        break;
                    }
                    case STRAND: {
                        this.setScore(centerAlignment.isNegativeStrand() ? -1.0 : 1.0);
                        break;
                    }
                    case NUCELOTIDE: {
                        byte base = centerAlignment.getBase(adjustedCenter);
                        byte ref = interval.getReference(adjustedCenter);
                        if (base == 78 || base == 110) {
                            this.setScore(2.147483646E9);
                            break;
                        }
                        if (base == ref) {
                            this.setScore(2.147483647E9);
                            break;
                        }
                        int count = interval.getCount(adjustedCenter, base);
                        byte phred = centerAlignment.getPhred(adjustedCenter);
                        float score = -((float)count + (float)phred / 100.0f);
                        this.setScore(score);
                        break;
                    }
                    case QUALITY: {
                        this.setScore(-centerAlignment.getMappingQuality());
                        break;
                    }
                    case SAMPLE: {
                        String sample = centerAlignment.getSample();
                        this.score = sample == null ? 0.0 : (double)sample.hashCode();
                        this.setScore(this.score);
                        break;
                    }
                    case READ_GROUP: {
                        String readGroup = centerAlignment.getReadGroup();
                        this.score = readGroup == null ? 0.0 : (double)readGroup.hashCode();
                        this.setScore(this.score);
                        break;
                    }
                    case INSERT_SIZE: {
                        this.setScore(-Math.abs(centerAlignment.getInferredInsertSize()));
                    }
                }
            }
        }

        public Alignment nextAlignment() {
            if (this.nextIdx < this.alignments.size()) {
                Alignment tmp = this.alignments.get(this.nextIdx);
                ++this.nextIdx;
                return tmp;
            }
            return null;
        }

        public int getNextStartPos() {
            if (this.nextIdx < this.alignments.size()) {
                return this.alignments.get(this.nextIdx).getStart();
            }
            return Integer.MAX_VALUE;
        }

        public boolean hasNext() {
            return this.nextIdx < this.alignments.size();
        }

        public void resetIdx() {
            this.nextIdx = 0;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double score) {
            this.score = score;
        }

        public int getStart() {
            return this.start;
        }

        public int getLastEnd() {
            return this.lastEnd;
        }
    }
}

