/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.peaks.Peak;

public class PeakParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Peak> loadPeaksBinary(InputStream stream) throws IOException {
        String chr;
        ArrayList<Peak> peaks = new ArrayList<Peak>(2000);
        DataInputStream reader = null;
        reader = new DataInputStream(new BufferedInputStream(stream));
        int nTimePoints = reader.readInt();
        while (!(chr = reader.readUTF()).equals("EOF")) {
            int nRows = reader.readInt();
            for (int r = 0; r < nRows; ++r) {
                int start = reader.readInt();
                int end = reader.readInt();
                float combinedScore = reader.readFloat();
                float[] timePointScores = new float[nTimePoints];
                for (int i2 = 0; i2 < nTimePoints; ++i2) {
                    timePointScores[i2] = reader.readFloat();
                }
                peaks.add(new Peak(chr, start, end, "", combinedScore, timePointScores));
            }
        }
        ArrayList<Peak> arrayList = peaks;
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Peak> loadPeaks(InputStream stream, int nTimePoints, String chr) throws IOException {
        String[] tokens;
        String nextLine;
        ArrayList<Peak> peaks = new ArrayList<Peak>(25000);
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(stream));
        while ((nextLine = reader.readLine()) != null) {
            if (nextLine.startsWith("#")) continue;
            tokens = nextLine.split("\t");
            if (tokens.length >= 7) break;
            throw new RuntimeException("Not enough columns for peak file. At least 2 time points are required");
        }
        while ((nextLine = reader.readLine()) != null && (tokens = nextLine.split("\t"))[0].equals(chr)) {
            int start = Integer.parseInt(tokens[1]);
            int end = Integer.parseInt(tokens[2]);
            String name = tokens[3];
            float combinedScore = Float.parseFloat(tokens[4]);
            float[] timePointScores = new float[nTimePoints];
            if (nTimePoints > tokens.length - 5) {
                System.out.println();
            }
            for (int i2 = 0; i2 < nTimePoints; ++i2) {
                timePointScores[i2] = Float.parseFloat(tokens[5 + i2]);
            }
            peaks.add(new Peak(chr, start, end, name, combinedScore, timePointScores));
        }
        ArrayList<Peak> arrayList = peaks;
        return arrayList;
    }
}

