/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.h5;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5AttributeException;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.exceptions.HDF5SymbolTableException;
import org.apache.log4j.Logger;
import org.broad.igv.h5.DataAccessException;
import org.broad.igv.h5.HDF5EntityCache;
import org.broad.igv.h5.HDF5Reader;
import org.broad.igv.h5.ObjectNotFoundException;
import org.broad.igv.util.ObjectCache;

public class HDF5LocalReader
implements HDF5Reader {
    private static Logger log = Logger.getLogger(HDF5LocalReader.class);
    public static int RDONLY = HDF5Constants.H5F_ACC_RDONLY;
    static ObjectCache<Integer, HDF5EntityCache> entityCaches = new ObjectCache();
    private int fileId = -1;

    public HDF5LocalReader(String path) {
        try {
            this.fileId = this.openFile(path, RDONLY);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private int openFile(String path, int mode) throws FileNotFoundException {
        try {
            this.fileId = H5.H5Fopen(path, mode, HDF5Constants.H5P_DEFAULT);
            entityCaches.put(this.fileId, new HDF5EntityCache(this.fileId));
            return this.fileId;
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error opening HDF5 file: " + path;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public void closeFile() {
        try {
            if (this.fileId > 0) {
                H5.H5Fclose(this.fileId);
                HDF5EntityCache cache = entityCaches.get(this.fileId);
                if (cache != null) {
                    cache.closeAllEntities();
                }
                this.fileId = -1;
            }
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error closing HDF5 file";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public int openDataset(String dsName) {
        HDF5EntityCache cache = entityCaches.get(this.fileId);
        if (cache == null) {
            cache = new HDF5EntityCache(this.fileId);
            entityCaches.put(this.fileId, cache);
        }
        return cache.openDataset(dsName);
    }

    @Override
    public void closeDataset(int datasetId) {
    }

    @Override
    public int openGroup(String name) {
        try {
            return H5.H5Gopen(this.fileId, name);
        }
        catch (HDF5SymbolTableException ex) {
            String msg = "Error opening group: " + name;
            if (log.isDebugEnabled()) {
                log.debug(msg, ex);
            }
            throw new ObjectNotFoundException(msg);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error opening group: " + name;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public void closeGroup(int groupId) {
        try {
            H5.H5Gclose(groupId);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error closing HDF5 group";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    private int getTypeForArray(Object array) {
        if (array instanceof Integer || array instanceof int[] || array instanceof int[][]) {
            return HDF5Constants.H5T_NATIVE_INT;
        }
        if (array instanceof Long || array instanceof long[] || array instanceof long[][]) {
            return HDF5Constants.H5T_NATIVE_LLONG;
        }
        if (array instanceof Float || array instanceof float[] || array instanceof float[][]) {
            return HDF5Constants.H5T_NATIVE_FLOAT;
        }
        if (array instanceof Number || array instanceof double[] || array instanceof double[][]) {
            return HDF5Constants.H5T_NATIVE_DOUBLE;
        }
        if (array instanceof char[]) {
            return this.createStringDatatype(1);
        }
        String msg = "Error: No HDF Type for: " + array.getClass().getName();
        log.error(msg);
        throw new DataAccessException("No HDF Type for: " + array.getClass().getName());
    }

    public int createStringDatatype(int strLength) {
        try {
            int tid = H5.H5Tcopy(HDF5Constants.H5T_C_S1);
            H5.H5Tset_size(tid, strLength);
            return tid;
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error creating string datatype. Length = " + strLength;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public float[] readDataRowSlice(int datasetId, int rowId, int fromIndex, int toIndex) {
        try {
            int dataspace = this.getDataspace(datasetId);
            int nPts = toIndex - fromIndex + 1;
            long[] offset = new long[2];
            long[] count = new long[2];
            offset[0] = rowId;
            offset[1] = fromIndex;
            count[0] = 1L;
            count[1] = nPts;
            int status1 = H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
            long[] memDims = new long[]{nPts};
            int memspace = H5.H5Screate_simple(1, memDims, null);
            float[] partialData = new float[nPts];
            H5.H5Dread(datasetId, HDF5Constants.H5T_NATIVE_FLOAT, memspace, dataspace, HDF5Constants.H5P_DEFAULT, partialData);
            return partialData;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading data row";
            log.error(msg);
            throw new DataAccessException(msg);
        }
    }

    @Override
    public float[][] readDataSlice(int datasetId, int fromIndex, int toIndex) {
        try {
            int dataspace = this.getDataspace(datasetId);
            int nPts = toIndex - fromIndex + 1;
            long[] dims = this.getDims(datasetId);
            int nRows = (int)dims[0];
            long[] offset = new long[2];
            long[] count = new long[2];
            offset[0] = 0L;
            offset[1] = fromIndex;
            count[0] = nRows;
            count[1] = nPts;
            int status1 = H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
            long[] memDims = new long[]{nRows, nPts};
            int memspace = H5.H5Screate_simple(2, memDims, null);
            float[][] partialData = new float[nRows][nPts];
            H5.H5Dread(datasetId, HDF5Constants.H5T_NATIVE_FLOAT, memspace, dataspace, HDF5Constants.H5P_DEFAULT, partialData);
            return partialData;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading data";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public double readDoubleAttribute(int groupId, String name) {
        try {
            int attrId = H5.H5Aopen_name(groupId, name);
            double[] buffer = new double[1];
            H5.H5Aread(attrId, HDF5Constants.H5T_NATIVE_DOUBLE, buffer);
            H5.H5Aclose(attrId);
            return buffer[0];
        }
        catch (HDF5AttributeException e2) {
            throw new ObjectNotFoundException("Attribute not found: " + name);
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading attribute from dataset";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public int readIntegerAttribute(int groupId, String name) throws ObjectNotFoundException {
        try {
            int attrId = H5.H5Aopen_name(groupId, name);
            int[] buffer = new int[1];
            H5.H5Aread(attrId, HDF5Constants.H5T_NATIVE_INT, buffer);
            H5.H5Aclose(attrId);
            return buffer[0];
        }
        catch (HDF5AttributeException e2) {
            throw new ObjectNotFoundException("Attribute not found: " + name);
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading attribute from dataset";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public long readLongAttribute(int groupId, String name) {
        try {
            int attrId = H5.H5Aopen_name(groupId, name);
            long[] buffer = new long[1];
            H5.H5Aread(attrId, HDF5Constants.H5T_NATIVE_LONG, buffer);
            H5.H5Aclose(attrId);
            return buffer[0];
        }
        catch (HDF5AttributeException e2) {
            throw new ObjectNotFoundException("Attribute not found: " + name);
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading attribute from dataset";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public String readStringAttribute(int groupId, String name) {
        try {
            int attrId = H5.H5Aopen_name(groupId, name);
            int type = H5.H5Aget_type(attrId);
            int size = H5.H5Tget_size(type);
            byte[] buffer = new byte[2 * size];
            H5.H5Aread(attrId, type, buffer);
            H5.H5Aclose(attrId);
            return new String(buffer).trim();
        }
        catch (HDF5AttributeException e2) {
            throw new ObjectNotFoundException("Attribute not found: " + name);
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading attribute from dataset";
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    public void closeAttribute(int attId) {
        try {
            H5.H5Aclose(attId);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error closing attribute";
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    private long[] getDims(int datasetId) {
        try {
            int dataspace = H5.H5Dget_space(datasetId);
            int nDims = H5.H5Sget_simple_extent_ndims(dataspace);
            long[] dims = new long[nDims];
            long[] maxDims = new long[nDims];
            H5.H5Sget_simple_extent_dims(dataspace, dims, maxDims);
            return dims;
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error getting dataset dimensions";
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    private int getDataspace(int datasetId) {
        try {
            return H5.H5Dget_space(datasetId);
        }
        catch (HDF5LibraryException ex) {
            String msg = "Error getting dataspace";
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public List<String> readAllStrings(int datasetId) {
        try {
            long[] dims = this.getDims(datasetId);
            int typeId = H5.H5Dget_type(datasetId);
            int numberOfStrings = 1;
            for (int i2 = 0; i2 < dims.length; ++i2) {
                numberOfStrings *= (int)dims[i2];
            }
            int stringLength = H5.H5Tget_size(typeId);
            int bufferSize = numberOfStrings * stringLength;
            byte[] byteBuff = new byte[bufferSize];
            int mspace = HDF5Constants.H5S_ALL;
            int fspace = HDF5Constants.H5S_ALL;
            int plist = HDF5Constants.H5P_DEFAULT;
            H5.H5Dread(datasetId, typeId, mspace, fspace, plist, byteBuff);
            ArrayList<String> strOut = new ArrayList<String>(numberOfStrings);
            for (int i3 = 0; i3 < numberOfStrings; ++i3) {
                strOut.add(new String(byteBuff, i3 * stringLength, stringLength).trim());
            }
            return strOut;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading String dataset";
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public float[] readAllFloats(int datasetId) {
        try {
            int size = (int)this.getDims(datasetId)[0];
            float[] data = new float[size];
            H5.H5Dread(datasetId, HDF5Constants.H5T_NATIVE_FLOAT, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
            return data;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading Float dataset";
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public int[] readAllInts(int datasetId) {
        try {
            int size = (int)this.getDims(datasetId)[0];
            int[] data = new int[size];
            H5.H5Dread(datasetId, HDF5Constants.H5T_NATIVE_INT, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
            return data;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading Int dataset";
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    @Override
    public float[] readFloats(int datasetId, int fromIndex, int toIndex) {
        try {
            int dataspace = this.getDataspace(datasetId);
            int nPts = toIndex - fromIndex + 1;
            long[] offset = new long[1];
            long[] count = new long[1];
            offset[0] = fromIndex;
            count[0] = nPts;
            H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
            long[] memDims = new long[]{nPts};
            int memspace = H5.H5Screate_simple(1, memDims, null);
            long[] memOffset = new long[]{0L};
            long[] memCount = new long[]{nPts};
            H5.H5Sselect_hyperslab(memspace, HDF5Constants.H5S_SELECT_SET, memOffset, null, memCount, null);
            float[] partialData = new float[nPts];
            H5.H5Dread(datasetId, HDF5Constants.H5T_NATIVE_FLOAT, memspace, dataspace, HDF5Constants.H5P_DEFAULT, partialData);
            return partialData;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading floats from " + fromIndex + " to " + toIndex;
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    public double[] readDoubles(int datasetId, int fromIndex, int toIndex) {
        try {
            int dataspace = this.getDataspace(datasetId);
            int nPts = toIndex - fromIndex + 1;
            long[] offset = new long[1];
            long[] count = new long[1];
            offset[0] = fromIndex;
            count[0] = nPts;
            H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
            long[] memDims = new long[]{nPts};
            int memspace = H5.H5Screate_simple(1, memDims, null);
            long[] memOffset = new long[]{0L};
            long[] memCount = new long[]{nPts};
            H5.H5Sselect_hyperslab(memspace, HDF5Constants.H5S_SELECT_SET, memOffset, null, memCount, null);
            double[] partialData = new double[nPts];
            H5.H5Dread(datasetId, HDF5Constants.H5T_NATIVE_DOUBLE, memspace, dataspace, HDF5Constants.H5P_DEFAULT, partialData);
            return partialData;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading double from " + fromIndex + " to " + toIndex;
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    public long[] readLongs(int datasetId, int fromIndex, int toIndex) {
        try {
            int dataspace = this.getDataspace(datasetId);
            int nPts = toIndex - fromIndex + 1;
            long[] offset = new long[1];
            long[] count = new long[1];
            offset[0] = fromIndex;
            count[0] = nPts;
            H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
            long[] memDims = new long[]{nPts};
            int memspace = H5.H5Screate_simple(1, memDims, null);
            long[] memOffset = new long[]{0L};
            long[] memCount = new long[]{nPts};
            H5.H5Sselect_hyperslab(memspace, HDF5Constants.H5S_SELECT_SET, memOffset, null, memCount, null);
            long[] partialData = new long[nPts];
            H5.H5Dread(datasetId, HDF5Constants.H5T_NATIVE_LLONG, memspace, dataspace, HDF5Constants.H5P_DEFAULT, partialData);
            return partialData;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading longs from " + fromIndex + " to " + toIndex;
            log.error(msg);
            throw new DataAccessException(msg, ex);
        }
    }

    public int[] readInts(String dsName, int fromIndex, int toIndex) {
        int datasetId = this.openDataset(dsName);
        int[] ints = this.readInts(datasetId, fromIndex, toIndex);
        this.closeDataset(datasetId);
        return ints;
    }

    @Override
    public int[] readInts(int datasetId, int fromIndex, int toIndex) {
        try {
            int dataspace = this.getDataspace(datasetId);
            int nPts = toIndex - fromIndex + 1;
            long[] offset = new long[1];
            long[] count = new long[1];
            offset[0] = fromIndex;
            count[0] = nPts;
            H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
            long[] memDims = new long[]{nPts};
            int memspace = H5.H5Screate_simple(1, memDims, null);
            long[] memOffset = new long[]{0L};
            long[] memCount = new long[]{nPts};
            H5.H5Sselect_hyperslab(memspace, HDF5Constants.H5S_SELECT_SET, memOffset, null, memCount, null);
            int[] partialData = new int[nPts];
            H5.H5Dread(datasetId, HDF5Constants.H5T_NATIVE_INT, memspace, dataspace, HDF5Constants.H5P_DEFAULT, partialData);
            return partialData;
        }
        catch (HDF5Exception ex) {
            String msg = "Error reading ints from " + fromIndex + " to " + toIndex;
            log.error(msg, ex);
            throw new DataAccessException(msg, ex);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeFile();
    }
}

