/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.h5;

import java.util.HashMap;
import java.util.Map;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.exceptions.HDF5SymbolTableException;
import org.apache.log4j.Logger;
import org.broad.igv.h5.ObjectNotFoundException;

public class HDF5EntityCache {
    private Logger log = Logger.getLogger(HDF5EntityCache.class);
    int fileId;
    Map<String, Integer> datasetCache;
    Map<String, Integer> groupCache;

    public HDF5EntityCache(int fileId) {
        this.fileId = fileId;
        this.datasetCache = new HashMap<String, Integer>();
        this.groupCache = new HashMap<String, Integer>();
    }

    public synchronized void closeAllEntities() {
        for (Integer dsId : this.datasetCache.values()) {
            this.closeDataset(dsId);
        }
        this.datasetCache.clear();
    }

    public int openDataset(String dsName) {
        try {
            Integer dsId = this.datasetCache.get(dsName);
            if (dsId == null) {
                dsId = H5.H5Dopen(this.fileId, dsName);
                this.datasetCache.put(dsName, dsId);
            }
            return dsId;
        }
        catch (HDF5SymbolTableException ex) {
            throw new ObjectNotFoundException("Error opening dataset: " + dsName);
        }
        catch (HDF5LibraryException ex) {
            this.log.error("Error opening dataset", ex);
            throw new RuntimeException(ex);
        }
    }

    private void closeDataset(int datasetId) {
        try {
            H5.H5Dclose(datasetId);
        }
        catch (HDF5LibraryException ex) {
            this.log.error("Error closing dataset", ex);
            throw new RuntimeException("Error closing dataset");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.closeAllEntities();
        }
        finally {
            super.finalize();
        }
    }
}

