/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;

public class IGVPreferences {
    private static Logger log = Logger.getLogger(IGVPreferences.class);
    static Hashtable<String, String> sessionCache = new Hashtable();
    static Hashtable<String, String> cache = null;
    static Hashtable<String, String> overrides = new Hashtable();

    public void put(String key, String value) {
        sessionCache.remove(key);
        if (cache == null) {
            this.loadPreferences();
        }
        if (value == null) {
            cache.remove(key);
        } else {
            cache.put(key, value);
        }
        this.storePreferences();
    }

    public void putOverride(String key, String value) {
        overrides.put(key, value);
    }

    public String get(String key, String defaultValue) {
        if (overrides.containsKey(key)) {
            return overrides.get(key);
        }
        if (sessionCache.containsKey(key)) {
            return sessionCache.get(key);
        }
        String val = this.get(key);
        return val == null ? defaultValue : val;
    }

    public String get(String key) {
        if (cache == null) {
            this.loadPreferences();
        }
        return cache.get(key);
    }

    public void remove(String key) {
        sessionCache.remove(key);
        cache.remove(key);
        this.storePreferences();
    }

    public void clear() {
        cache.clear();
        this.storePreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadPreferences() {
        File prefFile;
        cache = new Hashtable();
        File rootDir = Globals.getIgvDirectory();
        if (!rootDir.exists()) {
            rootDir.mkdir();
        }
        if ((prefFile = new File(rootDir, "prefs.properties")).exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(prefFile));
                String nextLine = null;
                while ((nextLine = reader.readLine()) != null) {
                    int idx = nextLine.indexOf(61);
                    if (idx <= 0) continue;
                    String key = nextLine.substring(0, idx);
                    String value = nextLine.substring(idx + 1);
                    if (value.equals("null")) continue;
                    cache.put(key, value);
                }
            }
            catch (IOException e2) {
                log.error("Error loading preferences", e2);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    log.error("Error closing preferences file", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void storePreferences() {
        if (cache != null) {
            PrintWriter pw = null;
            try {
                File rootDir = Globals.getIgvDirectory();
                if (!rootDir.exists()) {
                    rootDir.mkdir();
                }
                File prefFile = new File(rootDir, "prefs.properties");
                pw = new PrintWriter(new BufferedWriter(new FileWriter(prefFile)));
                for (Map.Entry<String, String> entry : cache.entrySet()) {
                    pw.print(entry.getKey());
                    pw.print("=");
                    pw.println(entry.getValue());
                }
            }
            catch (IOException e2) {
                log.error("Error loading preferences", e2);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }
}

