/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.UnivariateRealSolverUtils;

public class BisectionSolver
extends UnivariateRealSolverImpl {
    private static final long serialVersionUID = 7137520585963699578L;

    public BisectionSolver(UnivariateRealFunction f2) {
        super(f2, 100, 1.0E-6);
    }

    public double solve(double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(min, max);
    }

    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        this.clearResult();
        this.verifyInterval(min, max);
        int i2 = 0;
        while (i2 < this.maximalIterationCount) {
            double m2 = UnivariateRealSolverUtils.midpoint(min, max);
            double fmin = this.f.value(min);
            double fm = this.f.value(m2);
            if (fm * fmin > 0.0) {
                min = m2;
            } else {
                max = m2;
            }
            if (Math.abs(max - min) <= this.absoluteAccuracy) {
                m2 = UnivariateRealSolverUtils.midpoint(min, max);
                this.setResult(m2, i2);
                return m2;
            }
            ++i2;
        }
        throw new ConvergenceException("Maximum number of iterations exceeded: " + this.maximalIterationCount);
    }
}

