/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.Glyph;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;

public final class SVGGVTGlyphVector
implements GVTGlyphVector {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    private GVTFont font;
    private Glyph[] glyphs;
    private FontRenderContext frc;
    private GeneralPath outline;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private Point2D endPos;
    private TextPaintInfo cacheTPI;

    public SVGGVTGlyphVector(GVTFont font, Glyph[] glyphs, FontRenderContext frc) {
        this.font = font;
        this.glyphs = glyphs;
        this.frc = frc;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds = new Shape[glyphs.length];
        this.glyphVisible = new boolean[glyphs.length];
        int i2 = 0;
        while (i2 < glyphs.length) {
            this.glyphVisible[i2] = true;
            ++i2;
        }
        this.endPos = glyphs[glyphs.length - 1].getPosition();
        this.endPos = new Point2D.Float((float)(this.endPos.getX() + (double)glyphs[glyphs.length - 1].getHorizAdvX()), (float)this.endPos.getY());
    }

    public GVTFont getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getGlyphCode(int glyphIndex) throws IndexOutOfBoundsException {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex " + glyphIndex + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        return this.glyphs[glyphIndex].getGlyphCode();
    }

    public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (numEntries < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + numEntries + ", is illegal. It must be > 0.");
        }
        if (beginGlyphIndex < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + beginGlyphIndex + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (beginGlyphIndex + numEntries > this.glyphs.length) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + beginGlyphIndex + "+" + numEntries + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (codeReturn == null) {
            codeReturn = new int[numEntries];
        }
        int i2 = beginGlyphIndex;
        while (i2 < beginGlyphIndex + numEntries) {
            codeReturn[i2 - beginGlyphIndex] = this.glyphs[i2].getGlyphCode();
            ++i2;
        }
        return codeReturn;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return null;
    }

    public Shape getGlyphLogicalBounds(int glyphIndex) {
        if (this.glyphLogicalBounds[glyphIndex] == null && this.glyphVisible[glyphIndex]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[glyphIndex];
    }

    private void computeGlyphLogicalBounds() {
        Rectangle2D ngb;
        Rectangle2D glyphBounds;
        float ascent = 0.0f;
        float descent = 0.0f;
        if (this.font != null) {
            GVTLineMetrics lineMetrics = this.font.getLineMetrics("By", this.frc);
            ascent = lineMetrics.getAscent();
            descent = lineMetrics.getDescent();
            if (descent < 0.0f) {
                descent = -descent;
            }
        }
        if (ascent == 0.0f) {
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            int i2 = 0;
            while (i2 < this.getNumGlyphs()) {
                if (this.glyphVisible[i2]) {
                    GVTGlyphMetrics glyphMetrics = this.getGlyphMetrics(i2);
                    Rectangle2D glyphBounds2 = glyphMetrics.getBounds2D();
                    ascent = (float)(-glyphBounds2.getMinY());
                    descent = (float)(glyphBounds2.getHeight() - (double)ascent);
                    if (ascent > maxAscent) {
                        maxAscent = ascent;
                    }
                    if (descent > maxDescent) {
                        maxDescent = descent;
                    }
                }
                ++i2;
            }
            ascent = maxAscent;
            descent = maxDescent;
        }
        Shape[] tempLogicalBounds = new Shape[this.getNumGlyphs()];
        boolean[] rotated = new boolean[this.getNumGlyphs()];
        double maxWidth = -1.0;
        double maxHeight = -1.0;
        int i3 = 0;
        while (i3 < this.getNumGlyphs()) {
            if (!this.glyphVisible[i3]) {
                tempLogicalBounds[i3] = null;
            } else {
                AffineTransform glyphTransform = this.getGlyphTransform(i3);
                GVTGlyphMetrics glyphMetrics = this.getGlyphMetrics(i3);
                Rectangle2D.Double glyphBounds3 = new Rectangle2D.Double(0.0, -ascent, glyphMetrics.getHorizontalAdvance(), ascent + descent);
                if (((RectangularShape)glyphBounds3).isEmpty()) {
                    rotated[i3] = i3 > 0 ? rotated[i3 - 1] : true;
                } else {
                    Point2D.Double p1 = new Point2D.Double(glyphBounds3.getMinX(), glyphBounds3.getMinY());
                    Point2D.Double p2 = new Point2D.Double(glyphBounds3.getMaxX(), glyphBounds3.getMinY());
                    Point2D.Double p3 = new Point2D.Double(glyphBounds3.getMinX(), glyphBounds3.getMaxY());
                    Point2D gpos = this.getGlyphPosition(i3);
                    AffineTransform tr = AffineTransform.getTranslateInstance(gpos.getX(), gpos.getY());
                    if (glyphTransform != null) {
                        tr.concatenate(glyphTransform);
                    }
                    tempLogicalBounds[i3] = tr.createTransformedShape(glyphBounds3);
                    Point2D.Double tp1 = new Point2D.Double();
                    Point2D.Double tp2 = new Point2D.Double();
                    Point2D.Double tp3 = new Point2D.Double();
                    tr.transform(p1, tp1);
                    tr.transform(p2, tp2);
                    tr.transform(p3, tp3);
                    double tdx12 = ((Point2D)tp1).getX() - ((Point2D)tp2).getX();
                    double tdx13 = ((Point2D)tp1).getX() - ((Point2D)tp3).getX();
                    double tdy12 = ((Point2D)tp1).getY() - ((Point2D)tp2).getY();
                    double tdy13 = ((Point2D)tp1).getY() - ((Point2D)tp3).getY();
                    rotated[i3] = Math.abs(tdx12) < 0.001 && Math.abs(tdy13) < 0.001 ? false : !(Math.abs(tdx13) < 0.001) || !(Math.abs(tdy12) < 0.001);
                    Rectangle2D rectBounds = tempLogicalBounds[i3].getBounds2D();
                    if (rectBounds.getWidth() > maxWidth) {
                        maxWidth = rectBounds.getWidth();
                    }
                    if (rectBounds.getHeight() > maxHeight) {
                        maxHeight = rectBounds.getHeight();
                    }
                }
            }
            ++i3;
        }
        GeneralPath logicalBoundsPath = new GeneralPath();
        int i4 = 0;
        while (i4 < this.getNumGlyphs()) {
            if (tempLogicalBounds[i4] != null) {
                logicalBoundsPath.append(tempLogicalBounds[i4], false);
            }
            ++i4;
        }
        Rectangle2D fullBounds = logicalBoundsPath.getBounds2D();
        if (fullBounds.getHeight() < maxHeight * 1.5) {
            int i5 = 0;
            while (i5 < this.getNumGlyphs()) {
                if (!rotated[i5] && tempLogicalBounds[i5] != null) {
                    double nw;
                    glyphBounds = tempLogicalBounds[i5].getBounds2D();
                    double x = glyphBounds.getMinX();
                    double width = glyphBounds.getWidth();
                    if (i5 < this.getNumGlyphs() - 1 && tempLogicalBounds[i5 + 1] != null && (ngb = tempLogicalBounds[i5 + 1].getBounds2D()).getX() > x && (nw = ngb.getX() - x) < width * 1.15 && nw > width * 0.85) {
                        double delta = (nw - width) * 0.5;
                        width += delta;
                        ngb.setRect(ngb.getX() - delta, ngb.getY(), ngb.getWidth() + delta, ngb.getHeight());
                    }
                    tempLogicalBounds[i5] = new Rectangle2D.Double(x, fullBounds.getMinY(), width, fullBounds.getHeight());
                }
                ++i5;
            }
        } else if (fullBounds.getWidth() < maxWidth * 1.5) {
            int i6 = 0;
            while (i6 < this.getNumGlyphs()) {
                if (!rotated[i6] && tempLogicalBounds[i6] != null) {
                    double nh;
                    glyphBounds = tempLogicalBounds[i6].getBounds2D();
                    double y = glyphBounds.getMinY();
                    double height = glyphBounds.getHeight();
                    if (i6 < this.getNumGlyphs() - 1 && tempLogicalBounds[i6 + 1] != null && (ngb = tempLogicalBounds[i6 + 1].getBounds2D()).getY() > y && (nh = ngb.getY() - y) < height * 1.15 && nh > height * 0.85) {
                        double delta = (nh - height) * 0.5;
                        height += delta;
                        ngb.setRect(ngb.getX(), ngb.getY() - delta, ngb.getWidth(), ngb.getHeight() + delta);
                    }
                    tempLogicalBounds[i6] = new Rectangle2D.Double(fullBounds.getMinX(), y, fullBounds.getWidth(), height);
                }
                ++i6;
            }
        }
        System.arraycopy(tempLogicalBounds, 0, this.glyphLogicalBounds, 0, this.getNumGlyphs());
    }

    public GVTGlyphMetrics getGlyphMetrics(int idx) {
        if (idx < 0 || idx > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("idx: " + idx + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        if (idx < this.glyphs.length - 1 && this.font != null) {
            float hkern = this.font.getHKern(this.glyphs[idx].getGlyphCode(), this.glyphs[idx + 1].getGlyphCode());
            float vkern = this.font.getVKern(this.glyphs[idx].getGlyphCode(), this.glyphs[idx + 1].getGlyphCode());
            return this.glyphs[idx].getGlyphMetrics(hkern, vkern);
        }
        return this.glyphs[idx].getGlyphMetrics();
    }

    public Shape getGlyphOutline(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[glyphIndex].getOutline();
    }

    public Rectangle2D getGlyphCellBounds(int glyphIndex) {
        return this.getGlyphLogicalBounds(glyphIndex).getBounds2D();
    }

    public Point2D getGlyphPosition(int glyphIndex) {
        if (glyphIndex == this.glyphs.length) {
            return this.endPos;
        }
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        return this.glyphs[glyphIndex].getPosition();
    }

    public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, float[] positionReturn) {
        if (numEntries < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + numEntries + ", is illegal. It must be > 0.");
        }
        if (beginGlyphIndex < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + beginGlyphIndex + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (beginGlyphIndex + numEntries > this.glyphs.length + 1) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + beginGlyphIndex + '+' + numEntries + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (positionReturn == null) {
            positionReturn = new float[numEntries * 2];
        }
        if (beginGlyphIndex + numEntries == this.glyphs.length + 1) {
            positionReturn[--numEntries * 2] = (float)this.endPos.getX();
            positionReturn[numEntries * 2 + 1] = (float)this.endPos.getY();
        }
        int i2 = beginGlyphIndex;
        while (i2 < beginGlyphIndex + numEntries) {
            Point2D glyphPos = this.glyphs[i2].getPosition();
            positionReturn[(i2 - beginGlyphIndex) * 2] = (float)glyphPos.getX();
            positionReturn[(i2 - beginGlyphIndex) * 2 + 1] = (float)glyphPos.getY();
            ++i2;
        }
        return positionReturn;
    }

    public AffineTransform getGlyphTransform(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        return this.glyphs[glyphIndex].getTransform();
    }

    public Shape getGlyphVisualBounds(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        return this.glyphs[glyphIndex].getOutline();
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator aci) {
        aci.first();
        TextPaintInfo tpi = (TextPaintInfo)aci.getAttribute(PAINT_INFO);
        if (this.bounds2D != null && TextPaintInfo.equivilent(tpi, this.cacheTPI)) {
            return this.bounds2D;
        }
        Rectangle2D b2 = null;
        if (tpi.visible) {
            int i2 = 0;
            while (i2 < this.getNumGlyphs()) {
                Rectangle2D glyphBounds;
                if (this.glyphVisible[i2] && (glyphBounds = this.glyphs[i2].getBounds2D()) != null) {
                    if (b2 == null) {
                        b2 = glyphBounds;
                    } else {
                        b2.add(glyphBounds);
                    }
                }
                ++i2;
            }
        }
        this.bounds2D = b2;
        if (this.bounds2D == null) {
            this.bounds2D = new Rectangle2D.Float();
        }
        this.cacheTPI = new TextPaintInfo(tpi);
        return this.bounds2D;
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath logicalBoundsPath = new GeneralPath();
            int i2 = 0;
            while (i2 < this.getNumGlyphs()) {
                Shape glyphLogicalBounds = this.getGlyphLogicalBounds(i2);
                if (glyphLogicalBounds != null) {
                    logicalBoundsPath.append(glyphLogicalBounds, false);
                }
                ++i2;
            }
            this.logicalBounds = logicalBoundsPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    public int getNumGlyphs() {
        if (this.glyphs != null) {
            return this.glyphs.length;
        }
        return 0;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            int i2 = 0;
            while (i2 < this.glyphs.length) {
                Shape glyphOutline;
                if (this.glyphVisible[i2] && (glyphOutline = this.glyphs[i2].getOutline()) != null) {
                    this.outline.append(glyphOutline, false);
                }
                ++i2;
            }
        }
        return this.outline;
    }

    public Shape getOutline(float x, float y) {
        Shape outline = this.getOutline();
        AffineTransform tr = AffineTransform.getTranslateInstance(x, y);
        Shape translatedOutline = tr.createTransformedShape(outline);
        return translatedOutline;
    }

    public Rectangle2D getGeometricBounds() {
        return this.getOutline().getBounds2D();
    }

    public void performDefaultLayout() {
        this.logicalBounds = null;
        this.outline = null;
        this.bounds2D = null;
        float currentX = 0.0f;
        float currentY = 0.0f;
        int i2 = 0;
        while (i2 < this.glyphs.length) {
            Glyph g2 = this.glyphs[i2];
            g2.setTransform(null);
            this.glyphLogicalBounds[i2] = null;
            String uni = g2.getUnicode();
            if (uni != null && uni.length() != 0 && ArabicTextHandler.arabicCharTransparent(uni.charAt(0))) {
                int j2 = i2 + 1;
                while (j2 < this.glyphs.length) {
                    char ch;
                    uni = this.glyphs[j2].getUnicode();
                    if (uni == null || uni.length() == 0 || !ArabicTextHandler.arabicCharTransparent(ch = uni.charAt(0))) break;
                    ++j2;
                }
                if (j2 != this.glyphs.length) {
                    Glyph bg = this.glyphs[j2];
                    float rEdge = currentX + bg.getHorizAdvX();
                    int k2 = i2;
                    while (k2 < j2) {
                        g2 = this.glyphs[k2];
                        g2.setTransform(null);
                        this.glyphLogicalBounds[i2] = null;
                        g2.setPosition(new Point2D.Float(rEdge - g2.getHorizAdvX(), currentY));
                        ++k2;
                    }
                    i2 = j2;
                    g2 = bg;
                }
            }
            g2.setPosition(new Point2D.Float(currentX, currentY));
            currentX += g2.getHorizAdvX();
            ++i2;
        }
        this.endPos = new Point2D.Float(currentX, currentY);
    }

    public void setGlyphPosition(int glyphIndex, Point2D newPos) throws IndexOutOfBoundsException {
        if (glyphIndex == this.glyphs.length) {
            this.endPos = (Point2D)newPos.clone();
            return;
        }
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        this.glyphs[glyphIndex].setPosition(newPos);
        this.glyphLogicalBounds[glyphIndex] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphTransform(int glyphIndex, AffineTransform newTX) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        this.glyphs[glyphIndex].setTransform(newTX);
        this.glyphLogicalBounds[glyphIndex] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphVisible(int glyphIndex, boolean visible) {
        if (visible == this.glyphVisible[glyphIndex]) {
            return;
        }
        this.glyphVisible[glyphIndex] = visible;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds[glyphIndex] = null;
    }

    public boolean isGlyphVisible(int glyphIndex) {
        return this.glyphVisible[glyphIndex];
    }

    public int getCharacterCount(int startGlyphIndex, int endGlyphIndex) {
        int numChars = 0;
        if (startGlyphIndex < 0) {
            startGlyphIndex = 0;
        }
        if (endGlyphIndex > this.glyphs.length - 1) {
            endGlyphIndex = this.glyphs.length - 1;
        }
        int i2 = startGlyphIndex;
        while (i2 <= endGlyphIndex) {
            Glyph glyph = this.glyphs[i2];
            if (glyph.getGlyphCode() == -1) {
                ++numChars;
            } else {
                String glyphUnicode = glyph.getUnicode();
                numChars += glyphUnicode.length();
            }
            ++i2;
        }
        return numChars;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator aci) {
        aci.first();
        TextPaintInfo tpi = (TextPaintInfo)aci.getAttribute(PAINT_INFO);
        if (!tpi.visible) {
            return;
        }
        int i2 = 0;
        while (i2 < this.glyphs.length) {
            if (this.glyphVisible[i2]) {
                this.glyphs[i2].draw(graphics2D);
            }
            ++i2;
        }
    }
}

