/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.RuntimeIOException;

public class BufferedLineReader
implements LineReader {
    private final BufferedReader reader;
    private int lineNumber = 0;
    private String peekedLine;

    public BufferedLineReader(InputStream is) {
        this(is, IOUtil.STANDARD_BUFFER_SIZE);
    }

    public BufferedLineReader(InputStream is, int bufferSize) {
        this.reader = new BufferedReader(new InputStreamReader(is), bufferSize);
    }

    @Override
    public String readLine() {
        ++this.lineNumber;
        try {
            String ret;
            if (this.peekedLine != null) {
                ret = this.peekedLine;
                this.peekedLine = null;
            } else {
                ret = this.reader.readLine();
            }
            return ret;
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int peek() {
        if (this.peekedLine == null) {
            try {
                this.peekedLine = this.reader.readLine();
            }
            catch (IOException e2) {
                throw new RuntimeIOException(e2);
            }
        }
        if (this.peekedLine == null) {
            return -1;
        }
        if (this.peekedLine.length() == 0) {
            return 10;
        }
        return this.peekedLine.charAt(0);
    }

    @Override
    public void close() {
        this.peekedLine = null;
        try {
            this.reader.close();
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }
}

