/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunner;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;

public class FJTaskRunnerGroup
implements Executor {
    protected final FJTaskRunner[] threads;
    protected final LinkedQueue entryQueue = new LinkedQueue();
    protected int activeCount = 0;
    protected int nstarted = 0;
    static final boolean COLLECT_STATS = true;
    long initTime = 0L;
    int entries = 0;
    static final int DEFAULT_SCAN_PRIORITY = 2;
    static final long SCANS_PER_SLEEP = 15L;
    static final long MAX_SLEEP_TIME = 100L;

    public FJTaskRunnerGroup(int n2) {
        this.threads = new FJTaskRunner[n2];
        this.initializeThreads();
        this.initTime = System.currentTimeMillis();
    }

    public void execute(Runnable runnable) throws InterruptedException {
        if (runnable instanceof FJTask) {
            this.entryQueue.put((FJTask)runnable);
        } else {
            this.entryQueue.put(new FJTask.Wrap(runnable));
        }
        this.signalNewTask();
    }

    public void executeTask(FJTask fJTask) {
        try {
            this.entryQueue.put(fJTask);
            this.signalNewTask();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void invoke(Runnable runnable) throws InterruptedException {
        InvokableFJTask invokableFJTask = new InvokableFJTask(runnable);
        this.entryQueue.put(invokableFJTask);
        this.signalNewTask();
        invokableFJTask.awaitTermination();
    }

    public void interruptAll() {
        Thread thread = Thread.currentThread();
        boolean bl = false;
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            FJTaskRunner fJTaskRunner = this.threads[i2];
            if (fJTaskRunner == thread) {
                bl = true;
                continue;
            }
            fJTaskRunner.interrupt();
        }
        if (bl) {
            thread.interrupt();
        }
    }

    public synchronized void setScanPriorities(int n2) {
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            FJTaskRunner fJTaskRunner = this.threads[i2];
            fJTaskRunner.setScanPriority(n2);
            if (fJTaskRunner.active) continue;
            fJTaskRunner.setPriority(n2);
        }
    }

    public synchronized void setRunPriorities(int n2) {
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            FJTaskRunner fJTaskRunner = this.threads[i2];
            fJTaskRunner.setRunPriority(n2);
            if (!fJTaskRunner.active) continue;
            fJTaskRunner.setPriority(n2);
        }
    }

    public int size() {
        return this.threads.length;
    }

    public synchronized int getActiveCount() {
        return this.activeCount;
    }

    public void stats() {
        long l2 = System.currentTimeMillis() - this.initTime;
        double d2 = (double)l2 / 1000.0;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        System.out.print("Thread\tQ Cap\tScans\tNew\tRuns\n");
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            FJTaskRunner fJTaskRunner = this.threads[i2];
            int n2 = fJTaskRunner.runs;
            l3 += (long)n2;
            int n3 = fJTaskRunner.scans;
            l4 += (long)n3;
            int n4 = fJTaskRunner.steals;
            l5 += (long)n4;
            String string = this.getActive(fJTaskRunner) ? "*" : " ";
            System.out.print("T" + i2 + string + "\t" + fJTaskRunner.deqSize() + "\t" + n3 + "\t" + n4 + "\t" + n2 + "\n");
        }
        System.out.print("Total\t    \t" + l4 + "\t" + l5 + "\t" + l3 + "\n");
        System.out.print("Execute: " + this.entries);
        System.out.print("\tTime: " + d2);
        long l6 = 0L;
        if (d2 != 0.0) {
            l6 = Math.round((double)l3 / d2);
        }
        System.out.println("\tRate: " + l6);
    }

    protected FJTaskRunner[] getArray() {
        return this.threads;
    }

    protected FJTask pollEntryQueue() {
        try {
            FJTask fJTask = (FJTask)this.entryQueue.poll(0L);
            return fJTask;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected synchronized boolean getActive(FJTaskRunner fJTaskRunner) {
        return fJTaskRunner.active;
    }

    protected synchronized void setActive(FJTaskRunner fJTaskRunner) {
        if (!fJTaskRunner.active) {
            fJTaskRunner.active = true;
            ++this.activeCount;
            if (this.nstarted < this.threads.length) {
                this.threads[this.nstarted++].start();
            } else {
                this.notifyAll();
            }
        }
    }

    protected synchronized void setInactive(FJTaskRunner fJTaskRunner) {
        if (fJTaskRunner.active) {
            fJTaskRunner.active = false;
            --this.activeCount;
        }
    }

    protected synchronized void checkActive(FJTaskRunner fJTaskRunner, long l2) {
        this.setInactive(fJTaskRunner);
        try {
            if (this.activeCount == 0 && this.entryQueue.peek() == null) {
                this.wait();
            } else {
                long l3 = l2 / 15L;
                if (l3 > 100L) {
                    l3 = 100L;
                }
                int n2 = l3 == 0L ? 1 : 0;
                this.wait(l3, n2);
            }
        }
        catch (InterruptedException interruptedException) {
            this.notify();
            Thread.currentThread().interrupt();
        }
    }

    protected synchronized void signalNewTask() {
        ++this.entries;
        if (this.nstarted < this.threads.length) {
            this.threads[this.nstarted++].start();
        } else {
            this.notify();
        }
    }

    protected void initializeThreads() {
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            this.threads[i2] = new FJTaskRunner(this);
        }
    }

    protected static final class InvokableFJTask
    extends FJTask {
        protected final Runnable wrapped;
        protected boolean terminated = false;

        protected InvokableFJTask(Runnable runnable) {
            this.wrapped = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.wrapped instanceof FJTask) {
                    FJTask.invoke((FJTask)this.wrapped);
                } else {
                    this.wrapped.run();
                }
            }
            finally {
                this.setTerminated();
            }
        }

        protected synchronized void setTerminated() {
            this.terminated = true;
            this.notifyAll();
        }

        protected synchronized void awaitTermination() throws InterruptedException {
            while (!this.terminated) {
                this.wait();
            }
        }
    }
}

