/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import org.broad.tribble.TribbleException;

public class GenotypeLikelihoods {
    public static final boolean CAP_PLS = false;
    public static final int PL_CAP = 255;
    private double[] log10Likelihoods = null;
    private String likelihoodsAsString_PLs = null;

    public static final GenotypeLikelihoods fromPLField(String PLs) {
        return new GenotypeLikelihoods(PLs);
    }

    public static final GenotypeLikelihoods fromGLField(String GLs) {
        return new GenotypeLikelihoods(GenotypeLikelihoods.parseDeprecatedGLString(GLs));
    }

    public static final GenotypeLikelihoods fromLog10Likelihoods(double[] log10Likelihoods) {
        return new GenotypeLikelihoods(log10Likelihoods);
    }

    protected GenotypeLikelihoods(String asString) {
        this.likelihoodsAsString_PLs = asString;
    }

    protected GenotypeLikelihoods(double[] asVector) {
        this.log10Likelihoods = asVector;
    }

    public double[] getAsVector() {
        if (this.log10Likelihoods == null) {
            this.log10Likelihoods = GenotypeLikelihoods.parsePLsIntoLikelihoods(this.likelihoodsAsString_PLs);
        }
        return this.log10Likelihoods;
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        if (this.likelihoodsAsString_PLs == null) {
            if (this.log10Likelihoods == null) {
                throw new TribbleException("BUG: Attempted to get likelihoods as strings and neither the vector nor the string is set!");
            }
            this.likelihoodsAsString_PLs = GenotypeLikelihoods.convertLikelihoodsToPLString(this.log10Likelihoods);
        }
        return this.likelihoodsAsString_PLs;
    }

    private static final double[] parsePLsIntoLikelihoods(String likelihoodsAsString_PLs) {
        if (!likelihoodsAsString_PLs.equals(".")) {
            String[] strings = likelihoodsAsString_PLs.split(",");
            double[] likelihoodsAsVector = new double[strings.length];
            for (int i2 = 0; i2 < strings.length; ++i2) {
                likelihoodsAsVector[i2] = (double)Integer.parseInt(strings[i2]) / -10.0;
            }
            return likelihoodsAsVector;
        }
        return null;
    }

    private static final double[] parseDeprecatedGLString(String GLString) {
        if (!GLString.equals(".")) {
            String[] strings = GLString.split(",");
            double[] likelihoodsAsVector = new double[strings.length];
            for (int i2 = 0; i2 < strings.length; ++i2) {
                likelihoodsAsVector[i2] = Double.parseDouble(strings[i2]);
            }
            return likelihoodsAsVector;
        }
        return null;
    }

    private static final String convertLikelihoodsToPLString(double[] GLs) {
        if (GLs == null) {
            return ".";
        }
        StringBuilder s = new StringBuilder();
        double adjust = Double.NEGATIVE_INFINITY;
        for (double l2 : GLs) {
            adjust = Math.max(adjust, l2);
        }
        boolean first = true;
        for (double l3 : GLs) {
            if (!first) {
                s.append(",");
            } else {
                first = false;
            }
            long PL = Math.round(-10.0 * (l3 - adjust));
            s.append(Long.toString(PL));
        }
        return s.toString();
    }
}

