/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.FeatureIterator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.interval.IntervalIndexCreator;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.index.linear.LinearIndexCreator;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class IndexFactory {
    private static Logger log = Logger.getLogger(IndexFactory.class);

    public static Index loadIndex(String indexFile) {
        Index idx = null;
        SeekableStream is = null;
        FilterInputStream dis = null;
        try {
            is = SeekableStreamFactory.getStreamFor(indexFile);
            dis = indexFile.endsWith(".gz") ? new LittleEndianInputStream(new GZIPInputStream(new BufferedInputStream(is))) : new LittleEndianInputStream(new BufferedInputStream(is));
            int magicNumber = ((LittleEndianInputStream)dis).readInt();
            int type = ((LittleEndianInputStream)dis).readInt();
            Class indexClass = IndexType.getIndexType(type).getIndexType();
            idx = (Index)indexClass.newInstance();
            idx.read((LittleEndianInputStream)dis);
            if (idx instanceof LinearIndex) {
                idx = ((LinearIndex)idx).optimize();
            }
        }
        catch (IOException ex) {
            throw new TribbleException.UnableToReadIndexFile("Unable to read index file", indexFile, ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e2) {
                log.error("Error closing indexFile: " + indexFile, e2);
            }
        }
        return idx;
    }

    public static Index createIndex(File inputFile, FeatureCodec codec, IndexBalanceApproach iba) {
        return IndexFactory.createIndex(inputFile, new FeatureIterator(inputFile, codec), new DynamicIndexCreator(iba));
    }

    public static Index createIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createIndex(inputFile, codec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static Index createIndex(File inputFile, FeatureIterator iterator, IndexCreator creator) {
        creator.initialize(inputFile, creator.defaultBinSize());
        while (iterator.hasNext()) {
            long position = iterator.getPosition();
            creator.addFeature(iterator.next(), position);
        }
        return creator.finalizeIndex(iterator.getPosition());
    }

    private static Index createIndexOfType(File inputFile, FeatureCodec codec, IndexCreator creator) {
        return IndexFactory.createIndex(inputFile, new FeatureIterator(inputFile, codec), creator);
    }

    public static Index createLinearIndex(File inputFile, FeatureCodec codec) {
        LinearIndexCreator idx = new LinearIndexCreator();
        idx.initialize(inputFile, idx.defaultBinSize());
        return IndexFactory.createIndexOfType(inputFile, codec, idx);
    }

    public static Index createLinearIndex(File inputFile, FeatureCodec codec, int binSize) {
        LinearIndexCreator idx = new LinearIndexCreator();
        idx.initialize(inputFile, binSize);
        return IndexFactory.createIndexOfType(inputFile, codec, idx);
    }

    public static Index createIntervalIndex(File inputFile, FeatureCodec codec) {
        IntervalIndexCreator idx = new IntervalIndexCreator();
        idx.initialize(inputFile, idx.defaultBinSize());
        return IndexFactory.createIndexOfType(inputFile, codec, idx);
    }

    public static Index createIntervalIndex(File inputFile, FeatureCodec codec, int binSize) {
        IntervalIndexCreator idx = new IntervalIndexCreator();
        idx.initialize(inputFile, binSize);
        return IndexFactory.createIndexOfType(inputFile, codec, idx);
    }

    public static enum IndexType {
        LINEAR(1, new LinearIndexCreator(), LinearIndex.class),
        INTERVAL_TREE(2, new IntervalIndexCreator(), IntervalTreeIndex.class);

        private final int indexValue;
        private final IndexCreator indexCreator;
        private final Class indexType;

        private IndexType(int headerValue, IndexCreator creator, Class indexClass) {
            this.indexValue = headerValue;
            this.indexCreator = creator;
            this.indexType = indexClass;
        }

        public int getHeaderValue() {
            return this.indexValue;
        }

        public IndexCreator getIndexCreator() {
            return this.indexCreator;
        }

        public Class getIndexType() {
            return this.indexType;
        }

        public static IndexType getIndexType(int headerValue) {
            for (IndexType type : IndexType.values()) {
                if (type.indexValue != headerValue) continue;
                return type;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type value" + headerValue);
        }
    }

    public static enum IndexBalanceApproach {
        FOR_SIZE,
        FOR_SEEK_TIME;

    }
}

