/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class SwitchingLabelUI
extends BasicLabelUI {
    private int verticalInset;
    private Orientation orientation = null;
    private boolean clockwise = false;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public SwitchingLabelUI(int verticalInset) {
        this.verticalInset = verticalInset;
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension dim = super.getPreferredSize(c2);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        JLabel label = (JLabel)c2;
        if (label.getWidth() > label.getHeight()) {
            if (this.orientation != Orientation.Horizontal) {
                label.setHorizontalAlignment(0);
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.orientation = Orientation.Horizontal;
            }
            super.paint(g2, c2);
        } else {
            Icon icon;
            if (this.orientation != Orientation.Vertical) {
                label.setHorizontalAlignment(2);
                label.setBorder(BorderFactory.createEmptyBorder(0, this.verticalInset, 0, 0));
                this.orientation = Orientation.Vertical;
            }
            String text = label.getText();
            Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            if (icon == null && text == null) {
                return;
            }
            FontMetrics fm = g2.getFontMetrics();
            paintViewInsets = c2.getInsets(paintViewInsets);
            SwitchingLabelUI.paintViewR.x = SwitchingLabelUI.paintViewInsets.left;
            SwitchingLabelUI.paintViewR.y = SwitchingLabelUI.paintViewInsets.top;
            SwitchingLabelUI.paintViewR.height = c2.getWidth() - (SwitchingLabelUI.paintViewInsets.left + SwitchingLabelUI.paintViewInsets.right);
            SwitchingLabelUI.paintViewR.width = c2.getHeight() - (SwitchingLabelUI.paintViewInsets.top + SwitchingLabelUI.paintViewInsets.bottom);
            SwitchingLabelUI.paintIconR.height = 0;
            SwitchingLabelUI.paintIconR.width = 0;
            SwitchingLabelUI.paintIconR.y = 0;
            SwitchingLabelUI.paintIconR.x = 0;
            SwitchingLabelUI.paintTextR.height = 0;
            SwitchingLabelUI.paintTextR.width = 0;
            SwitchingLabelUI.paintTextR.y = 0;
            SwitchingLabelUI.paintTextR.x = 0;
            String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
            Graphics2D g22 = (Graphics2D)g2;
            AffineTransform tr = g22.getTransform();
            if (this.clockwise) {
                g22.rotate(1.5707963267948966);
                g22.translate(0, -c2.getWidth());
            } else {
                g22.rotate(-1.5707963267948966);
                g22.translate(-c2.getHeight(), 0);
            }
            if (icon != null) {
                icon.paintIcon(c2, g2, SwitchingLabelUI.paintIconR.x, SwitchingLabelUI.paintIconR.y);
            }
            if (text != null) {
                int textX = SwitchingLabelUI.paintTextR.x;
                int textY = SwitchingLabelUI.paintTextR.y + fm.getAscent();
                if (label.isEnabled()) {
                    this.paintEnabledText(label, g2, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, g2, clippedText, textX, textY);
                }
            }
            g22.setTransform(tr);
        }
    }

    static enum Orientation {
        Horizontal,
        Vertical;

    }
}

