/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.scatterplot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScatterData {
    private int count;
    private Map<String, double[]> dataMap;
    private Map<String, String[]> symbolMap;
    String[] samples;

    public ScatterData(int count, String[] samples, Map<String, double[]> dataMap, Map<String, String[]> symbolMap) {
        this.count = count;
        this.samples = samples;
        this.dataMap = dataMap;
        this.symbolMap = symbolMap;
    }

    public int getCount() {
        return this.count;
    }

    public List<String> getLabels() {
        return new ArrayList<String>(this.dataMap.keySet());
    }

    public double[] getData(String label) {
        return this.dataMap.get(label);
    }

    public String[] getSymbols(String label) {
        return this.symbolMap.get(label);
    }

    public String[] getSamples() {
        return this.samples;
    }

    public static ScatterData getTestData() {
        int count = 300;
        double[] cnData = new double[count];
        double[] exprData = new double[count];
        double[] methData = new double[count];
        String[] treated = new String[count];
        String[] hyperMutated = new String[count];
        String[] samples = new String[count];
        for (int i2 = 0; i2 < count; ++i2) {
            samples[i2] = "Sample " + i2;
            cnData[i2] = (double)i2 / (double)count * 4.0 * (2.0 * Math.random());
            exprData[i2] = -2.0 + (double)i2 / (double)count * 4.0 * (2.0 * Math.random());
            methData[i2] = 1.0 - (double)i2 * Math.random() / (double)count;
            treated[i2] = Math.random() > 0.5 ? "AA" : "B";
            hyperMutated[i2] = Math.random() > 0.9 ? "Y" : "N";
            System.out.println(cnData[i2] + "\t" + exprData[i2] + "\t" + methData[i2]);
        }
        LinkedHashMap<String, double[]> dataMap = new LinkedHashMap<String, double[]>();
        dataMap.put("Copy number", cnData);
        dataMap.put("Expression", exprData);
        dataMap.put("Methylation", methData);
        LinkedHashMap<String, String[]> symbolMap = new LinkedHashMap<String, String[]>();
        symbolMap.put("Treated", treated);
        symbolMap.put("Hyper mutatated", hyperMutated);
        return new ScatterData(count, samples, dataMap, symbolMap);
    }

    public static void main(String[] args) {
        ScatterData sd = ScatterData.getTestData();
        for (String l2 : sd.getLabels()) {
            System.out.println(l2);
        }
    }
}

