/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.renderer.AbstractColorScale;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.MonocolorScale;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.broad.tribble.readers.AsciiLineReader;

public class AttributeManager {
    private static Logger log = Logger.getLogger(AttributeManager.class);
    private static AttributeManager singleton;
    public static final String ATTRIBUTES_LOADED_PROPERTY = "ATTRIBUTES_LOADED_PROPERTY";
    public static final String ATTRIBUTES_NARROWED_PROPERTY = "ATTRIBUTES_NARROWED_PROPERTY";
    private PropertyChangeSupport propertyChangeSupport;
    Set<ResourceLocator> loadedResources = new HashSet<ResourceLocator>();
    LinkedHashMap<String, Map<String, String>> attributeMap = new LinkedHashMap();
    LinkedHashSet<String> attributeNames = new LinkedHashSet();
    Map<String, ColumnMetaData> columnMetaData = new HashMap<String, ColumnMetaData>();
    Map<String, Set<String>> uniqueAttributeValues;
    Map<String, Color> colorMap = new Hashtable<String, Color>();
    Map<String, AbstractColorScale> colorScales = new HashMap<String, AbstractColorScale>();
    Map<String, Integer> colorCounter = new HashMap<String, Integer>();

    private AttributeManager() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.uniqueAttributeValues = new HashMap<String, Set<String>>();
    }

    public static synchronized AttributeManager getInstance() {
        if (singleton == null) {
            singleton = new AttributeManager();
        }
        return singleton;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getAttribute(String trackName, String attributeName) {
        Map<String, String> attributes = this.attributeMap.get(trackName);
        String key = attributeName.toUpperCase();
        return attributes == null ? null : attributes.get(key);
    }

    public List<String> getAttributeNames() {
        return new ArrayList<String>(this.attributeNames);
    }

    boolean isNumeric(String attributeName) {
        String key = attributeName.toUpperCase();
        ColumnMetaData metaData = this.columnMetaData.get(key);
        return metaData != null && metaData.isNumeric();
    }

    public List<String> getVisibleAttributes() {
        List<String> keys = this.getAttributeNames();
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        if (hiddenAttributes != null) {
            keys.removeAll(hiddenAttributes);
        }
        return keys;
    }

    public void clearAllAttributes() {
        this.attributeMap.clear();
        this.attributeNames.clear();
        this.uniqueAttributeValues.clear();
        this.loadedResources = new HashSet<ResourceLocator>();
    }

    private void addAttribute(String trackIdentifier, String name, String attributeValue) {
        if (attributeValue.equals("")) {
            return;
        }
        String key = name.toUpperCase();
        this.addAttributeName(name);
        Set<String> uniqueSet = this.uniqueAttributeValues.get(key);
        if (uniqueSet == null) {
            uniqueSet = new HashSet<String>();
            this.uniqueAttributeValues.put(key, uniqueSet);
        }
        uniqueSet.add(attributeValue);
        Map<String, String> attributes = this.attributeMap.get(trackIdentifier);
        if (attributes == null) {
            attributes = new LinkedHashMap<String, String>();
            this.attributeMap.put(trackIdentifier, attributes);
        }
        attributes.put(key, attributeValue);
        this.updateMetaData(key, attributeValue);
    }

    public void addAttributeName(String name) {
        if (!this.attributeNames.contains(name) && !name.startsWith("#")) {
            this.attributeNames.add(name);
        }
    }

    private void updateMetaData(String attributeName, String attributeValue) {
        String key = attributeName.toUpperCase();
        ColumnMetaData metaData = this.columnMetaData.get(key);
        if (metaData == null) {
            metaData = new ColumnMetaData();
            this.columnMetaData.put(key, metaData);
        }
        if (metaData.isNumeric()) {
            try {
                double val = Double.parseDouble(attributeValue);
                metaData.updateRange(val);
            }
            catch (NumberFormatException e2) {
                metaData.addNonNumericLabel(attributeValue);
            }
        }
    }

    public static boolean isSampleInfoFile(ResourceLocator locator) throws IOException {
        if (!FileUtils.isTabDelimited(locator, 2)) {
            return false;
        }
        int oneMB = 1000000;
        long fileLength = 0L;
        if (locator.isLocal()) {
            File f2 = new File(locator.getPath());
            fileLength = f2.length();
        } else if (locator.getPath().startsWith("http")) {
            fileLength = IGVHttpClientUtils.getContentLength(new URL(locator.getPath()));
        }
        if (fileLength > 1000000L) {
            return MessageUtils.confirm("<html>Cannot determine file type of: " + locator.getPath() + "<br>Is this a sample information file?");
        }
        return true;
    }

    public void loadSampleInfo(ResourceLocator locator) {
        AsciiLineReader reader = null;
        String nextLine = null;
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            nextLine = reader.readLine();
            if (nextLine.toLowerCase().startsWith("#sampletable")) {
                this.loadSampleTable(reader, nextLine, locator.getPath());
            } else {
                this.loadOldSampleInfo(reader, nextLine, locator.getPath());
            }
            this.loadedResources.add(locator);
            IGV.getInstance().getTrackManager().resetOverlayTracks();
            IGV.getInstance().doRefresh();
        }
        catch (IOException ex) {
            log.error("Error loading attribute file", ex);
            throw new DataLoadException("Error reading attribute file", locator.getPath());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            this.firePropertyChange(this, ATTRIBUTES_LOADED_PROPERTY, null, null);
        }
    }

    private void loadOldSampleInfo(AsciiLineReader reader, String nextLine, String path) throws IOException {
        boolean foundAttributes = false;
        String[] colHeadings = nextLine.split("\t");
        int nLines = 0;
        int lineLimit = 100000;
        while ((nextLine = reader.readLine()) != null && nLines++ <= lineLimit) {
            if (nextLine.startsWith("#colors")) {
                this.parseColors(reader);
                return;
            }
            String[] values = nextLine.split("\t");
            if (values.length < 2) continue;
            String arrayName = values[0].trim();
            for (int i2 = 0; i2 < colHeadings.length; ++i2) {
                String attributeName = colHeadings[i2].trim();
                String attributeValue = i2 < values.length ? values[i2].trim() : "";
                this.addAttribute(arrayName, attributeName, attributeValue);
                foundAttributes = true;
            }
        }
        if (!foundAttributes) {
            throw new DataLoadException("Could not determine file type.  Does file have proper extension? ", path);
        }
    }

    private void parseColors(AsciiLineReader reader) throws IOException {
        String nextLine;
        while ((nextLine = reader.readLine()) != null) {
            try {
                String[] tokens = nextLine.split("\t");
                if (tokens.length < 3) continue;
                String attKey = tokens[0].toUpperCase();
                if (this.isNumeric(attKey)) {
                    String[] tmp;
                    ColumnMetaData metaData = this.columnMetaData.get(attKey);
                    String rangeString = tokens[1].trim();
                    float min = (float)metaData.min;
                    float max = (float)metaData.max;
                    if (!rangeString.equals("*") && rangeString.length() > 0 && (tmp = rangeString.split(":")).length > 1) {
                        try {
                            min = Float.parseFloat(tmp[0]);
                            max = Float.parseFloat(tmp[1]);
                        }
                        catch (NumberFormatException e2) {
                            log.error("Error parsing range string: " + rangeString, e2);
                        }
                    }
                    AbstractColorScale scale = null;
                    if (tokens.length == 3) {
                        Color baseColor = ColorUtilities.stringToColor(tokens[2]);
                        scale = new MonocolorScale(min, max, baseColor);
                        this.colorScales.put(attKey, scale);
                    } else {
                        Color color1 = ColorUtilities.stringToColor(tokens[2]);
                        Color color2 = ColorUtilities.stringToColor(tokens[3]);
                        scale = min < 0.0f ? new ContinuousColorScale(min, 0.0, max, color1, Color.white, color2) : new ContinuousColorScale(min, max, color1, color2);
                    }
                    this.colorScales.put(attKey, scale);
                    continue;
                }
                String attValue = tokens[1];
                Color color = ColorUtilities.stringToColor(tokens[2]);
                String key = (attKey + "_" + attValue).toUpperCase();
                this.colorMap.put(key, color);
            }
            catch (Exception e3) {
                log.error("Error parsing color line: " + nextLine, e3);
            }
        }
    }

    private void loadSampleTable(AsciiLineReader reader, String nextLine, String path) throws IOException {
        String sample;
        nextLine = reader.readLine();
        String[] colHeadings = nextLine.split("\t");
        HashMap sampleTable = new HashMap();
        boolean foundAttributes = false;
        int nLines = 0;
        int lineLimit = 100000;
        while ((nextLine = reader.readLine()) != null && nLines++ <= lineLimit && !nextLine.toLowerCase().startsWith("#samplemapping")) {
            if (nextLine.toLowerCase().startsWith("#colors")) {
                this.parseColors(reader);
                break;
            }
            String[] values = nextLine.split("\t");
            if (values.length < 2) continue;
            String sampleName = values[0].trim();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(colHeadings.length);
            for (int i2 = 0; i2 < colHeadings.length; ++i2) {
                String attributeName = colHeadings[i2].trim();
                String attributeValue = i2 < values.length ? values[i2].trim() : "";
                attributes.add(new Attribute(attributeName, attributeValue));
                foundAttributes = true;
            }
            sampleTable.put(sampleName, attributes);
        }
        if (!foundAttributes) {
            throw new DataLoadException("Could not determine file type.  Does file have proper extension? ", path);
        }
        if (nextLine.toLowerCase().startsWith("#samplemapping")) {
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.toLowerCase().startsWith("#colors")) {
                    this.parseColors(reader);
                    break;
                }
                String[] tokens = nextLine.split("\t");
                if (tokens.length < 2) continue;
                String array = tokens[0];
                sample = tokens[1];
                List attributes = (List)sampleTable.get(sample);
                if (attributes == null) {
                    log.info("Warning: sample in mapping section:  " + sample + " in sample table file " + path);
                    continue;
                }
                for (Attribute att : attributes) {
                    this.addAttribute(array, att.getKey(), att.getValue());
                }
            }
        } else {
            for (Map.Entry entry : sampleTable.entrySet()) {
                sample = (String)entry.getKey();
                for (Attribute att : (List)entry.getValue()) {
                    this.addAttribute(sample, att.getKey(), att.getValue());
                }
            }
        }
    }

    public void firePropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        this.propertyChangeSupport.firePropertyChange(event);
    }

    public Comparator getAttributeComparator() {
        return Utilities.getNumericStringComparator();
    }

    public Set<ResourceLocator> getLoadedResources() {
        return this.loadedResources;
    }

    public Color getColor(String attKey, String attValue) {
        AbstractColorScale cs;
        if (attValue == null || attValue.length() == 0) {
            return Color.white;
        }
        if (this.isNumeric(attKey) && (cs = this.colorScales.get(attKey)) != null) {
            try {
                float x = Float.parseFloat(attValue);
                return cs.getColor(x);
            }
            catch (NumberFormatException e2) {
                return Color.white;
            }
        }
        String key = (attKey + "_" + attValue).toUpperCase();
        Color c2 = this.colorMap.get(key);
        if (c2 == null && (c2 = this.colorMap.get(key = ("*_" + attValue).toUpperCase())) == null) {
            key = (attValue + "_*").toUpperCase();
            c2 = this.colorMap.get(key);
            if (c2 == null) {
                Integer cnt = this.colorCounter.get(attKey);
                if (cnt == null) {
                    cnt = 0;
                }
                Integer n2 = cnt;
                Integer n3 = cnt = Integer.valueOf(cnt + 1);
                this.colorCounter.put(attKey, cnt);
                c2 = AttributeManager.randomColor(cnt);
            }
            this.colorMap.put(key, c2);
        }
        return c2;
    }

    public static Color randomColor(int idx) {
        float hue = (float)Math.random();
        float sat = (float)(0.8 * Math.random());
        float bri = (float)(0.6 + 0.4 * Math.random());
        return Color.getHSBColor(hue, sat, bri);
    }

    static class Range {
        double min;
        double max;
        Color color;

        Range() {
        }
    }

    static class ColumnMetaData {
        Set<String> nonNumericLabels = new HashSet<String>();
        double min = Double.MAX_VALUE;
        double max = -this.min;

        ColumnMetaData() {
        }

        void updateRange(double value) {
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
        }

        public boolean isNumeric() {
            return this.nonNumericLabels.size() <= 1;
        }

        public void addNonNumericLabel(String label) {
            this.nonNumericLabels.add(label);
        }
    }

    private static class Attribute {
        private String key;
        private String value;

        public Attribute(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

