/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.igv.peaks.Peak;
import org.broad.igv.util.ParsingUtils;

public class PeakCodec
extends UCSCCodec {
    public Peak decode(String nextLine) {
        if (nextLine.trim().length() == 0 || nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        int tokenCount = ParsingUtils.splitWhitespace(nextLine, this.tokens);
        String[] tokens = nextLine.split("\t");
        String chr = tokens[0];
        int start = Integer.parseInt(tokens[1]);
        int end = Integer.parseInt(tokens[2]);
        String name = tokens[3];
        float combinedScore = Float.parseFloat(tokens[4]);
        int nTimePoints = tokenCount - 5;
        float[] timePointScores = new float[nTimePoints];
        for (int i2 = 0; i2 < nTimePoints; ++i2) {
            timePointScores[i2] = Float.parseFloat(tokens[5 + i2]);
        }
        return new Peak(chr, start, end, name, combinedScore, timePointScores);
    }
}

